/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.TextBuffer;

public class TextRange
implements Comparable {
    private TextBuffer buffer;
    private OffsetMark startOffset;
    private OffsetMark endOffset;

    public TextRange(TextBuffer buffer, int startOffset, int endOffset) {
        this.buffer = buffer;
        this.startOffset = buffer.addOffsetMark(startOffset, false);
        this.endOffset = buffer.addOffsetMark(endOffset, true);
    }

    public void dispose() {
        if (this.buffer != null) {
            this.buffer.removeOffsetMark(this.startOffset);
            this.buffer.removeOffsetMark(this.endOffset);
        }
        this.buffer = null;
        this.startOffset = null;
        this.endOffset = null;
    }

    public int compareTo(Object o) {
        if (!(o instanceof TextRange)) {
            throw new ClassCastException();
        }
        TextRange compareRange = (TextRange)o;
        if (this.startOffset.getOffset() < compareRange.startOffset.getOffset()) {
            return -1;
        }
        if (this.startOffset.getOffset() > compareRange.startOffset.getOffset()) {
            return 1;
        }
        return 0;
    }

    public int getStartOffset() {
        return this.startOffset.getOffset();
    }

    public int getEndOffset() {
        return this.endOffset.getOffset();
    }

    public int getLength() {
        return this.getEndOffset() - this.getStartOffset() + 1;
    }

    public boolean contains(int offset) {
        if (this.startOffset == null || this.endOffset == null) {
            return false;
        }
        if (offset < this.startOffset.getOffset()) {
            return false;
        }
        return offset <= this.endOffset.getOffset();
    }

    public String getText() throws IndexOutOfBoundsException {
        int start = this.startOffset.getOffset();
        int len = this.getEndOffset() - this.getStartOffset();
        return this.buffer.getString(start, len);
    }

    public String toString() {
        try {
            return "[" + this.getStartOffset() + "," + this.getEndOffset() + "] : " + this.getText();
        }
        catch (Exception e) {
            return "[]";
        }
    }
}

