/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.find;

import java.awt.Color;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import oracle.javatools.editor.BasicEditorOverview;
import oracle.javatools.editor.BasicEditorOverviewMark;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.find.Find;
import oracle.javatools.editor.find.FindCriteria;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.resource.BundleHelper;

public final class FindUtils {
    public static final int DEFAULT_FIND_PRIORITY = 77;
    public static final String HIGHLIGHT_FIND_RESULT = "find-results-highlight";
    static final String PROPERTY_FIND_HIGHLIGHT_LAYER = "find-highlight-layer";
    private static final Color HIGHLIGHT_COLOR = new Color(255, 220, 255);
    private static final Color OVERVIEW_COLOR = new Color(255, 220, 255);
    private static final Object FIND_OVERVIEW_GROUP = new Object();
    private static HighlightStyle findStyle;

    public static void registerHighlights() {
        if (findStyle == null) {
            EditorProperties properties = EditorProperties.getProperties();
            HighlightRegistry registry = properties.getHighlightRegistry();
            BundleHelper resources = EditorProperties.getEditorBundle();
            String name = resources.getString("FIND_OCCURRENCE_HIGHLIGHT");
            findStyle = registry.createStyle(HIGHLIGHT_FIND_RESULT, name, 77, Color.black, HIGHLIGHT_COLOR);
        }
    }

    public static HighlightStyle getFindStyle() {
        return findStyle;
    }

    public static Pattern getRegExPattern(FindCriteria criteria) throws PatternSyntaxException {
        Pattern pattern = null;
        int matchFlags = 8;
        if (!criteria.isMatchCase()) {
            matchFlags |= 0x42;
        }
        if (!criteria.isRegEx()) {
            matchFlags |= 0x10;
        }
        pattern = Pattern.compile(criteria.getText(), matchFlags);
        return pattern;
    }

    public static String substituteSpecial(String replaceText) {
        StringBuffer buffer = new StringBuffer();
        int offset = 0;
        int length = replaceText.length();
        while (offset < length) {
            int index = replaceText.indexOf(92, offset);
            if (index == -1) {
                buffer.append(replaceText.substring(offset));
                break;
            }
            buffer.append(replaceText.substring(offset, index));
            offset = index;
            int indexDigit = index + 1;
            if (indexDigit < length) {
                char c = replaceText.charAt(indexDigit);
                switch (c) {
                    case '\\': {
                        buffer.append('\\');
                        break;
                    }
                    case 'n': 
                    case 'r': {
                        buffer.append('\n');
                        break;
                    }
                    case 't': {
                        buffer.append('\t');
                        break;
                    }
                    default: {
                        buffer.append(replaceText.substring(offset, offset + 2));
                    }
                }
                offset += 2;
                continue;
            }
            buffer.append(replaceText.substring(offset, offset + 1));
            ++offset;
        }
        String substituteText = buffer.toString();
        return substituteText;
    }

    public static void clearHighlights(BasicEditorPane editor) {
        BasicEditorOverview overview;
        HighlightLayer highlightLayer = (HighlightLayer)editor.getProperty(PROPERTY_FIND_HIGHLIGHT_LAYER);
        if (highlightLayer != null) {
            highlightLayer.removeAllHighlights();
        }
        if ((overview = (BasicEditorOverview)((Object)editor.getProperty("overview"))) != null) {
            overview.removeMarks(FIND_OVERVIEW_GROUP);
        }
    }

    public static void highlight(BasicEditorPane editor, List<Find> finds) {
        HighlightLayer highlightLayer = (HighlightLayer)editor.getProperty(PROPERTY_FIND_HIGHLIGHT_LAYER);
        if (highlightLayer == null) {
            highlightLayer = editor.createHighlightLayer();
            editor.putProperty(PROPERTY_FIND_HIGHLIGHT_LAYER, highlightLayer);
        }
        BasicEditorOverview overview = (BasicEditorOverview)((Object)editor.getProperty("overview"));
        for (Find find : finds) {
            highlightLayer.addHighlight(findStyle, find.getStartOffset(), find.getEndOffset());
            if (overview == null) continue;
            overview.addMark(new BasicEditorOverviewMark(editor, find.getStartOffset(), find.getEndOffset(), 77.0f, new Color(-10497), false, true), FIND_OVERVIEW_GROUP);
        }
    }

    static {
        FindUtils.registerHighlights();
    }
}

