/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.find;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.BadLocationException;
import oracle.bali.ewt.olaf2.OracleLookAndFeel;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.FeedbackManager;
import oracle.javatools.editor.Utilities;
import oracle.javatools.editor.find.Find;
import oracle.javatools.editor.find.FindBundle;
import oracle.javatools.editor.find.FindCriteria;
import oracle.javatools.editor.find.FindResult;
import oracle.javatools.editor.find.FindUtils;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.ui.internal.UICUtils;

public final class Finder {
    private static final int HIGHLIGH_LIMIT = 250;
    private final BasicEditorPane editor;

    public Finder(BasicEditorPane editor) {
        assert (editor != null);
        this.editor = editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Find> findAll(FindCriteria criteria) {
        assert (criteria != null);
        if (this.editor.getDocument().getLength() == 0 || criteria.getText().length() == 0) {
            return Collections.emptyList();
        }
        if (criteria.getUpperBound() > 0 && criteria.getUpperBound() <= criteria.getLowerBound()) {
            throw new IllegalStateException("End offset (" + criteria.getUpperBound() + ")," + " is less than start offset (" + criteria.getLowerBound() + ")");
        }
        List<Find> finds = null;
        BasicDocument document = (BasicDocument)this.editor.getDocument();
        document.readLock();
        try {
            finds = this.findRegEx(criteria);
        }
        finally {
            document.readUnlock();
        }
        finds = this.trim(finds);
        return finds;
    }

    private List<Find> findRegEx(FindCriteria criteria) {
        ArrayList<Find> finds = new ArrayList<Find>();
        Pattern pattern = null;
        try {
            pattern = FindUtils.getRegExPattern(criteria);
        }
        catch (PatternSyntaxException pse) {
            return Collections.emptyList();
        }
        String text = "";
        try {
            BasicDocument document = (BasicDocument)this.editor.getDocument();
            text = document.getText(0, document.getLength());
        }
        catch (BadLocationException e) {
            throw new IllegalStateException("Bad document size", e);
        }
        int startLocation = 0;
        int endLocation = text.length() - 1;
        Matcher matcher = pattern.matcher(text);
        boolean match = matcher.find(Math.max(0, startLocation));
        while (match) {
            MatchResult result = matcher.toMatchResult();
            int start = result.start();
            int length = result.end() - result.start();
            if (start >= endLocation) break;
            boolean isOK = true;
            if (criteria.isWholeWord() && !this.isWholeWordMatch(start, length)) {
                isOK = false;
            }
            if (criteria.getLowerBound() >= 0 && start < criteria.getLowerBound()) {
                isOK = false;
            }
            if (criteria.getUpperBound() >= 0 && start + length > criteria.getUpperBound()) {
                isOK = false;
            }
            if (isOK) {
                finds.add(new Find(start, matcher.end()));
            }
            match = matcher.find();
        }
        return finds;
    }

    private List<Find> trim(List<Find> finds) {
        int vStart = this.editor.getValidOffsetStart();
        int vEnd = this.editor.getValidOffsetEnd();
        if (vStart > 0 || vEnd > -1) {
            ArrayList<Find> validFinds = new ArrayList<Find>();
            for (Find f : finds) {
                if (vStart > 0 && f.getStartOffset() < vStart || vEnd > 0 && f.getEndOffset() > vEnd) continue;
                validFinds.add(f);
            }
            finds = validFinds;
        }
        return finds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWholeWordMatch(int startOffset, int length) {
        Boolean b = EditorProperties.getProperties().getBooleanProperty("word-boundary-use-case");
        try {
            EditorProperties.getProperties().putBooleanProperty("word-boundary-use-case", Boolean.FALSE);
            BasicDocument document = (BasicDocument)this.editor.getDocument();
            int endOffset = startOffset + length;
            int wordStart = Utilities.getWordStart(document, startOffset);
            int wordEnd = Utilities.getWordEnd(document, endOffset - 1);
            boolean bl = wordStart == startOffset && wordEnd == endOffset;
            return bl;
        }
        finally {
            EditorProperties.getProperties().putBooleanProperty("word-boundary-use-case", b);
        }
    }

    public FindResult find(FindCriteria criteria) {
        FindUtils.clearHighlights(this.editor);
        List<Find> finds = this.findAll(criteria);
        if (finds.isEmpty()) {
            return null;
        }
        Find result = null;
        switch (criteria.getDirection()) {
            case FORWARD: {
                int pos = criteria.getLocation();
                if (pos < 0) {
                    pos = Math.max(this.editor.getSelectionStart(), this.editor.getSelectionEnd());
                }
                for (Find find : finds) {
                    if (find.getStartOffset() < pos) continue;
                    result = find;
                    break;
                }
                if (result != null || !criteria.isWrap()) break;
                result = finds.get(0);
                break;
            }
            case BACKWARD: {
                int pos = criteria.getLocation();
                if (pos < 0) {
                    pos = Math.min(this.editor.getSelectionStart(), this.editor.getSelectionEnd());
                }
                Find prevFind = null;
                for (Find find : finds) {
                    if (find.getEndOffset() > pos) {
                        result = prevFind;
                        break;
                    }
                    prevFind = find;
                }
                Find lastFind = finds.get(finds.size() - 1);
                if ((result != null || !criteria.isWrap()) && lastFind.getEndOffset() >= pos) break;
                result = lastFind;
                break;
            }
        }
        FindUtils.clearHighlights(this.editor);
        if (criteria.isHighlight()) {
            if (finds.size() > 250) {
                FeedbackManager fm = this.editor.getFeedbackManager();
                if (fm != null) {
                    fm.showFeedback(this.editor, FindBundle.format("FEEDBACK_FIND_HIGHLIGHT_TOO_MANY", 250), 3000);
                }
            } else {
                FindUtils.highlight(this.editor, finds);
            }
        }
        return new FindResult(finds, result);
    }

    static void showErrorDialog(BasicEditorPane editor, String searchText) {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        String notFoundText = FindBundle.format("FD_NOTFOUND", searchText);
        String errorTitle = FindBundle.get("FD_RESULT_TITLE");
        MessageDialog.information(editor, notFoundText, errorTitle, "f1_idedfindreplacenotfound_html");
    }

    public static void main(String[] args) {
        new FinderTester();
    }

    private static class FinderTester {
        private JTextField tf;
        private JLabel feedback = new JLabel();
        private BasicEditorPane editor;
        private HighlightLayer highlightLayer;
        private HighlightStyle highlightStyle;
        private JCheckBox caseCheck = new JCheckBox("Match Case");
        private JCheckBox wordCheck = new JCheckBox("Whole Word");
        private JCheckBox startCheck = new JCheckBox("Start at Caret");
        private JCheckBox markCheck = new JCheckBox("End at Mark");
        private JCheckBox regExCheck = new JCheckBox("RegEx");

        public FinderTester() {
            this.startCheck.setSelected(false);
            try {
                UIManager.setLookAndFeel((LookAndFeel)new OracleLookAndFeel());
            }
            catch (UnsupportedLookAndFeelException e) {
                // empty catch block
            }
            this.editor = new BasicEditorPane();
            this.highlightLayer = this.editor.createHighlightLayer();
            this.highlightStyle = this.editor.getHighlightRegistry().createStyle("HIGHLOIGHT", "hi", 1000, null, Color.YELLOW);
            StringBuilder sb = new StringBuilder();
            int i = 0;
            for (Locale l : Locale.getAvailableLocales()) {
                sb.append(l.getDisplayCountry());
                sb.append(" ");
                if (i++ % 5 != 0) continue;
                sb.append("\n");
            }
            this.editor.setText(sb.toString());
            JPanel findPanel = new JPanel(new FlowLayout());
            findPanel.setOpaque(false);
            this.tf = new JTextField(14);
            this.tf.setHorizontalAlignment(2);
            String ENTER = "enter";
            this.tf.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), ENTER);
            this.tf.getActionMap().put(ENTER, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FinderTester.this.find();
                }
            });
            findPanel.add(this.tf);
            findPanel.add(this.feedback);
            Box controlPanel = new Box(1);
            controlPanel.add(this.caseCheck);
            controlPanel.add(this.wordCheck);
            controlPanel.add(this.startCheck);
            controlPanel.add(this.markCheck);
            controlPanel.add(this.regExCheck);
            JPanel testPanel = new JPanel(new BorderLayout(2, 2));
            testPanel.add((Component)findPanel, "North");
            testPanel.add((Component)controlPanel, "West");
            testPanel.add(new JScrollPane(this.editor));
            UICUtils.runComponent((JComponent)testPanel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void find() {
            Finder f = new Finder(this.editor);
            FindCriteria criteria = new FindCriteria(this.tf.getText());
            criteria.setMatchCase(this.caseCheck.isSelected());
            criteria.setWholeWord(this.wordCheck.isSelected());
            criteria.setRegEx(this.regExCheck.isSelected());
            if (this.startCheck.isSelected()) {
                criteria.setLowerBound(this.editor.getCaretPosition());
            }
            if (this.markCheck.isSelected()) {
                criteria.setUpperBound(this.editor.getCaret().getMark());
            }
            List finds = f.findAll(criteria);
            this.highlightLayer.removeAllHighlights();
            this.highlightLayer.beginBlockUpdate();
            try {
                this.feedback.setText("" + finds.size());
                for (Find find : finds) {
                    this.highlightLayer.addHighlight(this.highlightStyle, find.getStartOffset(), find.getEndOffset());
                }
            }
            finally {
                this.highlightLayer.endBlockUpdate();
            }
        }
    }
}

