/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.find;

import java.awt.Toolkit;
import java.util.ListIterator;
import javax.swing.text.BadLocationException;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.FeedbackManager;
import oracle.javatools.editor.find.Find;
import oracle.javatools.editor.find.FindBundle;
import oracle.javatools.editor.find.FindCriteria;
import oracle.javatools.editor.find.FindResult;
import oracle.javatools.editor.find.FindUtils;
import oracle.javatools.editor.find.Finder;
import oracle.javatools.editor.find.PromptedReplacer;

public final class Replacer {
    static final EditDescriptor replaceDescriptor;
    static final EditDescriptor replaceAllDescriptor;
    static final int FEEDBACK_DURATION = 10000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static State replace(BasicEditorPane editor, FindCriteria criteria) {
        if (criteria.getScope() == FindCriteria.Scope.PROMPTED) {
            PromptedReplacer promptedReplacer = new PromptedReplacer(editor, criteria);
            return promptedReplacer.start();
        }
        BasicDocument doc = (BasicDocument)editor.getDocument();
        int changeId = doc.getTextBuffer().getChangeId();
        Finder finder = new Finder(editor);
        FindResult result = finder.find(criteria);
        if (result == null || result.getFinds().isEmpty()) {
            Toolkit.getDefaultToolkit().beep();
            return State.NOT_FOUND;
        }
        if (!editor.makeEditable()) {
            Toolkit.getDefaultToolkit().beep();
            return State.ERROR;
        }
        doc.writeLock();
        try {
            if (changeId != doc.getTextBuffer().getChangeId() && ((result = (finder = new Finder(editor)).find(criteria)) == null || result.getFinds().isEmpty())) {
                Toolkit.getDefaultToolkit().beep();
                State state = State.NOT_FOUND;
                return state;
            }
            switch (criteria.getScope()) {
                case GLOBAL: {
                    State state = Replacer.globalReplace(editor, criteria, result);
                    return state;
                }
                case SINGLE: {
                    State state = Replacer.singleReplace(editor, criteria, result);
                    return state;
                }
            }
            return State.ERROR;
        }
        finally {
            doc.writeUnlock();
            FindUtils.clearHighlights(editor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static State globalReplace(BasicEditorPane editor, FindCriteria criteria, FindResult result) {
        editor.beginEdit(replaceAllDescriptor);
        try {
            ListIterator<Find> li = result.getFinds().listIterator(result.getFinds().size());
            while (li.hasPrevious()) {
                State state = Replacer.replaceOccurence(editor, criteria, li.previous(), false);
                if (state == State.DONE) continue;
                State state2 = state;
                return state2;
            }
        }
        finally {
            editor.endEdit();
        }
        FeedbackManager feedbackManager = editor.getFeedbackManager();
        if (feedbackManager != null) {
            feedbackManager.showFeedback(editor, FindBundle.format("FEEDBACK_REPLACE_STATUS", result.getFinds().size()), 10000);
        }
        return State.DONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static State singleReplace(BasicEditorPane editor, FindCriteria criteria, FindResult result) {
        Find find = result.getNext();
        if (find == null) {
            Toolkit.getDefaultToolkit().beep();
            return State.NOT_FOUND;
        }
        editor.beginEdit(replaceDescriptor);
        try {
            State state = Replacer.replaceOccurence(editor, criteria, find, true);
            return state;
        }
        finally {
            editor.endEdit();
        }
    }

    private static State replaceOccurence(BasicEditorPane editor, FindCriteria criteria, Find find, boolean select) {
        try {
            int start = find.getStartOffset();
            int length = find.getEndOffset() - find.getStartOffset();
            String foundText = editor.getText(start, length);
            String replaceText = Replacer.getReplaceText(criteria, foundText);
            editor.remove(start, length);
            editor.insertString(start, replaceText, null);
            if (select) {
                editor.select(start, start + replaceText.length());
            }
            return State.DONE;
        }
        catch (BadLocationException e) {
            return State.ERROR;
        }
    }

    static String getReplaceText(FindCriteria criteria, String foundText) {
        String replaceText = criteria.getReplaceText();
        if (criteria.isSubstituteReplace()) {
            replaceText = FindUtils.substituteSpecial(replaceText);
        }
        if (criteria.isPreserveCase()) {
            if (foundText.toUpperCase().equals(foundText)) {
                replaceText = replaceText.toUpperCase();
            } else if (foundText.toLowerCase().equals(foundText)) {
                replaceText = replaceText.toLowerCase();
            } else if (foundText.length() > 1) {
                Character foundFirst = Character.valueOf(foundText.charAt(0));
                String foundRest = foundText.substring(1);
                Character replaceFirst = Character.valueOf(replaceText.charAt(0));
                String replaceRest = replaceText.substring(1);
                if (Character.isUpperCase(foundFirst.charValue()) && foundRest.toLowerCase().equals(foundRest)) {
                    replaceText = "" + Character.toUpperCase(replaceFirst.charValue()) + replaceRest.toLowerCase();
                } else if (Character.isLowerCase(foundFirst.charValue()) && foundRest.toUpperCase().equals(foundRest)) {
                    replaceText = "" + Character.toLowerCase(replaceFirst.charValue()) + replaceRest.toUpperCase();
                } else if (Character.isUpperCase(foundFirst.charValue())) {
                    replaceText = "" + Character.toUpperCase(replaceFirst.charValue()) + replaceRest;
                } else if (Character.isLowerCase(foundFirst.charValue())) {
                    replaceText = "" + Character.toLowerCase(replaceFirst.charValue()) + replaceRest;
                }
            }
        }
        return replaceText;
    }

    static {
        String editName = FindBundle.get("FD_UNDO_REPLACE");
        replaceDescriptor = new EditDescriptor(editName);
        editName = FindBundle.get("FD_UNDO_REPLACE_ALL");
        replaceAllDescriptor = new EditDescriptor(editName);
    }

    public static enum State {
        DONE,
        NOT_FOUND,
        CANCELLED,
        ERROR;

    }
}

