/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.insight;

import java.util.Arrays;
import oracle.javatools.editor.insight.InsightInputFilter;
import oracle.javatools.editor.insight.ListDataItem;

public final class SortedInsightInputFilter
extends InsightInputFilter {
    public static final SortedInsightInputFilter INSTANCE = new SortedInsightInputFilter();
    public static final ListDataItem[] EMPTY_LIST = new ListDataItem[0];

    private SortedInsightInputFilter() {
    }

    @Override
    protected void sortData(ListDataItem[] dataList) {
        Arrays.sort(dataList);
    }

    @Override
    public ListDataItem findClosestDataItem(ListDataItem[] dataList, String name) {
        int numItems = dataList.length;
        if (name == null || name.length() == 0) {
            return numItems > 0 ? dataList[0] : null;
        }
        String commonPrefix = this.findCommonPrefix(dataList, name);
        int prefixLength = commonPrefix.length();
        if (prefixLength > 0) {
            prefixLength = Math.min(prefixLength, name.length());
            ListDataItem bestItem = null;
            int bestLength = 0;
            for (int i = 0; i < numItems; ++i) {
                int matchingLength;
                ListDataItem item = dataList[i];
                String itemName = item.getName();
                if (!itemName.regionMatches(true, 0, name, 0, prefixLength) || (matchingLength = this.getMatchingLength(itemName, name)) <= bestLength) continue;
                bestLength = matchingLength;
                bestItem = item;
            }
            if (bestItem != null) {
                return bestItem;
            }
        }
        for (int i = 0; i < numItems; ++i) {
            ListDataItem item = dataList[i];
            String itemName = item.getName();
            int result = name.compareToIgnoreCase(itemName);
            if (result > 0) continue;
            return item;
        }
        return numItems > 0 ? dataList[numItems - 1] : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ListDataItem[] getMatchingData(ListDataItem[] dataList, String prefix) {
        int numItems;
        if (prefix == null) {
            prefix = "";
        }
        int commonStart = numItems = dataList.length;
        int commonEnd = numItems;
        boolean STATE_FIND_START = true;
        int STATE_FIND_END = 2;
        int state = 1;
        block4: for (int i = 0; i < numItems; ++i) {
            ListDataItem item = dataList[i];
            String itemName = item.getName();
            switch (state) {
                case 1: {
                    if (!SortedInsightInputFilter.startsWithIgnoreCase(itemName, prefix)) break;
                    commonStart = i;
                    state = 2;
                    break;
                }
                case 2: {
                    if (SortedInsightInputFilter.startsWithIgnoreCase(itemName, prefix)) break;
                    commonEnd = i;
                    break block4;
                }
            }
        }
        if (commonStart == commonEnd) {
            return EMPTY_LIST;
        }
        int numMatches = commonEnd - commonStart;
        ListDataItem[] matchingData = new ListDataItem[numMatches];
        System.arraycopy(dataList, commonStart, matchingData, 0, numMatches);
        return matchingData;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String findCommonPrefix(ListDataItem[] dataList, String name) {
        int numItems;
        if (name == null) return "";
        if (name.length() == 0) {
            return "";
        }
        int commonStart = numItems = dataList.length;
        int commonEnd = numItems;
        int shortestCommon = -1;
        boolean STATE_FIND_START = true;
        int STATE_FIND_END = 2;
        int state = 1;
        block4: for (int i = 0; i < numItems; ++i) {
            ListDataItem item = dataList[i];
            String itemName = item.getName();
            switch (state) {
                case 1: {
                    if (!SortedInsightInputFilter.startsWithIgnoreCase(itemName, name)) break;
                    commonStart = i;
                    state = 2;
                    shortestCommon = itemName.length();
                    break;
                }
                case 2: {
                    if (!SortedInsightInputFilter.startsWithIgnoreCase(itemName, name)) {
                        commonEnd = i;
                        break block4;
                    }
                    shortestCommon = Math.min(shortestCommon, itemName.length());
                }
            }
        }
        if (commonStart == commonEnd) {
            return "";
        }
        int nameLength = name.length();
        ListDataItem controlItem = dataList[commonStart];
        String controlName = controlItem.getName();
        int commonLen = shortestCommon;
        while (commonLen > nameLength) {
            boolean allMatches = true;
            for (int j = commonStart + 1; j < commonEnd; ++j) {
                ListDataItem checkItem = dataList[j];
                String checkName = checkItem.getName();
                if (checkName.regionMatches(true, 0, controlName, 0, commonLen)) continue;
                allMatches = false;
                break;
            }
            if (allMatches) {
                return controlName.substring(0, commonLen);
            }
            --commonLen;
        }
        return name;
    }

    private int getMatchingLength(String s1, String s2) {
        int len = Math.min(s1.length(), s2.length());
        for (int i = 0; i < len; ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return i;
        }
        return len;
    }

    public static boolean startsWithIgnoreCase(String name1, String name2) {
        return name1.regionMatches(true, 0, name2, 0, name2.length());
    }
}

