/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.keys;

import java.util.HashMap;
import javax.swing.KeyStroke;

public class MultiKeymap {
    public static final String PARTIAL_MAPPING = "partial";
    private HashMap map = new HashMap(7);
    private MultiKeymap parent = null;

    public synchronized void setParent(MultiKeymap map) {
        this.parent = map;
    }

    public MultiKeymap getParent() {
        return this.parent;
    }

    public synchronized void put(KeyStroke key1, String actionKey) {
        Object action = this.map.get(key1);
        if (action != null && action instanceof MultiKeymap) {
            throw new IllegalArgumentException("Partial mapping exists: " + key1);
        }
        this.map.put(key1, actionKey);
    }

    public void put(KeyStroke[] keys, int numKeys, String actionKey) {
        this.put(keys, 0, numKeys, actionKey);
    }

    protected synchronized void put(KeyStroke[] keys, int index, int count, String actionKey) {
        if (count == 1) {
            this.put(keys[index], actionKey);
        } else {
            Object nextLevel = this.map.get(keys[index]);
            if (nextLevel == null) {
                nextLevel = new MultiKeymap();
                this.map.put(keys[index], nextLevel);
            } else if (!(nextLevel instanceof MultiKeymap)) {
                throw new IllegalArgumentException("Full mapping exists: " + index);
            }
            ((MultiKeymap)nextLevel).put(keys, index + 1, count - 1, actionKey);
        }
    }

    public synchronized String get(KeyStroke key1) {
        Object action = this.map.get(key1);
        if (action != null && action instanceof MultiKeymap) {
            return PARTIAL_MAPPING;
        }
        if (action == null && this.parent != null) {
            action = this.parent.get(key1);
        }
        return (String)action;
    }

    public synchronized String get(KeyStroke[] keys, int numKeys) {
        String action = this.get(keys, 0, numKeys);
        if (action == null && this.parent != null) {
            action = this.parent.get(keys, numKeys);
        }
        return action;
    }

    protected synchronized String get(KeyStroke[] keys, int index, int count) {
        if (count == 1) {
            return this.get(keys[index]);
        }
        Object nextLevel = this.map.get(keys[index]);
        if (nextLevel != null) {
            if (nextLevel instanceof MultiKeymap) {
                return ((MultiKeymap)nextLevel).get(keys, index + 1, count - 1);
            }
            throw new IllegalArgumentException("State error, count left: " + count);
        }
        return null;
    }

    public void remove(KeyStroke key1) {
        throw new RuntimeException("Not implemented.");
    }

    public void remove(KeyStroke[] keys, int numKeys) {
        this.remove(keys, 0, numKeys);
    }

    protected void remove(KeyStroke[] keys, int index, int count) {
        throw new RuntimeException("Not implemented.");
    }

    public synchronized void clear() {
        this.map.clear();
    }
}

