/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.plain.PlainLanguageModule;

public abstract class LanguageModule {
    public static final String FILETYPE_TXT = "txt";
    public static final String FILETYPE_TEXT = "text";
    public static final String FILETYPE_LOG = "log";
    public static final String FILETYPE_JAVA = "java";
    public static final String FILETYPE_JSP = "jsp";
    public static final String FILETYPE_PHP = "php";
    public static final String FILETYPE_PHP3 = "php3";
    public static final String FILETYPE_PHP4 = "php4";
    public static final String FILETYPE_HTML = "html";
    public static final String FILETYPE_HTM = "htm";
    public static final String FILETYPE_SQLJ = "sqlj";
    public static final String FILETYPE_SQL = "sql";
    public static final String FILETYPE_PLS = "pls";
    public static final String FILETYPE_PLSQL = "plsql";
    public static final String FILETYPE_PROPERTIES = "properties";
    public static final String FILETYPE_RTS = "rts";
    public static final String FILETYPE_MF = "MF";
    public static final String FILETYPE_XML = "xml";
    public static final String FILETYPE_DTD = "dtd";
    public static final String FILETYPE_XSL = "xsl";
    public static final String FILETYPE_IDL = "idl";
    public static final String FILETYPE_C = "c";
    public static final String FILETYPE_CPP2 = "c++";
    public static final String FILETYPE_CPP = "cpp";
    public static final String FILETYPE_CPLUSPLUS = "cplusplus";
    public static final String FILETYPE_CSS = "css";
    public static final String FILETYPE_H = "h";
    public static final String FILETYPE_JS = "js";
    public static final String FILETYPE_DIFF = "diff";
    public static final String FILETYPE_PATCH = "patch";
    private static HashMap fileTypeMap = new HashMap();
    private static HashMap supportClassMap = new HashMap();
    private static List moduleList = new ArrayList();
    private static LanguageModule defaultModule = null;

    public static LanguageSupport createDefaultSupport() {
        return LanguageModule.getDefaultModule().createLanguageSupport();
    }

    public static LanguageModule getDefaultModule() {
        return defaultModule;
    }

    public static LanguageSupport createSupportForFileType(String fileName) {
        String fileType = LanguageModule.getFileType(fileName);
        LanguageModule module = LanguageModule.getModuleForFileType(fileType);
        LanguageSupport support = module.createLanguageSupport();
        Class<?> supportClass = support.getClass();
        supportClassMap.put(supportClass, fileType);
        return support;
    }

    public static LanguageSupport createSupportForFileType(Class supportClass) {
        String fileType = (String)supportClassMap.get(supportClass);
        LanguageModule module = LanguageModule.getModuleForFileType(fileType);
        return module != null ? module.createLanguageSupport() : null;
    }

    public static BlockRenderer createBlockRendererForFileType(String fileType, TextBuffer textBuffer) {
        LanguageModule module = LanguageModule.getModuleForFileType(fileType);
        return module.createBlockRenderer(textBuffer);
    }

    public static LanguageModule getModuleForFileType(String fileName) {
        String fileSuffix = LanguageModule.getFileType(fileName);
        LanguageModule module = (LanguageModule)fileTypeMap.get(fileSuffix);
        if (module != null) {
            return module;
        }
        int numModules = moduleList.size();
        for (int i = numModules - 1; i >= 0; --i) {
            module = (LanguageModule)moduleList.get(i);
            String[] supportedTypes = module.getSupportedFileTypes();
            int numTypes = supportedTypes.length;
            for (int t = 0; t < numTypes; ++t) {
                String fileType = LanguageModule.getFileType(supportedTypes[t]);
                if (!fileSuffix.equals(fileType)) continue;
                return module;
            }
        }
        return defaultModule;
    }

    public static void registerModuleForFileType(LanguageModule module, String fileName) {
        String fileSuffix = LanguageModule.getFileType(fileName);
        if (fileSuffix != null && fileSuffix.length() > 0) {
            fileTypeMap.put(fileSuffix, module);
        }
    }

    public static String getFileType(String fileName) {
        if (fileName == null) {
            return fileName;
        }
        int lastPeriodPos = fileName.lastIndexOf(46);
        if (lastPeriodPos == -1) {
            return fileName.toLowerCase();
        }
        String fileSuffix = fileName.substring(lastPeriodPos + 1);
        return fileSuffix.toLowerCase();
    }

    public static StyleRegistry getGlobalStyleRegistry() {
        EditorProperties properties = EditorProperties.getProperties();
        StyleRegistry styleRegistry = properties.getStyleRegistry();
        return styleRegistry;
    }

    public void registerModule(LanguageModule module) {
        StyleRegistry globalRegistry = LanguageModule.getGlobalStyleRegistry();
        module.registerStyles(globalRegistry);
        module.initializeModule();
        Class<?> moduleClass = module.getClass();
        int numModules = moduleList.size();
        for (int i = 0; i < numModules; ++i) {
            Object checkModule = moduleList.get(i);
            Class<?> checkClass = checkModule.getClass();
            if (moduleClass != checkClass) continue;
        }
        moduleList.add(module);
        for (String type : module.getSupportedFileTypes()) {
            LanguageModule.registerModuleForFileType(module, type);
        }
    }

    public static Iterator getLanguageIterator() {
        ArrayList listCopy = new ArrayList();
        listCopy.addAll(moduleList);
        return listCopy.iterator();
    }

    protected LanguageModule() {
        this.registerModule(this);
    }

    protected void initializeModule() {
    }

    public String getName() {
        return this.getClass().getName();
    }

    public abstract String getPresentationName();

    public String toString() {
        return this.getPresentationName();
    }

    public abstract String[] getSupportedFileTypes();

    public abstract String[] getStyleNames();

    public abstract String getContentSample();

    public abstract void registerStyles(StyleRegistry var1);

    public abstract LanguageSupport createLanguageSupport();

    public abstract BlockRenderer createBlockRenderer(TextBuffer var1);

    static {
        defaultModule = new PlainLanguageModule();
        String[] otherModules = new String[]{"oracle.javatools.editor.language.java.JavaLanguageModule", "oracle.javatools.editor.language.html.HTMLLanguageModule", "oracle.javatools.editor.language.css.CSSLanguageModule", "oracle.javatools.editor.language.jsp.JSPLanguageModule", "oracle.javatools.editor.language.plsql.PLSQLLanguageModule", "oracle.javatools.editor.language.properties.PropertiesLanguageModule", "oracle.javatools.editor.language.idl.IDLLanguageModule", "oracle.javatools.editor.language.cpp.CppLanguageModule", "oracle.javatools.editor.language.diff.DiffLanguageModule", "oracle.javatools.editor.language.properties.ManifestLanguageModule"};
        int numModules = otherModules.length;
        for (int i = 0; i < numModules; ++i) {
            try {
                Class<?> moduleClass = Class.forName(otherModules[i]);
                moduleClass.newInstance();
                continue;
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                continue;
            }
            catch (InstantiationException e) {
                continue;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }
}

