/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.plugins;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.io.Reader;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import oracle.javatools.buffer.GuardedException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.editor.BasicCaret;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.resource.BundleHelper;

public class DropTargetPlugin
implements DropTargetListener,
EditorPlugin {
    protected BasicEditorPane editor;
    protected DropTarget dropTarget = new DropTarget(null, 3, this);
    protected Rectangle lastDropRect = null;
    protected static final int DROP_RECT_WIDTH = 1;
    protected static final DataFlavor STRING_FLAVOR = DataFlavor.stringFlavor;
    protected static final DataFlavor PLAIN_FLAVOR = DataFlavor.getTextPlainUnicodeFlavor();
    private static DataFlavor[] supportedFlavors = new DataFlavor[]{STRING_FLAVOR, PLAIN_FLAVOR};
    protected static final EditDescriptor DROP_DESCRIPTOR;

    @Override
    public void install(BasicEditorPane editor) {
        this.editor = editor;
        this.dropTarget.setComponent(editor);
    }

    @Override
    public void deinstall(BasicEditorPane editor) {
        this.dropTarget.setComponent(null);
        this.editor = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
        this.handleDragEvent(event);
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
        this.handleDragEvent(event);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent event) {
        this.handleDragEvent(event);
    }

    @Override
    public void dragExit(DropTargetEvent event) {
        this.cancelDragEvent(event);
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        this.handleDropEvent(event);
    }

    protected BasicDocument getDocument() {
        return (BasicDocument)this.editor.getDocument();
    }

    protected Rectangle getDropRectangle(Point location) {
        int offset = this.editor.viewToModel(location);
        Rectangle dropRect = null;
        try {
            dropRect = this.editor.modelToView(offset);
        }
        catch (BadLocationException e) {
            dropRect = null;
        }
        return dropRect;
    }

    protected void clearDropLocation() {
        if (SwingUtilities.isEventDispatchThread() && this.lastDropRect != null) {
            Graphics graphics = this.editor.getGraphics();
            this.editor.paintImmediately(this.lastDropRect.x, this.lastDropRect.y, 2, this.lastDropRect.height);
            this.lastDropRect = null;
        }
    }

    protected void paintDropLocation(Point newLocation) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.clearDropLocation();
            this.lastDropRect = this.getDropRectangle(newLocation);
            if (this.lastDropRect != null) {
                Graphics graphics = this.editor.getGraphics();
                EditorProperties properties = EditorProperties.getProperties();
                Color caretColor = (Color)properties.getProperty("caret-color");
                graphics.setColor(caretColor);
                graphics.drawRect(this.lastDropRect.x, this.lastDropRect.y, 1, this.lastDropRect.height - 1);
            }
        }
    }

    protected void cancelDragEvent(DropTargetEvent event) {
        this.clearDropLocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDropEvent(DropTargetDropEvent event) {
        this.clearDropLocation();
        int dropAction = event.getDropAction();
        if (this.isDropActionSupported(dropAction) && this.isDataFlavorSupported(event)) {
            if (!this.editor.isEditable()) {
                this.editor.makeEditable();
            }
            if (this.editor.isEditable()) {
                event.acceptDrop(dropAction);
                Transferable transferable = event.getTransferable();
                String textToDrop = this.getTransferText(transferable);
                boolean dropSuccess = false;
                if (textToDrop != null && textToDrop.length() > 0) {
                    Point location = event.getLocation();
                    int offset = this.editor.viewToModel(location);
                    this.editor.beginEdit(DROP_DESCRIPTOR);
                    try {
                        BasicDocument document = this.getDocument();
                        Caret caret = this.editor.getCaret();
                        if (caret instanceof BasicCaret) {
                            ((BasicCaret)caret).getEditorSelection().insertText(offset, textToDrop);
                        } else {
                            document.insertString(offset, textToDrop, null);
                            this.editor.setCaretPosition(offset + textToDrop.length());
                        }
                        dropSuccess = true;
                        Window parentWindow = SwingUtilities.getWindowAncestor(this.editor);
                        if (parentWindow != null) {
                            parentWindow.toFront();
                        }
                        this.editor.requestFocus();
                    }
                    catch (BadLocationException e) {
                    }
                    catch (GuardedException e) {
                    }
                    finally {
                        this.editor.endEdit();
                    }
                }
                event.dropComplete(dropSuccess);
                return;
            }
        }
        event.rejectDrop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getTransferText(Transferable transferable) {
        String textToDrop = null;
        DataFlavor preferredFlavor = this.getPreferredDataFlavor(transferable);
        if (preferredFlavor == STRING_FLAVOR) {
            try {
                textToDrop = transferable.getTransferData(preferredFlavor).toString();
            }
            catch (IOException e) {
                textToDrop = null;
            }
            catch (UnsupportedFlavorException e) {
                textToDrop = null;
            }
        } else if (preferredFlavor == PLAIN_FLAVOR) {
            Reader readerToUse = null;
            try {
                readerToUse = PLAIN_FLAVOR.getReaderForText(transferable);
                if (readerToUse != null) {
                    TextBuffer buffer = TextBufferFactory.createTextBuffer();
                    buffer.read(readerToUse);
                    textToDrop = buffer.getString(0, buffer.getLength());
                }
            }
            catch (IOException e) {
                textToDrop = null;
            }
            catch (NullPointerException e) {
                textToDrop = null;
            }
            catch (IllegalArgumentException e) {
                textToDrop = null;
            }
            catch (UnsupportedFlavorException e) {
                textToDrop = null;
            }
            finally {
                if (readerToUse != null) {
                    try {
                        readerToUse.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return textToDrop;
    }

    protected DataFlavor getPreferredDataFlavor(Transferable transferable) {
        for (DataFlavor flavor : this.getSupportedFlavors()) {
            if (!transferable.isDataFlavorSupported(flavor)) continue;
            return flavor;
        }
        return null;
    }

    protected void handleDragEvent(DropTargetDragEvent event) {
        this.paintDropLocation(event.getLocation());
        int dropAction = event.getDropAction();
        if (this.isDropActionSupported(dropAction) && this.isDataFlavorSupported(event)) {
            event.acceptDrag(dropAction);
        } else {
            event.rejectDrag();
        }
    }

    protected boolean isDropActionSupported(int requestedAction) {
        return (requestedAction & 3) != 0;
    }

    protected boolean isDataFlavorSupported(DropTargetDragEvent event) {
        DataFlavor[] flavors = this.getSupportedFlavors();
        int numFlavors = flavors.length;
        for (int i = 0; i < numFlavors; ++i) {
            if (!event.isDataFlavorSupported(flavors[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean isDataFlavorSupported(DropTargetDropEvent event) {
        DataFlavor[] flavors = this.getSupportedFlavors();
        int numFlavors = flavors.length;
        for (int i = 0; i < numFlavors; ++i) {
            if (!event.isDataFlavorSupported(flavors[i])) continue;
            return true;
        }
        return false;
    }

    protected DataFlavor[] getSupportedFlavors() {
        return supportedFlavors;
    }

    static {
        BundleHelper resources = EditorProperties.getEditorBundle();
        String editName = resources.getString("UNDO_DROP_OPERATION");
        DROP_DESCRIPTOR = new EditDescriptor(editName);
    }
}

