/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.popup;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Stack;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.PanelUI;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import oracle.javatools.editor.popup.HtmlContentProvider;
import oracle.javatools.editor.popup.PopupEventListener;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.resource.DialogsBundle;

public final class HtmlPopupView
extends JPanel {
    private JButton _backButton;
    private JButton _nextButton;
    private JScrollPane _scrollPane;
    private JTextPane _textPane;
    private JToolBar _toolbar;
    private Stack<HtmlContentProvider> _back = new Stack();
    private Stack<HtmlContentProvider> _next = new Stack();
    private HtmlContentProvider _activeProvider;
    private final CopyOnWriteArrayList<PopupEventListener> _listeners;
    private HashMap<HtmlContentProvider, String> _history = new HashMap();

    public HtmlPopupView(HtmlContentProvider contentProvider) {
        this._listeners = new CopyOnWriteArrayList();
        this.initialize();
        this.setActiveContentProvider(contentProvider);
        this.push(contentProvider);
    }

    public void push(HtmlContentProvider contentProvider) {
        this.updateStack(contentProvider);
        this.formatView(contentProvider);
    }

    protected void disposePopup() {
        this.notifyClosed();
        this._back = null;
        this._next = null;
        this._activeProvider = null;
        this._history = null;
    }

    public boolean up() {
        JViewport port = this._scrollPane.getViewport();
        Rectangle aperture = port.getViewRect();
        int unit = this._textPane.getScrollableUnitIncrement(aperture, 1, -1);
        if (aperture.y > 0) {
            int y = aperture.y > unit ? aperture.y - unit : 0;
            Point scrollPoint = new Point(aperture.x, y);
            port.setViewPosition(scrollPoint);
        }
        return true;
    }

    public boolean pageUp() {
        JViewport port = this._scrollPane.getViewport();
        Dimension view = port.getViewSize();
        Rectangle aperture = port.getViewRect();
        if (aperture.y > 0 && view.height > aperture.height) {
            int y = aperture.y > aperture.height ? aperture.y - aperture.height : 0;
            Point scrollPoint = new Point(aperture.x, y);
            port.setViewPosition(scrollPoint);
        }
        return true;
    }

    public boolean down() {
        JViewport port = this._scrollPane.getViewport();
        Dimension view = port.getViewSize();
        Rectangle aperture = port.getViewRect();
        int unit = this._textPane.getScrollableUnitIncrement(aperture, 1, 1);
        if (view.height > aperture.height && view.height - (aperture.y + aperture.height) > 0) {
            int y = aperture.y + unit < view.height ? aperture.y + unit : view.height - aperture.height;
            Point scrollPoint = new Point(aperture.x, y);
            port.setViewPosition(scrollPoint);
        }
        return true;
    }

    public boolean pageDown() {
        JViewport port = this._scrollPane.getViewport();
        Dimension view = port.getViewSize();
        Rectangle aperture = port.getViewRect();
        if (view.height > aperture.height && aperture.y < view.height - aperture.height) {
            int y = aperture.y + aperture.height < view.height ? aperture.y + aperture.height : view.height - aperture.height;
            Point scrollPoint = new Point(aperture.x, y);
            port.setViewPosition(scrollPoint);
        }
        return true;
    }

    public boolean home() {
        JViewport port = this._scrollPane.getViewport();
        Rectangle aperture = port.getViewRect();
        if (aperture.x > 0 || aperture.y > 0) {
            Point scrollPoint = new Point(0, 0);
            port.setViewPosition(scrollPoint);
        }
        return true;
    }

    public boolean end() {
        JViewport port = this._scrollPane.getViewport();
        Dimension view = port.getViewSize();
        Rectangle aperture = port.getViewRect();
        if (aperture.y + aperture.height < view.height || aperture.x + aperture.width < view.width) {
            Point scrollPoint = new Point(view.width - aperture.width, view.height - aperture.height);
            port.setViewPosition(scrollPoint);
        }
        return true;
    }

    public boolean left() {
        JViewport port = this._scrollPane.getViewport();
        Rectangle aperture = port.getViewRect();
        int unit = this._textPane.getScrollableUnitIncrement(aperture, 0, -1);
        if (aperture.x > 0) {
            int x = aperture.x > unit ? aperture.x - unit : 0;
            Point scrollPoint = new Point(x, aperture.y);
            port.setViewPosition(scrollPoint);
        }
        return true;
    }

    public boolean right() {
        JViewport port = this._scrollPane.getViewport();
        Dimension view = port.getViewSize();
        Rectangle aperture = port.getViewRect();
        int unit = this._textPane.getScrollableUnitIncrement(aperture, 0, 1);
        if (view.width > aperture.width && view.width - (aperture.x + aperture.width) > 0) {
            int x = aperture.x + unit < view.width ? aperture.x + unit : view.width - aperture.width;
            Point scrollPoint = new Point(x, aperture.y);
            port.setViewPosition(scrollPoint);
        }
        return true;
    }

    private void initialize() {
        this._textPane = new JTextPane(){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.height = Math.min(300, d.height);
                return d;
            }
        };
        this._textPane.setEditable(false);
        this._textPane.setDragEnabled(true);
        this._textPane.setFocusable(true);
        this._textPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        HTMLEditorKit kit = new HTMLEditorKit();
        StyleSheet styleSheet = kit.getStyleSheet();
        Style bodyStyle = styleSheet.getStyle("body");
        StyleConstants.setFontFamily(bodyStyle, "sans-serif");
        StyleConstants.setFontSize(bodyStyle, 12);
        this._textPane.setEditorKit(kit);
        Listeners listeners = new Listeners();
        this._textPane.addHyperlinkListener(listeners);
        this._textPane.addMouseListener(listeners);
        this._textPane.setText(DialogsBundle.get("LOADING"));
        this._scrollPane = new JScrollPane(){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width = Math.min(d.width, 530);
                return d;
            }

            @Override
            public boolean isValidateRoot() {
                return false;
            }
        };
        this._scrollPane.getViewport().add(this._textPane);
        this._scrollPane.setVerticalScrollBarPolicy(20);
        this._scrollPane.setHorizontalScrollBarPolicy(30);
        this._scrollPane.setBorder(null);
        this._backButton = new JButton();
        this._backButton.setIcon(OracleIcons.getIcon((String)"navigateBack.png"));
        this._backButton.setEnabled(false);
        this._backButton.setDefaultCapable(false);
        this._nextButton = new JButton();
        this._nextButton.setIcon(OracleIcons.getIcon((String)"navigateForward.png"));
        this._nextButton.setEnabled(false);
        this._nextButton.setDefaultCapable(false);
        this._toolbar = new JToolBar();
        this._toolbar.setFloatable(false);
        this._toolbar.setRollover(true);
        this._toolbar.setVisible(false);
        this._toolbar.add(this._backButton);
        this._toolbar.add(this._nextButton);
        this.setBorder(UIManager.getBorder("ToolTip.border"));
        this.setLayout(new BorderLayout());
        this.add((Component)this._toolbar, "North");
        this.add((Component)this._scrollPane, "Center");
        this._backButton.addActionListener(listeners);
        this._nextButton.addActionListener(listeners);
        this.setupActionMap();
    }

    @Override
    public void setUI(PanelUI ui) {
        super.setUI(ui);
        LookAndFeel.installColorsAndFont(this, "ToolTip.background", "ToolTip.foreground", "ToolTip.font");
    }

    public void setToolbarVisible(boolean visible) {
        if (visible) {
            if (this._toolbar.getParent() == null) {
                this.add((Component)this._toolbar, "North");
            }
        } else if (this._toolbar.getParent() != null) {
            this._toolbar.getParent().remove(this._toolbar);
        }
    }

    public Dimension getPreferredContentSize() {
        return this._textPane.getPreferredSize();
    }

    private void setupActionMap() {
        InputMap inputMap = this._textPane.getInputMap(2);
        ActionMap actionMap = new ActionMap();
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        AbstractAction action = new AbstractAction("cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                HtmlPopupView.this.notifyCanceled();
            }
        };
        inputMap.put(ks, action);
        actionMap.put(action.toString(), action);
    }

    private void setActiveContentProvider(HtmlContentProvider contentProvider) {
        this._activeProvider = contentProvider;
    }

    private void updateStack(HtmlContentProvider contentProvider) {
        boolean isError;
        if (!(this._activeProvider == null || this._activeProvider.equals(contentProvider) || !this._back.empty() && this._activeProvider.equals(this._back.peek()))) {
            this._toolbar.setVisible(true);
            this._back.push(this._activeProvider);
        } else {
            this._toolbar.setVisible(false);
        }
        boolean bl = isError = contentProvider == null || contentProvider.isError();
        if (!isError) {
            this.setActiveContentProvider(contentProvider);
            this._next.clear();
        }
        this._backButton.setEnabled(!this._back.empty());
        this._nextButton.setEnabled(!isError && !this._next.empty());
    }

    private void formatView(final HtmlContentProvider contentProvider) {
        boolean containsKey = this._history.containsKey(contentProvider);
        if (containsKey) {
            String message = this._history.get(contentProvider);
            this.updateContent(message);
        } else {
            SwingWorker<String, Object> worker = new SwingWorker<String, Object>(){

                @Override
                protected String doInBackground() throws Exception {
                    return contentProvider.getHTML();
                }

                @Override
                protected void done() {
                    if (HtmlPopupView.this._history != null) {
                        try {
                            String message = (String)this.get();
                            HtmlPopupView.this._history.put(contentProvider, message);
                            HtmlPopupView.this.updateContent(message);
                        }
                        catch (InterruptedException e) {
                        }
                        catch (ExecutionException executionException) {
                            // empty catch block
                        }
                    }
                }
            };
            worker.execute();
        }
    }

    private void updateContent(String message) {
        StringBuffer data = new StringBuffer(5000);
        data.append("<body>");
        data.append(message);
        data.append("</body>");
        this._textPane.setText(data.toString());
        this._textPane.setCaretPosition(0);
        Window w = SwingUtilities.windowForComponent(this);
        if (w != null) {
            w.pack();
            w.pack();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HtmlPopupView.this.notifyContentsChanged();
            }
        });
    }

    public void addPopupEventListener(PopupEventListener listener) {
        this._listeners.add(listener);
    }

    public void removePopupEventListener(PopupEventListener listener) {
        this._listeners.remove(listener);
    }

    private void notifyCanceled() {
        for (PopupEventListener popupEventListener : this._listeners) {
            popupEventListener.popupCanceled();
        }
    }

    private void notifyContentsChanged() {
        for (PopupEventListener popupEventListener : this._listeners) {
            popupEventListener.contentsChanged();
        }
    }

    private void notifyClosed() {
        for (PopupEventListener popupEventListener : this._listeners) {
            popupEventListener.popupClosed();
        }
    }

    private class Listeners
    extends MouseAdapter
    implements ActionListener,
    HyperlinkListener {
        private Listeners() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            e.getComponent().getParent().requestFocus();
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String href = e.getDescription();
                HtmlPopupView.this._activeProvider.navigate(HtmlPopupView.this, href);
            }
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object b = event.getSource();
            if (b == HtmlPopupView.this._backButton) {
                if (((HtmlContentProvider)HtmlPopupView.this._back.peek()).equals(HtmlPopupView.this._activeProvider)) {
                    HtmlPopupView.this._back.pop();
                } else {
                    HtmlPopupView.this._next.push(HtmlPopupView.this._activeProvider);
                    HtmlPopupView.this.setActiveContentProvider((HtmlContentProvider)HtmlPopupView.this._back.pop());
                }
                HtmlPopupView.this.formatView(HtmlPopupView.this._activeProvider);
            } else if (b == HtmlPopupView.this._nextButton) {
                HtmlPopupView.this._back.push(HtmlPopupView.this._activeProvider);
                HtmlPopupView.this.setActiveContentProvider((HtmlContentProvider)HtmlPopupView.this._next.pop());
                HtmlPopupView.this.formatView(HtmlPopupView.this._activeProvider);
            }
            HtmlPopupView.this._backButton.setEnabled(!HtmlPopupView.this._back.empty());
            HtmlPopupView.this._nextButton.setEnabled(!HtmlPopupView.this._next.empty());
        }
    }
}

