/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.internal.ui;

import java.awt.AWTEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import oracle.javatools.internal.ui.EventQueueObserver;
import oracle.javatools.internal.ui.EventQueueWrapper;
import oracle.javatools.logging.Diagnostics;

public final class EventThreadHangMonitor
extends EventQueueObserver {
    private static final EventThreadHangMonitor _sInstance = new EventThreadHangMonitor();
    private static final String THREAD_NAME = "EventDispatchThreadHangMonitor";
    private static final long CHECK_INTERVAL_MS = 100L;
    private static final long NO_CURRENT_EVENT = 0L;
    private static final long UNREASONABLE_DISPATCH_DURATION_MS;
    private static final boolean LOG_ALL_THREADS;
    private static final boolean KEEP_DUMPING;
    private static final boolean LOG_TO_DIAGNOSTIC_DIR;
    private static AWTEvent _currentEvent;
    private static int _count;
    private static PrintStream _logStream;
    private long _startedLastEventDispatchAt = 0L;
    private boolean _reportedHang = false;
    private Thread _eventDispatchThread = null;

    public static EventThreadHangMonitor getInstance() {
        return _sInstance;
    }

    @Override
    public synchronized void preDispatchEvent(EventQueueWrapper eventQueue, AWTEvent event) {
        if (this._eventDispatchThread == null) {
            this._eventDispatchThread = Thread.currentThread();
        }
        _currentEvent = event;
        this._reportedHang = false;
        this._startedLastEventDispatchAt = System.currentTimeMillis();
    }

    @Override
    public synchronized void postDispatchEvent(EventQueueWrapper eventQueue, AWTEvent event) {
        if (this._reportedHang) {
            this._stream().println(">>> [" + this._timeSoFar() + "ms] Event dispatch thread unstuck processing " + _currentEvent);
            this._stream().println();
            if (LOG_TO_DIAGNOSTIC_DIR) {
                this._stream().close();
                _logStream = null;
            }
        }
        this._startedLastEventDispatchAt = 0L;
    }

    private void _initTimer() {
        long initialDelayMs = 0L;
        boolean isDaemon = true;
        Timer timer = new Timer(THREAD_NAME, true);
        timer.schedule((TimerTask)new HangChecker(), 0L, 100L);
    }

    private long _timeSoFar() {
        long currentTime = System.currentTimeMillis();
        return currentTime - this._startedLastEventDispatchAt;
    }

    private PrintStream _stream() {
        if (!LOG_TO_DIAGNOSTIC_DIR) {
            return System.out;
        }
        if (_logStream != null) {
            return _logStream;
        }
        EventThreadHangMonitor._openLogFile();
        if (_logStream == null) {
            return System.out;
        }
        return _logStream;
    }

    private static void _openLogFile() {
        File file = Diagnostics.newLockedFile((String)"AWTHANGCHECK");
        if (file == null) {
            return;
        }
        try {
            _logStream = new PrintStream(new FileOutputStream(file, true));
            OutputStreamWriter writer = new OutputStreamWriter(_logStream);
            Diagnostics.writeBanner((Writer)writer, (String)("AWT EDT Hang Monitor logging started at " + new Date()));
            _logStream.println();
            Diagnostics.writeBanner((Writer)writer, (String)"Configuration");
            _logStream.println("Monitor threshold: " + UNREASONABLE_DISPATCH_DURATION_MS + "ms");
            _logStream.println("Log all threads: " + LOG_ALL_THREADS);
            _logStream.println("Keep dumping: " + KEEP_DUMPING);
            Diagnostics.writeSystemConfiguration((Writer)writer);
            _logStream.println();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private EventThreadHangMonitor() {
        this._initTimer();
    }

    static {
        _count = 0;
        _logStream = null;
        long duration = 500L;
        try {
            duration = Integer.parseInt(System.getProperty("ide.awthangmonitor.threshold", "500"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        UNREASONABLE_DISPATCH_DURATION_MS = duration;
        LOG_ALL_THREADS = Boolean.getBoolean("ide.awthangmonitor.allthreads");
        KEEP_DUMPING = Boolean.getBoolean("ide.awthangmonitor.keepdumping");
        LOG_TO_DIAGNOSTIC_DIR = Boolean.getBoolean("ide.awthangmonitor.autologfiles");
    }

    private class HangChecker
    extends TimerTask {
        private HangChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            EventThreadHangMonitor eventThreadHangMonitor = _sInstance;
            synchronized (eventThreadHangMonitor) {
                this._checkForHang();
            }
        }

        private void _checkForHang() {
            if (EventThreadHangMonitor.this._startedLastEventDispatchAt == 0L) {
                return;
            }
            if (EventThreadHangMonitor.this._timeSoFar() > UNREASONABLE_DISPATCH_DURATION_MS) {
                this._reportHang();
            }
        }

        private void _reportHang() {
            if (!KEEP_DUMPING && EventThreadHangMonitor.this._reportedHang) {
                return;
            }
            StackTraceElement[] edtStackTrace = EventThreadHangMonitor.this._eventDispatchThread.getStackTrace();
            if (EventThreadHangMonitor.this._reportedHang) {
                EventThreadHangMonitor.this._stream().println("--- [" + EventThreadHangMonitor.this._timeSoFar() + "ms] still processing event");
            } else {
                Diagnostics.writeBanner((Writer)new OutputStreamWriter(EventThreadHangMonitor.this._stream()), (String)("[" + ++_count + "] AWT hang exceeding " + UNREASONABLE_DISPATCH_DURATION_MS + "ms detected"));
                EventThreadHangMonitor.this._stream().println("<<< [" + EventThreadHangMonitor.this._timeSoFar() + "ms] event dispatch thread stuck processing event " + _currentEvent);
            }
            EventThreadHangMonitor.this._reportedHang = true;
            if (LOG_ALL_THREADS) {
                Diagnostics.logAllThreads((OutputStream)EventThreadHangMonitor.this._stream(), (String)EventThreadHangMonitor.THREAD_NAME, (String)EventThreadHangMonitor.class.getName());
            } else {
                Diagnostics.logThread((OutputStream)EventThreadHangMonitor.this._stream(), (Thread)EventThreadHangMonitor.this._eventDispatchThread, (String)EventThreadHangMonitor.class.getName());
            }
        }

        private void _printStackTrace(PrintStream out, StackTraceElement[] stackTrace) {
            if (stackTrace.length == 0) {
                out.println("    (no stack)");
            }
            String ourEventQueueClassName = EventThreadHangMonitor.class.getName();
            for (StackTraceElement stackTraceElement : stackTrace) {
                if (stackTraceElement.getClassName().equals(ourEventQueueClassName)) {
                    return;
                }
                out.println("    " + stackTraceElement);
            }
        }
    }
}

