/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.patterns;

import java.util.concurrent.CopyOnWriteArraySet;
import oracle.javatools.patterns.CloseListener;
import oracle.javatools.patterns.Closeable;
import oracle.javatools.patterns.CloseableWithNotification;

public class CloseableImpl
implements CloseableWithNotification {
    private final CopyOnWriteArraySet<CloseListener> listeners = new CopyOnWriteArraySet();
    private boolean closed;
    private Closeable facade;

    public CloseableImpl(Closeable facade) {
        this.facade = facade;
    }

    @Override
    public void addCloseListener(CloseListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeCloseListener(CloseListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.fireWillClose();
            this.doClose();
        }
        finally {
            this.closed = true;
            this.fireDidClose();
        }
    }

    private void fireWillClose() {
        for (CloseListener listener : this.listeners) {
            listener.willClose(this.facade);
        }
    }

    private void fireDidClose() {
        for (CloseListener listener : this.listeners) {
            listener.didClose(this.facade);
        }
    }

    public void doClose() {
    }
}

