/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import oracle.javatools.util.Filter;
import oracle.javatools.util.SimpleInvocationHandler;

public class LoggingInvocationHandler<T>
implements InvocationHandler {
    private final InvocationHandler decorated;
    private Logger logger;
    private Level logLevel = Level.FINEST;
    private boolean includeStack = false;
    private Filter<Method> filter = Filter.Instances.acceptsAll();

    public LoggingInvocationHandler(T delegate, Logger logger) {
        this(new SimpleInvocationHandler<T>(delegate), logger);
    }

    public LoggingInvocationHandler(InvocationHandler decorated, Logger logger) {
        if (null == decorated) {
            throw new IllegalArgumentException("Decorated invocation handler must not be null");
        }
        this.decorated = decorated;
        if (null == logger) {
            throw new IllegalArgumentException("Logger must not be null");
        }
        this.logger = logger;
    }

    @Override
    public final Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object retVal = this.decorated.invoke(proxy, method, args);
        if (this.logger.isLoggable(this.logLevel)) {
            this.logMethodInvocation(method, args, retVal);
        }
        return retVal;
    }

    private void logMethodInvocation(Method method, Object[] args, Object retVal) {
        if (null != this.filter && !this.filter.matches(method)) {
            return;
        }
        StringBuffer buffer = new StringBuffer(method.getName()).append("( ");
        if (null != args && 0 < args.length) {
            for (int i = 0; i < args.length; ++i) {
                if (0 != i) {
                    buffer.append(", ");
                }
                buffer.append(args[i]);
            }
        }
        if (!method.getReturnType().equals(Void.TYPE)) {
            buffer.append(") --> ").append(retVal);
        }
        if (this.includeStack) {
            this.logger.log(this.logLevel, buffer.toString(), new Exception());
        } else {
            this.logger.log(this.logLevel, buffer.toString());
        }
    }

    public void setLevel(Level logLevel) {
        if (null == logLevel) {
            throw new IllegalArgumentException("Log level must not be null");
        }
        this.logLevel = logLevel;
    }

    public Level getLevel() {
        return this.logLevel;
    }

    public void setIncludeStackTrace(boolean includeStack) {
        this.includeStack = includeStack;
    }

    public void setMethodFilter(Filter<Method> filter) {
        this.filter = filter;
    }

    public void setMethodNames(String ... methodNames) {
        if (null == methodNames || 0 == methodNames.length) {
            this.setMethodFilter(Filter.Instances.<Method>acceptsAll());
            return;
        }
        RegexFilter[] filters = new RegexFilter[methodNames.length];
        for (int i = 0; i < methodNames.length; ++i) {
            filters[i] = new RegexFilter(methodNames[i]);
        }
        this.setMethodFilter(Filter.Instances.or(filters));
    }

    private static class RegexFilter
    implements Filter<Method> {
        private final Pattern pattern;

        public RegexFilter(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        @Override
        public boolean matches(Method method) {
            return this.pattern.matcher(method.getName()).matches();
        }
    }
}

