/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.markers;

import oracle.ide.markers.Marker;
import oracle.ide.markers.MarkerException;
import oracle.ide.markers.annotations.MarkerAttribute;
import oracle.ide.markers.annotations.MarkerType;
import oracle.ide.markers.res.MarkersBundle;

@MarkerType(name="Task Marker", description="The task marker is used to indicate something that needs to be done associated with its markable object.")
public interface TaskMarker
extends Marker {
    @MarkerAttribute(id="description", name="Description", description="The task description", required=true)
    public String description();

    @MarkerAttribute(id="description")
    public void description(String var1) throws MarkerException;

    @MarkerAttribute(id="priority", name="Priority", description="The priority of the task: high (0), normal (1), or low (2)", required=true, defaultValue="1")
    public int priority();

    @MarkerAttribute(id="priority")
    public void priority(int var1) throws MarkerException;

    public static enum Priority {
        HIGH(0),
        NORMAL(1),
        LOW(2);

        public final int value;

        private Priority(int value) {
            this.value = value;
        }

        public static Priority valueOf(int priority) {
            for (Priority p : Priority.values()) {
                if (priority != p.value) continue;
                return p;
            }
            throw new IllegalArgumentException("Unrecognized priority value: " + priority);
        }

        public String getName() {
            return MarkersBundle.get(this.toString());
        }
    }
}

