/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.markers;

import java.net.URL;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.Ide;
import oracle.ide.adapters.AdapterFactory;
import oracle.ide.adapters.AdapterManager;
import oracle.ide.markers.Markable;
import oracle.ide.markers.Marker;
import oracle.ide.model.WorkingSet;
import oracle.ideimpl.markers.MarkableImpl;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Filter;

public class MarkableWorkingSet
implements Markable {
    private final WorkingSet workingSet;
    private final MarkableImpl impl;

    public MarkableWorkingSet(WorkingSet workingSet) {
        this.workingSet = workingSet;
        this.impl = new MarkableImpl(this);
    }

    @Override
    public void addMarkers(Marker ... markers) {
        throw new UnsupportedOperationException("Cannot add markers to a working set.");
    }

    @Override
    public List<Marker> getMarkers() {
        return this.impl.getMarkers();
    }

    @Override
    public <M extends Marker> List<M> getMarkers(Class<M> type, boolean includeSubtypes) {
        return this.impl.getMarkers(type, includeSubtypes);
    }

    @Override
    public List<Marker> getMarkers(Filter<Marker> filter) {
        return this.impl.getMarkers(filter);
    }

    @Override
    public List<Marker> removeMarkers() {
        throw new UnsupportedOperationException("Cannot remove markers from a working set.");
    }

    @Override
    public <M extends Marker> List<M> removeMarkers(Class<M> type, boolean includeSubtypes) {
        throw new UnsupportedOperationException("Cannot remove markers from a working set.");
    }

    @Override
    public List<Marker> removeMarkers(Filter<Marker> filter) {
        throw new UnsupportedOperationException("Cannot remove markers from a working set.");
    }

    @Override
    public <M extends Marker> List<M> removeMarkers(M ... markers) {
        throw new UnsupportedOperationException("Cannot remove markers from a working set.");
    }

    @Override
    public URL getUrl() {
        return Ide.getActiveWorkspace().getURL();
    }

    public WorkingSet getWorkingSet() {
        return this.workingSet;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MarkableWorkingSet)) {
            return false;
        }
        MarkableWorkingSet other = (MarkableWorkingSet)object;
        return this.workingSet != null ? this.workingSet.equals((Object)other.workingSet) : other.workingSet == null;
    }

    @Override
    public int hashCode() {
        int PRIME = 37;
        int result = 1;
        result = 37 * result + (this.workingSet == null ? 0 : this.workingSet.hashCode());
        return result;
    }

    @Override
    public int compareTo(Markable o) {
        return this.impl.compareTo(o);
    }

    public String getShortLabel() {
        return this.getWorkingSet().getName();
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public Icon getIcon() {
        return OracleIcons.getIcon((String)"workingsets.png");
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }

    static {
        AdapterManager.Factory.getAdapterManager().registerFactory((AdapterFactory)new AdapterFactory<MarkableWorkingSet, MarkableImpl>(){

            public MarkableImpl adapt(MarkableWorkingSet obj) {
                return obj.impl;
            }
        });
    }
}

