/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.markers;

import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.adapters.AdapterFactory;
import oracle.ide.adapters.AdapterManager;
import oracle.ide.markers.Marker;
import oracle.ide.markers.MarkerAttributesHandler;
import oracle.ide.markers.MarkerException;
import oracle.ide.markers.annotations.MarkerAttribute;
import oracle.ide.util.NameValuePair;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.util.ModelUtil;

public class RootMarkerAttributesHandler
implements MarkerAttributesHandler<Marker> {
    private static final String ATTR_ID = "id";
    private static final String ATTR_TIMESTAMP = "timestamp";
    private static final String ATTR_LAST_UPDATED = "lastUpdated";
    private static final String ATTR_MARKABLE_URL = "markableURL";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_EVENT_ID = "event-id";
    private static final String ATTR_EVENT_DESC = "event-description";
    private static final String ATTR_EVENT_TIMESTAMP = "event-timestamp";
    private static final String ATTR_EVENTS = "events";
    private static final String[] PRIVATE_ATTRS = new String[]{"id", "timestamp", "lastUpdated", "markableURL", "type", "events"};
    private static final Map<Class<?>, NameValuePair<Class<?>>> MAP_ATTR_TYPES = new HashMap();
    private static final String PUT_METHOD_NAME_FMT = "put{0}";
    private static final String INVALID_ATTR_TYPE_MSG = "Invalid attribute type: {1}, for attribute: {0}";
    private static final Map<Class<?>, Map<String, Method>> ATTRIBUTE_ACCESSORS_BY_CLASS_AND_NAME;
    private Map<String, Object> oldAttrs;
    private Map<String, Object> attrs = new HashMap<String, Object>();

    private static Method getAccessorMethod(Marker marker, String name) throws NoSuchMethodException {
        Method accessor;
        Class<? extends Marker> markerClass = RootMarkerAttributesHandler.getClass(marker);
        Map<String, Method> methodMap = ATTRIBUTE_ACCESSORS_BY_CLASS_AND_NAME.get(markerClass);
        if (null == methodMap) {
            methodMap = new HashMap<String, Method>();
            ATTRIBUTE_ACCESSORS_BY_CLASS_AND_NAME.put(markerClass, methodMap);
        }
        if (null == (accessor = methodMap.get(name))) {
            accessor = markerClass.getMethod(name, null);
            methodMap.put(name, accessor);
        }
        return accessor;
    }

    private static Class<? extends Marker> getClass(Marker marker) {
        return (Class)AdapterManager.Factory.getAdapterManager().adapt((Object)marker, Class.class);
    }

    @Override
    public Object getAttribute(Marker marker, String name) {
        Object value = this.attrs.get(name);
        if (null == value) {
            try {
                Method method = RootMarkerAttributesHandler.getAccessorMethod(marker, name);
                MarkerAttribute annotation = method.getAnnotation(MarkerAttribute.class);
                if (null != annotation) {
                    value = annotation.defaultValue();
                }
                value = RootMarkerAttributesHandler.translateValue(value, method.getReturnType());
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return value;
    }

    @Override
    public int getAttribute(Marker marker, String name, int defaultVal) {
        Object value = this.attrs.get(name);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return defaultVal;
    }

    @Override
    public long getAttribute(Marker marker, String name, long defaultVal) {
        Object value = this.attrs.get(name);
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return defaultVal;
    }

    @Override
    public float getAttribute(Marker marker, String name, float defaultVal) {
        Object value = this.attrs.get(name);
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        return defaultVal;
    }

    @Override
    public double getAttribute(Marker marker, String name, double defaultVal) {
        Object value = this.attrs.get(name);
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return defaultVal;
    }

    @Override
    public boolean getAttribute(Marker marker, String name, boolean defaultVal) {
        Object value = this.attrs.get(name);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return defaultVal;
    }

    @Override
    public Map<String, Object> getAttributes(Marker marker) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(this.attrs);
        for (String attrName : PRIVATE_ATTRS) {
            attributes.remove(attrName);
        }
        return attributes;
    }

    @Override
    public Map<String, Object> getAttributes(Marker marker, String ... names) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (String name : names) {
            values.put(name, this.getAttribute(marker, name));
        }
        return values;
    }

    @Override
    public Map<String, Object> getAttributes(Marker marker, Map<String, Object> defaults) {
        if (defaults == null || defaults.isEmpty()) {
            return this.getAttributes(marker);
        }
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : defaults.entrySet()) {
            Object value = this.getAttribute(marker, entry.getKey());
            attrs.put(entry.getKey(), value != null ? value : entry.getValue());
        }
        return attrs;
    }

    @Override
    public void update(Marker marker, Map<String, Object> attributes, boolean replace) throws MarkerException {
        this.oldAttrs = this.getAttributes(marker);
        if (replace) {
            this.clear();
        }
        this.attrs.put(ATTR_LAST_UPDATED, System.currentTimeMillis());
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            String attrName = entry.getKey();
            Object attrValue = entry.getValue();
            AttributeHandler handler = null;
            try {
                handler = AttributeHandler.valueOf(attrName);
            }
            catch (Exception e) {
                handler = AttributeHandler.DEFAULT;
            }
            handler.setAttribute(this.attrs, attrName, attrValue);
        }
    }

    @Override
    public Map<String, Object> removedAttributes(Marker marker) {
        if (this.oldAttrs == null || this.oldAttrs.isEmpty()) {
            return Collections.emptyMap();
        }
        HashSet<String> oldKeys = new HashSet<String>(this.oldAttrs.keySet());
        HashSet<String> newKeys = new HashSet<String>(this.getAttributes(marker).keySet());
        oldKeys.removeAll(newKeys);
        HashMap<String, Object> removed = new HashMap<String, Object>();
        for (String key : oldKeys) {
            removed.put(key, this.oldAttrs.get(key));
        }
        return removed;
    }

    @Override
    public Map<String, Object> addedAttributes(Marker marker) {
        if (this.oldAttrs == null || this.oldAttrs.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, Object> attrs = this.getAttributes(marker);
        HashSet<String> newKeys = new HashSet<String>(attrs.keySet());
        HashSet<String> oldKeys = new HashSet<String>(this.oldAttrs.keySet());
        newKeys.removeAll(oldKeys);
        HashMap<String, Object> added = new HashMap<String, Object>();
        for (String key : newKeys) {
            added.put(key, attrs.get(key));
        }
        return added;
    }

    @Override
    public Map<String, Object> modifiedAttributes(Marker marker) {
        if (this.oldAttrs == null || this.oldAttrs.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, Object> newAttrs = this.getAttributes(marker);
        HashSet<String> oldKeys = new HashSet<String>(this.oldAttrs.keySet());
        HashSet<String> newKeys = new HashSet<String>(newAttrs.keySet());
        oldKeys.retainAll(newKeys);
        HashMap<String, Object> removed = new HashMap<String, Object>();
        for (String key : oldKeys) {
            Object newValue;
            Object oldValue = this.oldAttrs.get(key);
            if (!ModelUtil.areDifferent((Object)oldValue, (Object)(newValue = newAttrs.get(key)))) continue;
            removed.put(key, oldValue);
        }
        return removed;
    }

    private static Object translateValue(Marker marker, Object value, String name) {
        try {
            Method method = RootMarkerAttributesHandler.getClass(marker).getMethod(name, null);
            Class<?> type = method.getReturnType();
            return RootMarkerAttributesHandler.translateValue(value, type);
        }
        catch (Exception e) {
            return value;
        }
    }

    private static Object translateValue(Object value, Class<?> type) {
        if (Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type)) {
            return null != value ? Long.valueOf(String.valueOf(value)) : 0L;
        }
        if (Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type)) {
            return null != value ? Integer.valueOf(String.valueOf(value)) : 0;
        }
        if (Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type)) {
            return null != value ? Double.valueOf(String.valueOf(value)) : 0.0;
        }
        if (Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type)) {
            return Float.valueOf(null != value ? Float.valueOf(String.valueOf(value)).floatValue() : 0.0f);
        }
        if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
            return null != value ? Boolean.valueOf(String.valueOf(value)) : false;
        }
        return value;
    }

    private Map<String, Object> hashStructureToMap(Marker marker, HashStructure hash) {
        if (hash == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : hash.keySet()) {
            map.put(key, RootMarkerAttributesHandler.translateValue(marker, hash.getObject(key), key));
        }
        return map;
    }

    private void clear() {
        HashMap<String, Object> cleared = new HashMap<String, Object>();
        for (String privateAttr : PRIVATE_ATTRS) {
            cleared.put(privateAttr, this.attrs.get(privateAttr));
        }
        this.attrs = cleared;
    }

    private static HashStructure hashStructureFor(Marker.EventDescription event) {
        if (null == event) {
            return null;
        }
        HashStructure hash = HashStructure.newInstance();
        hash.putString(ATTR_EVENT_ID, event.getId());
        hash.putString(ATTR_EVENT_DESC, event.getDescription());
        hash.putLong(ATTR_EVENT_TIMESTAMP, event.getTimestamp());
        return hash;
    }

    static {
        MAP_ATTR_TYPES.put(String.class, new NameValuePair("String", String.class));
        MAP_ATTR_TYPES.put(Integer.class, new NameValuePair("Int", Integer.TYPE));
        MAP_ATTR_TYPES.put(Long.class, new NameValuePair("Long", Long.TYPE));
        MAP_ATTR_TYPES.put(Float.class, new NameValuePair("Float", Float.TYPE));
        MAP_ATTR_TYPES.put(Double.class, new NameValuePair("Double", Double.TYPE));
        MAP_ATTR_TYPES.put(Boolean.class, new NameValuePair("Boolean", Boolean.TYPE));
        MAP_ATTR_TYPES.put(URL.class, new NameValuePair("URL", URL.class));
        ATTRIBUTE_ACCESSORS_BY_CLASS_AND_NAME = new HashMap();
    }

    public static class HashStructureAdapterFactory
    implements AdapterFactory<RootMarkerAttributesHandler, HashStructure> {
        public HashStructure adapt(RootMarkerAttributesHandler handler) {
            HashStructure hash = HashStructure.newInstance();
            for (Map.Entry<String, Object> entry : handler.attrs.entrySet()) {
                Object value = entry.getValue();
                if (null == value) continue;
                NameValuePair pair = (NameValuePair)MAP_ATTR_TYPES.get(value.getClass());
                if (null == pair) {
                    if (!RootMarkerAttributesHandler.ATTR_EVENTS.equals(entry.getKey()) || !(entry.getValue() instanceof Iterable)) continue;
                    this.addEvents(hash, entry);
                    continue;
                }
                String methodName = MessageFormat.format(RootMarkerAttributesHandler.PUT_METHOD_NAME_FMT, pair.getName());
                Class[] argTypes = new Class[]{String.class, (Class)pair.getValue()};
                try {
                    Method putMethod = HashStructure.class.getMethod(methodName, argTypes);
                    putMethod.invoke((Object)hash, entry.getKey(), entry.getValue());
                }
                catch (Exception e) {
                    Logger.getAnonymousLogger().log(Level.WARNING, e.getMessage());
                }
            }
            return hash;
        }

        private void addEvents(HashStructure hash, Map.Entry<String, Object> attr) {
            ListStructure list = ListStructure.newInstance();
            for (Object obj : (Iterable)attr.getValue()) {
                if (!(obj instanceof Marker.EventDescription)) continue;
                list.add((Object)RootMarkerAttributesHandler.hashStructureFor((Marker.EventDescription)obj));
            }
            hash.putListStructure(attr.getKey(), list);
        }
    }

    private static enum AttributeHandler {
        events{

            @Override
            public void setAttribute(Map<String, Object> attrs, String attrName, Object attrValue) throws MarkerException {
                if (!this.name().equals(attrName)) {
                    throw new MarkerException("Cannot set attribute: " + attrName);
                }
                if (null == attrValue) {
                    attrs.remove(attrName);
                    return;
                }
                if (!(attrValue instanceof Collection)) {
                    throw new MarkerException(MessageFormat.format(RootMarkerAttributesHandler.INVALID_ATTR_TYPE_MSG, attrName, attrValue.getClass().getName()));
                }
                ArrayList<Marker.EventDescription> list = new ArrayList<Marker.EventDescription>();
                for (Object obj : (Collection)attrValue) {
                    if (!(obj instanceof Marker.EventDescription)) continue;
                    list.add((Marker.EventDescription)obj);
                }
                attrs.put(attrName, list);
            }
        }
        ,
        DEFAULT;


        public void setAttribute(Map<String, Object> attrs, String attrName, Object attrValue) throws MarkerException {
            Class<?> valClass = attrValue.getClass();
            NameValuePair pair = (NameValuePair)MAP_ATTR_TYPES.get(valClass);
            if (pair == null) {
                throw new MarkerException(MessageFormat.format(RootMarkerAttributesHandler.INVALID_ATTR_TYPE_MSG, attrName, valClass.getName()));
            }
            attrs.put(attrName, attrValue);
        }
    }
}

