/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.insight.completion;

import javax.swing.SwingWorker;
import oracle.ide.insight.completion.CompletionContext;
import oracle.ide.insight.completion.CompletionModel;
import oracle.ide.insight.completion.CompletionProvider;
import oracle.ide.insight.completion.CompletionResults;
import oracle.javatools.buffer.ExpiredTextBufferException;

final class CompletionWorker
extends SwingWorker<CompletionResults, Object> {
    private final CompletionContext insightContext;
    private final CompletionResults previousResults;
    private final boolean isUpdate;

    CompletionWorker(CompletionContext insightContext) {
        this.insightContext = insightContext;
        this.isUpdate = false;
        this.previousResults = null;
    }

    CompletionWorker(CompletionContext insightContext, CompletionResults previousResults) {
        this.insightContext = insightContext;
        this.previousResults = previousResults;
        this.isUpdate = true;
    }

    CompletionContext getInsightContext() {
        return this.insightContext;
    }

    boolean isUpdate() {
        return this.isUpdate;
    }

    @Override
    protected CompletionResults doInBackground() throws Exception {
        CompletionResults results;
        block7: {
            results = new CompletionResults();
            try {
                if (this.isUpdate) {
                    CompletionModel model = this.insightContext.getProvider().updateModel(this.insightContext, this.previousResults.getModel(this.insightContext.getProvider()));
                    if (model != null) {
                        results.addResults(this.insightContext.getProvider(), model);
                    }
                } else {
                    for (CompletionProvider provider : this.insightContext.getMultiProvider().getAllProviders()) {
                        Object model = provider.getModel(this.insightContext);
                        if (model == null) continue;
                        results.addResults(provider, (CompletionModel)model);
                    }
                }
            }
            catch (ExpiredTextBufferException etbe) {
            }
            catch (Exception e) {
                if (Thread.interrupted()) break block7;
                throw e;
            }
        }
        return results;
    }
}

