/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.insight.filter;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.insight.InsightItem;
import oracle.ide.insight.filter.FilterUtils;
import oracle.ide.insight.filter.InsightFilter;
import oracle.javatools.util.CamelCaseFilter;
import oracle.javatools.util.ModelUtil;

public final class CamelCaseInsightFilter<T extends InsightItem>
implements InsightFilter<T> {
    private final boolean applyContains;

    public CamelCaseInsightFilter() {
        this(false);
    }

    public CamelCaseInsightFilter(boolean applyContains) {
        this.applyContains = applyContains;
    }

    @Override
    public T findClosestDataItem(List<T> items, String name) {
        CamelCaseFilter filter = this.createCamelCaseFilter(name);
        for (InsightItem listDataItem : items) {
            String itemName = listDataItem.getName();
            if (!filter.matches(itemName)) continue;
            return (T)listDataItem;
        }
        return FilterUtils.findClosestDataItem(items, name);
    }

    @Override
    public List<T> getMatchingDataItems(List<T> items, String prefix) {
        List<T> matchingItems = items;
        if (ModelUtil.hasLength((String)prefix)) {
            matchingItems = this.getMatchingDataList(items, prefix);
        }
        return matchingItems;
    }

    protected final List<T> getMatchingDataList(List<T> items, String filterText) {
        ArrayList<InsightItem> matchingItems = new ArrayList<InsightItem>(items.size());
        CamelCaseFilter camelCaseFilter = this.createCamelCaseFilter(filterText);
        for (InsightItem item : items) {
            String itemName = item.getName();
            if (item.isFilterable() && !camelCaseFilter.matches(itemName)) continue;
            matchingItems.add(item);
        }
        return matchingItems;
    }

    @Override
    public String findCommonPrefix(List<T> items, String prefix) {
        return FilterUtils.findCommonPrefix(items, prefix);
    }

    private CamelCaseFilter createCamelCaseFilter(final String filterText) {
        if (!this.applyContains) {
            return new CamelCaseFilter(filterText);
        }
        return new CamelCaseFilter(filterText){
            final String filterTextLower;
            {
                super(x0);
                this.filterTextLower = filterText.toLowerCase();
            }

            public boolean matches(String name) {
                return super.matches(name) || name.toLowerCase().contains(this.filterTextLower);
            }
        };
    }
}

