/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.insight.tooltip;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingWorker;
import oracle.ide.insight.tooltip.ToolTipContext;
import oracle.ide.insight.tooltip.ToolTipProvider;
import oracle.javatools.buffer.ExpiredTextBufferException;

final class ToolTipWorker<T>
extends SwingWorker<Map<ToolTipProvider<T>, List<T>>, Object> {
    private final ToolTipContext insightContext;
    private final Map<ToolTipProvider<T>, List<T>> previousResults;

    ToolTipWorker(ToolTipContext insightContext) {
        this.insightContext = insightContext;
        this.previousResults = null;
    }

    ToolTipWorker(ToolTipContext insightContext, Map<ToolTipProvider<T>, List<T>> previousResults) {
        this.insightContext = insightContext;
        this.previousResults = previousResults;
    }

    boolean isUpdate() {
        return this.previousResults != null;
    }

    @Override
    protected Map<ToolTipProvider<T>, List<T>> doInBackground() throws Exception {
        HashMap<ToolTipProvider<T>, List<T>> results = new HashMap<ToolTipProvider<T>, List<T>>();
        try {
            for (ToolTipProvider provider : this.insightContext.getProviders()) {
                List items = this.isUpdate() ? provider.updateItems(this.insightContext, this.previousResults.get(provider)) : provider.getItems(this.insightContext);
                results.put(provider, items);
            }
        }
        catch (ExpiredTextBufferException expiredTextBufferException) {
            // empty catch block
        }
        return results;
    }

    public ToolTipContext getInsightContext() {
        return this.insightContext;
    }
}

