/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Observable;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.MetaClass;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSplitPane;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.diffmerge.impl.LocalActionCache;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.ide.vhv.VHVConstants;
import oracle.ide.vhv.VHVCustomizer;
import oracle.ide.vhv.VHVDockableFactory;
import oracle.ide.vhv.VHVPropertiesWindow;
import oracle.ide.vhv.VHVResource;
import oracle.ide.vhv.VHVResourceException;
import oracle.ide.vhv.VHVURLHelper;
import oracle.ide.vhv.model.BranchElement;
import oracle.ide.vhv.model.CheckOutElement;
import oracle.ide.vhv.model.ContextElement;
import oracle.ide.vhv.model.GraphElement;
import oracle.ide.vhv.model.INameHelper;
import oracle.ide.vhv.model.MergeTarget;
import oracle.ide.vhv.model.SuccessorElement;
import oracle.ide.vhv.model.VersionTree;
import oracle.ide.vhv.resource.VHVArb;
import oracle.ide.vhv.view.GraphShape;
import oracle.ide.vhv.view.SelectionMode;
import oracle.ide.vhv.view.SuccessorShape;
import oracle.ide.vhv.view.VersionTreeDiagramEvent;
import oracle.ide.vhv.view.VersionTreeDiagramListener;
import oracle.ide.vhv.view.VersionTreeDiagramPane;
import oracle.ide.view.View;
import oracle.javatools.editor.PopupManager;

public class VHVControl
extends JPanel
implements INameHelper,
VersionTreeDiagramListener {
    public static final String s_NodeColor = "NodeColor";
    public static final Color NODE_COLOR = new Color(255, 255, 255, 127);
    public static final String s_MajorNodeColor = "MajorNodeColor";
    public static final Color MAJOR_NODE_COLOR = new Color(51, 102, 153, 127);
    public static final String s_LeafNodeColor = "LeafNodeColor";
    public static final Color LEAF_NODE_COLOR = new Color(204, 204, 153, 127);
    public static final String s_InContextNodeColor = "InContextNodeColor";
    public static final Color IN_CONTEXT_NODE_COLOR = new Color(153, 204, 255, 127);
    public static final String s_ReservedCheckoutNodeColor = "ReservedCheckoutNodeColor";
    public static final Color RESERVED_CHECKOUT_NODE_COLOR = new Color(255, 255, 204, 127);
    public static final String s_UnreservedCheckoutNodeColor = "UnreservedCheckoutNodeColor";
    public static final Color UNRESERVED_CHECKOUT_NODE_COLOR = new Color(255, 255, 204, 127);
    public static final String s_BranchColor = "BranchColor";
    public static final Color BRANCH_COLOR = new Color(255, 255, 255, 127);
    public static final String s_NonRepositoryMergeColor = "NonRepositoryMergeColor";
    public static final Color NON_REPOSITORY_MERGE_COLOR = new Color(255, 102, 0);
    public static final String s_RepositoryMergeColor = "RepositoryMergeColor";
    public static final Color REPOSITORY_MERGE_COLOR = new Color(255, 102, 0);
    public static final Cursor _compareActiveCursor = Toolkit.getDefaultToolkit().createCustomCursor(Toolkit.getDefaultToolkit().getImage(VHVArb.class.getResource("images/CompareActiveCursor.gif")), new Point(0, 0), "Compare Active");
    public static final Cursor _compareValidCursor = Toolkit.getDefaultToolkit().createCustomCursor(Toolkit.getDefaultToolkit().getImage(VHVArb.class.getResource("images/CompareValidCursor.gif")), new Point(8, 9), "Compare Valid");
    public static final Cursor _mergeActiveCursor = Toolkit.getDefaultToolkit().createCustomCursor(Toolkit.getDefaultToolkit().getImage(VHVArb.class.getResource("images/MergeActiveCursor.gif")), new Point(0, 0), "Merge Active");
    public static final Cursor _mergeValidCursor = Toolkit.getDefaultToolkit().createCustomCursor(Toolkit.getDefaultToolkit().getImage(VHVArb.class.getResource("images/MergeValidCursor.gif")), new Point(8, 9), "Merge Valid");
    public static final int NORMAL_VHV_STATE = 0;
    public static final int COMPARE_VHV_STATE = 1;
    public static final int MERGE_VHV_STATE = 2;
    private final ChangeListener _mergeSaveListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent ce) {
            VHVControl.this.requery();
        }
    };
    private VersionTreeDiagramPane _versionTreeDiagramPane;
    private PopupManager _popupManager;
    private int _vhvState = 0;
    private GraphShape _selectedGraphShape;
    private GraphShape _secondSelectedGraphShape;
    private final VHVCustomizer _customizer;
    private final View _view;
    private final LocalActionCache _localActionCache;
    private JSplitPane _splitPane;
    private final JScrollBar _hScrollBar = new JScrollBar(0);
    private final JScrollBar _vScrollBar = new JScrollBar(1);
    private boolean _actionsSuspended;
    private Observable _diagramViewObservable;

    public void resetScrollBars() {
        this._hScrollBar.setMinimum(0);
        this._vScrollBar.setMinimum(0);
        this._hScrollBar.setMaximum(0);
        this._vScrollBar.setMaximum(0);
        this._hScrollBar.setValue(0);
        this._vScrollBar.setValue(0);
    }

    public VHVControl(View view, VHVCustomizer customizer, LocalActionCache localActionCache) {
        this.resetScrollBars();
        this._view = view;
        this._localActionCache = localActionCache;
        this.setLayout(new BorderLayout());
        this._customizer = customizer;
        this._customizer.getSessionManager().addMergeSaveListener(this._mergeSaveListener);
    }

    public final void setDiagramViewObservable(Observable o) {
        this._diagramViewObservable = o;
    }

    public void setActionsSuspended(boolean actionsSuspended) {
        this._actionsSuspended = actionsSuspended;
        this.updateContextSensitiveActions();
    }

    public VHVCustomizer getCustomizer() {
        return this._customizer;
    }

    public void initializeSplitPane() {
        this._splitPane.setDividerLocation(this._splitPane.getSize().height - this._splitPane.getDividerSize() - 105);
    }

    public void setScrollingEnabled(boolean enabled) {
        this._hScrollBar.setEnabled(enabled);
        this._vScrollBar.setEnabled(enabled);
        if (this._versionTreeDiagramPane != null) {
            this._versionTreeDiagramPane.updateScrollBars();
        }
    }

    public void install(VersionTree versionTree) throws VHVResourceException {
        versionTree.showAllNodes(true);
        this._versionTreeDiagramPane = new VersionTreeDiagramPane(versionTree, this._hScrollBar, this._vScrollBar);
        this._versionTreeDiagramPane.addVersionTreeDiagramListener(this);
        this._versionTreeDiagramPane.setDiagramViewObservable(this._diagramViewObservable);
        this.layoutGUI();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                VHVControl.this._versionTreeDiagramPane.selectInContextVersion();
            }
        });
        this._versionTreeDiagramPane.getPanel().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if ((VHVControl.this._vhvState == 1 || VHVControl.this._vhvState == 2) && e.getKeyCode() == 27) {
                    VHVControl.this.setSelectionState(0);
                }
            }
        });
    }

    public void deinstall() {
        this._customizer.getSessionManager().removeMergeSaveListener(this._mergeSaveListener);
        this.removeAll();
        this._versionTreeDiagramPane = null;
        this._selectedGraphShape = null;
        this._secondSelectedGraphShape = null;
    }

    public VersionTreeDiagramPane getVersionTreeDiagramPane() {
        return this._versionTreeDiagramPane;
    }

    public JScrollBar getHorizontalScrollBar() {
        return this._hScrollBar;
    }

    public JScrollBar getVerticalScrollBar() {
        return this._vScrollBar;
    }

    public void addPopupManager(PopupManager popupManager) {
        this._popupManager = popupManager;
    }

    public void removePopupManager(PopupManager popupManager) {
        if (this._popupManager == popupManager) {
            this._popupManager = null;
        }
    }

    public void updateContextSensitiveActions() {
        IdeAction.find((int)51).updateAction();
        if (this._customizer.getCheckOutAction() != null) {
            this._customizer.getCheckOutAction().updateAction();
        }
        if (this._customizer.getCheckInAction() != null) {
            this._customizer.getCheckInAction().updateAction();
        }
        if (this._customizer.getUndoCheckoutAction() != null) {
            this._customizer.getUndoCheckoutAction().updateAction();
        }
        IdeAction.find((int)VHVConstants.VHV_COMPARE_PREVIOUS_CMD_ID).updateAction();
        IdeAction.find((int)VHVConstants.VHV_COMPARE_OTHER_CMD_ID).updateAction();
        IdeAction.find((int)VHVConstants.VHV_MERGE_CMD_ID).updateAction();
        IdeAction.find((int)VHVConstants.VHV_INSIGNIFICANT_VERSIONS_CMD_ID).updateAction();
        IdeAction.find((int)VHVConstants.VHV_DEFAULT_LAYOUT_CMD_ID).updateAction();
        IdeAction.find((int)VHVConstants.VHV_ZOOM_IN_CMD_ID).updateAction();
        IdeAction.find((int)VHVConstants.VHV_ZOOM_OUT_CMD_ID).updateAction();
        IdeAction.find((int)VHVConstants.VHV_ZOOM_DEFAULT_CMD_ID).updateAction();
        IdeAction.find((int)VHVConstants.VHV_ZOOM_TO_SIZE_CMD_ID).updateAction();
        IdeAction.find((int)VHVConstants.VHV_VERSION_PROPERTIES_CMD_ID).updateAction();
        this._view.updateVisibleActions();
    }

    public boolean updateAction(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == 51) {
            action.setEnabled(!this._actionsSuspended);
            return true;
        }
        if (cmdId == VHVConstants.VHV_INSIGNIFICANT_VERSIONS_CMD_ID) {
            action.setEnabled(!this._actionsSuspended);
            return true;
        }
        if (cmdId == VHVConstants.VHV_DEFAULT_LAYOUT_CMD_ID) {
            action.setEnabled(!this._actionsSuspended);
            return true;
        }
        if (cmdId == VHVConstants.VHV_ZOOM_IN_CMD_ID) {
            action.setEnabled(!this._actionsSuspended && this.canZoomIn());
            return true;
        }
        if (cmdId == VHVConstants.VHV_ZOOM_OUT_CMD_ID) {
            action.setEnabled(!this._actionsSuspended && this.canZoomOut());
            return true;
        }
        if (cmdId == VHVConstants.VHV_ZOOM_DEFAULT_CMD_ID) {
            action.setEnabled(!this._actionsSuspended && this.canZoomDefault());
            return true;
        }
        if (cmdId == VHVConstants.VHV_ZOOM_TO_SIZE_CMD_ID) {
            action.setEnabled(!this._actionsSuspended && this.canZoomToSize());
            return true;
        }
        if (this._customizer.getCheckOutAction() != null && cmdId == this._customizer.getCheckOutAction().getCommandId()) {
            action.setEnabled(!this._actionsSuspended && this.canCheckOut());
            return true;
        }
        if (this._customizer.getCheckInAction() != null && cmdId == this._customizer.getCheckInAction().getCommandId()) {
            action.setEnabled(!this._actionsSuspended && this.canCheckIn());
            return true;
        }
        if (this._customizer.getUndoCheckoutAction() != null && cmdId == this._customizer.getUndoCheckoutAction().getCommandId()) {
            action.setEnabled(!this._actionsSuspended && this.canCheckIn());
            return true;
        }
        if (cmdId == VHVConstants.VHV_COMPARE_PREVIOUS_CMD_ID) {
            action.setEnabled(!this._actionsSuspended && this._customizer.getComparePreviousCommand() != null && this.canComparePrevious());
            return true;
        }
        if (cmdId == VHVConstants.VHV_COMPARE_OTHER_CMD_ID) {
            action.setEnabled(!this._actionsSuspended && this._customizer.getCompareOtherCommand() != null && this.canCompareOther());
            return true;
        }
        if (cmdId == VHVConstants.VHV_MERGE_CMD_ID) {
            action.setEnabled(!this._actionsSuspended && this._customizer.getMergeCommand() != null && this.canMerge());
            return true;
        }
        if (cmdId == VHVConstants.VHV_VERSION_PROPERTIES_CMD_ID) {
            action.setEnabled(!this._actionsSuspended);
            return true;
        }
        if (cmdId == VHVConstants.VHV_PAN_CMD_ID) {
            action.setEnabled(!this._actionsSuspended);
            return true;
        }
        return false;
    }

    private boolean canZoomIn() {
        return this._versionTreeDiagramPane != null && this._versionTreeDiagramPane.getZoom() < 32.0;
    }

    private boolean canZoomOut() {
        return this._versionTreeDiagramPane != null && this._versionTreeDiagramPane.getZoom() > 0.03125;
    }

    private boolean canZoomDefault() {
        return this._versionTreeDiagramPane != null && this._versionTreeDiagramPane.getZoom() != 1.0;
    }

    private boolean canZoomToSize() {
        return true;
    }

    public boolean handleAction(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == 51) {
            this.requery();
            return true;
        }
        if (cmdId == VHVConstants.VHV_INSIGNIFICANT_VERSIONS_CMD_ID) {
            Collection<GraphElement> selection = this.viewToModel(this._versionTreeDiagramPane.getSelection());
            this._versionTreeDiagramPane.toggleAllNodesMajorNodes();
            this._versionTreeDiagramPane.select(this.modelToView(selection));
            action.updateAction();
            return true;
        }
        if (cmdId == VHVConstants.VHV_DEFAULT_LAYOUT_CMD_ID) {
            Collection<GraphElement> selection = this.viewToModel(this._versionTreeDiagramPane.getSelection());
            this._versionTreeDiagramPane.defaultLayout();
            this._versionTreeDiagramPane.select(this.modelToView(selection));
            return true;
        }
        if (cmdId == VHVConstants.VHV_ZOOM_IN_CMD_ID) {
            this._versionTreeDiagramPane.zoomIn();
            this.updateContextSensitiveActions();
            return true;
        }
        if (cmdId == VHVConstants.VHV_ZOOM_OUT_CMD_ID) {
            this._versionTreeDiagramPane.zoomOut();
            this.updateContextSensitiveActions();
            return true;
        }
        if (cmdId == VHVConstants.VHV_ZOOM_DEFAULT_CMD_ID) {
            this._versionTreeDiagramPane.setZoom(1.0);
            this.updateContextSensitiveActions();
            return true;
        }
        if (cmdId == VHVConstants.VHV_ZOOM_TO_SIZE_CMD_ID) {
            this._versionTreeDiagramPane.zoomToSize();
            this.updateContextSensitiveActions();
            return true;
        }
        if (cmdId == VHVConstants.VHV_VERSION_PROPERTIES_CMD_ID) {
            VHVDockableFactory.showPropertiesWindow();
            return true;
        }
        if (cmdId == VHVConstants.VHV_PAN_CMD_ID) {
            this._vhvState = 0;
            this._versionTreeDiagramPane.getPanel().setSelectionMode(IdeAction.find((int)VHVConstants.VHV_PAN_CMD_ID).getState() ? SelectionMode.PAN : SelectionMode.SELECT);
            return true;
        }
        return false;
    }

    private void layoutGUI() {
        try {
            this.add((Component)this._versionTreeDiagramPane.getViewport(), "Center");
        }
        catch (Exception e) {
            this._customizer.getExceptionHandler().handleException(e, (Component)Ide.getMainWindow());
        }
        this.revalidate();
        this.repaint();
    }

    private Collection<GraphShape> modelToView(Collection<GraphElement> graphElements) {
        ArrayList<GraphShape> c = new ArrayList<GraphShape>();
        for (GraphElement graphElement : graphElements) {
            GraphShape graphShape = (GraphShape)graphElement.getShape();
            if (graphShape == null) continue;
            c.add(graphShape);
        }
        return c;
    }

    private Collection<GraphElement> viewToModel(Collection<GraphShape> graphShapes) {
        ArrayList<GraphElement> c = new ArrayList<GraphElement>();
        for (GraphShape graphShape : graphShapes) {
            GraphElement graphElement = graphShape.getGraphElement();
            if (graphElement == null) continue;
            c.add(graphElement);
        }
        return c;
    }

    public void populateContextMenu(ContextMenu contextMenu) {
        float section = 0.0f;
        if (this.canCheckOut() && this._customizer.getCheckOutAction() != null) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getLocalAction(this._customizer.getCheckOutAction().getCommandId(), this._view)), section);
        }
        if (this.canCheckIn() && this._customizer.getCheckInAction() != null) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getLocalAction(this._customizer.getCheckInAction().getCommandId(), this._view)), section);
        }
        if (this.canCheckIn() && this._customizer.getUndoCheckoutAction() != null) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getLocalAction(this._customizer.getUndoCheckoutAction().getCommandId(), this._view)), section);
        }
        section += 1.0f;
        if (this._customizer.getComparePreviousCommand() != null && this.canComparePrevious()) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getLocalAction(VHVConstants.VHV_COMPARE_PREVIOUS_CMD_ID, this._view)), section);
        }
        if (this._customizer.getCompareOtherCommand() != null && this.canCompareOther()) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getLocalAction(VHVConstants.VHV_COMPARE_OTHER_CMD_ID, this._view)), section);
        }
        if (this._customizer.getMergeCommand() != null) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getLocalAction(VHVConstants.VHV_MERGE_CMD_ID, this._view)), section);
        }
        this.getLocalAction(VHVConstants.VHV_INSIGNIFICANT_VERSIONS_CMD_ID, this._view).putValue("Check", (Object)Boolean.TRUE);
        contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getLocalAction(VHVConstants.VHV_INSIGNIFICANT_VERSIONS_CMD_ID, this._view)), section += 1.0f);
        contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getLocalAction(VHVConstants.VHV_DEFAULT_LAYOUT_CMD_ID, this._view)), section);
        section += 1.0f;
        if (this.canZoomIn()) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getLocalAction(VHVConstants.VHV_ZOOM_IN_CMD_ID, this._view)), section);
        }
        if (this.canZoomOut()) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getLocalAction(VHVConstants.VHV_ZOOM_OUT_CMD_ID, this._view)), section);
        }
        if (this.canZoomDefault()) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getLocalAction(VHVConstants.VHV_ZOOM_DEFAULT_CMD_ID, this._view)), section);
        }
        if (this.canZoomToSize()) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getLocalAction(VHVConstants.VHV_ZOOM_TO_SIZE_CMD_ID, this._view)), section);
        }
        this.getLocalAction(VHVConstants.VHV_PAN_CMD_ID, this._view).putValue("Check", (Object)Boolean.TRUE);
        contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getLocalAction(VHVConstants.VHV_PAN_CMD_ID, this._view)), section);
        contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getLocalAction(VHVConstants.VHV_VERSION_PROPERTIES_CMD_ID, this._view)), section += 1.0f);
        contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getLocalAction(51, this._view)), section += 1.0f);
    }

    protected IdeAction getLocalAction(int cmdId, View view) {
        return this._localActionCache.getLocalAction(cmdId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void graphNodeSelected(VersionTreeDiagramEvent e) {
        if (this._vhvState == 0) {
            if (this._popupManager != null && e.getMouseEvent() != null && e.getMouseEvent().isPopupTrigger()) {
                this._popupManager.showPopup(null, e.getMouseEvent());
            }
            if (e.isSingleSelection()) {
                this.setSelectedGraphShape(e.getGraphShape());
            } else {
                this.setSelectedGraphShape(null);
            }
        } else if (this._vhvState == 1) {
            this.setSelectionState(0);
            if (e.isSingleSelection()) {
                if (this.isValidCompareTarget(e.getGraphShape().getGraphElement())) {
                    this._secondSelectedGraphShape = e.getGraphShape();
                    try {
                        IdeAction ideAction = IdeAction.find((int)VHVConstants.VHV_PERFORM_COMPARE_CMD_ID);
                        assert (ideAction != null);
                        MetaClass mClass = new MetaClass(ExtensionRegistry.getExtensionRegistry().getClassLoader("oracle.ide.vhv"), ideAction.getCommand());
                        CommandProcessor.getInstance().invoke(CommandProcessor.createCommandFromMeta((MetaClass)mClass, (Context)this._view.getContext()));
                    }
                    catch (Exception ex) {
                        this._customizer.getExceptionHandler().handleException(ex, (Component)Ide.getMainWindow());
                    }
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        } else if (this._vhvState == 2) {
            this.setSelectionState(0);
            if (e.isSingleSelection()) {
                if (this.isValidMergeTarget(e.getGraphShape().getGraphElement())) {
                    this._secondSelectedGraphShape = e.getGraphShape();
                    try {
                        IdeAction ideAction = IdeAction.find((int)VHVConstants.VHV_PERFORM_MERGE_CMD_ID);
                        assert (ideAction != null);
                        CommandProcessor.getInstance().invoke(CommandProcessor.createCommand((String)ideAction.getCommand(), (Context)this._view.getContext()));
                    }
                    catch (Exception ex) {
                        this._customizer.getExceptionHandler().handleException(ex, (Component)Ide.getMainWindow());
                    }
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    @Override
    public void graphNodeIndicated(VersionTreeDiagramEvent e) {
        if (this._vhvState == 1) {
            if (e.isSingleSelection() && this.isValidCompareTarget(e.getGraphShape().getGraphElement())) {
                this._versionTreeDiagramPane.getPanel().setCursor(_compareValidCursor);
            } else {
                this._versionTreeDiagramPane.getPanel().setCursor(_compareActiveCursor);
            }
        } else if (this._vhvState == 2) {
            if (e.isSingleSelection() && this.isValidMergeTarget(e.getGraphShape().getGraphElement())) {
                this._versionTreeDiagramPane.getPanel().setCursor(_mergeValidCursor);
            } else {
                this._versionTreeDiagramPane.getPanel().setCursor(_mergeActiveCursor);
            }
        }
    }

    private void setSelectedGraphShape(GraphShape graphShape) {
        this._selectedGraphShape = graphShape;
        this.updateContextSensitiveActions();
        VHVPropertiesWindow.updatePropertiesPanel();
    }

    public GraphElement getSelectedGraphElement() {
        return this._selectedGraphShape == null ? null : this._selectedGraphShape.getGraphElement();
    }

    public GraphElement getSecondSelectedGraphElement() {
        return this._secondSelectedGraphShape == null ? null : this._secondSelectedGraphShape.getGraphElement();
    }

    public VHVResource getSelectedResource() {
        return this.getSelectedGraphElement() == null ? null : this.getSelectedGraphElement().getResource();
    }

    public VHVResource getSecondSelectedResource() {
        return this.getSecondSelectedGraphElement() == null ? null : this.getSecondSelectedGraphElement().getResource();
    }

    public boolean canCheckOut() {
        return this._selectedGraphShape != null && this.canCheckOut(this.getSelectedGraphElement());
    }

    private boolean canCheckOut(GraphElement graphElement) {
        if (graphElement instanceof SuccessorElement) {
            return !(this.getVersionTree().getInContextVersion() instanceof CheckOutElement);
        }
        return false;
    }

    public boolean canCheckIn() {
        return this._selectedGraphShape != null && this.canCheckIn(this.getSelectedGraphElement());
    }

    private boolean canCheckIn(GraphElement graphElement) {
        return graphElement instanceof CheckOutElement && ((CheckOutElement)graphElement).isInContext();
    }

    public boolean canComparePrevious() {
        if (URLFileSystem.isDirectoryPath((URL)this.getRealURL(this._view.getContext()))) {
            return false;
        }
        return this._selectedGraphShape != null && this.canComparePrevious(this.getSelectedGraphElement());
    }

    private boolean canComparePrevious(GraphElement graphElement) {
        if (graphElement instanceof SuccessorElement) {
            try {
                return !((SuccessorElement)graphElement).isRootOfMain();
            }
            catch (VHVResourceException vhvre) {
                this._customizer.getExceptionHandler().handleException(vhvre, IdeUtil.getMainWindow());
                return false;
            }
        }
        return graphElement instanceof CheckOutElement;
    }

    public VHVResource getPredecessorOfSelection() {
        if (this._selectedGraphShape != null) {
            GraphElement predecessor;
            for (predecessor = this.getSelectedGraphElement().getParentElement(); predecessor != null && !(predecessor instanceof ContextElement); predecessor = predecessor.getParentElement()) {
            }
            return predecessor.getResource();
        }
        return null;
    }

    public boolean canCompareOther() {
        if (URLFileSystem.isDirectoryPath((URL)this.getRealURL(this._view.getContext()))) {
            return false;
        }
        return this._selectedGraphShape != null && this.canCompareOther(this.getSelectedGraphElement());
    }

    private boolean canCompareOther(GraphElement graphElement) {
        return graphElement instanceof SuccessorElement || graphElement instanceof CheckOutElement;
    }

    public boolean canMerge() {
        return this._selectedGraphShape instanceof SuccessorShape;
    }

    public void setSelectionState(int vhvState) {
        if (vhvState == 0) {
            this._versionTreeDiagramPane.getPanel().setCursor(Cursor.getPredefinedCursor(0));
            this._vhvState = 0;
            this._versionTreeDiagramPane.setSelectionEnabled(true);
        } else if (vhvState == 1) {
            this._vhvState = 1;
            this._versionTreeDiagramPane.setSelectionEnabled(false);
        } else if (vhvState == 2) {
            this._vhvState = 2;
            this._versionTreeDiagramPane.setSelectionEnabled(false);
        }
    }

    private boolean isValidCompareTarget(GraphElement target) {
        return target instanceof SuccessorElement || target instanceof CheckOutElement;
    }

    private boolean isValidMergeTarget(GraphElement target) {
        if (!this.getSelectedGraphElement().equals(target) && target instanceof MergeTarget) {
            if (target instanceof CheckOutElement) {
                return ((CheckOutElement)target).isInContext();
            }
            return true;
        }
        return false;
    }

    @Override
    public String getObjectName(GraphElement ge) {
        try {
            return ge.getResource().getName();
        }
        catch (VHVResourceException e) {
            return null;
        }
    }

    @Override
    public String getBranchName(GraphElement ge) {
        GraphElement tmpGE;
        if (ge instanceof BranchElement) {
            try {
                return ge.getResource().getName();
            }
            catch (VHVResourceException e) {
                return "Unable to find branch name";
            }
        }
        for (tmpGE = ge; tmpGE != null && !(tmpGE instanceof BranchElement); tmpGE = tmpGE.getOwnerElement()) {
        }
        if (tmpGE != null) {
            try {
                return tmpGE.getResource().getName();
            }
            catch (VHVResourceException e) {
                return "Unable to find branch name";
            }
        }
        return "Unable to find branch name";
    }

    @Override
    public String getUserName(GraphElement ge) {
        try {
            String userName = ge.getUserResource().getName();
            if (userName == null || userName.equals("")) {
                return null;
            }
            return userName;
        }
        catch (VHVResourceException vhvre) {
            this._customizer.getExceptionHandler().handleException(vhvre, IdeUtil.getMainWindow());
            return null;
        }
    }

    public boolean isReadOnly() {
        return false;
    }

    public VersionTree getVersionTree() {
        return this._versionTreeDiagramPane.getVersionTree();
    }

    public void requery() {
        this.requeryBeforeEDT();
        SwingWorker<VersionTree, Object> swingWorker = new SwingWorker<VersionTree, Object>(){

            @Override
            public VersionTree doInBackground() throws Exception {
                return VHVControl.this.requeryInBackground();
            }

            @Override
            protected void done() {
                try {
                    VHVControl.this.requeryAfterEDT((VersionTree)this.get());
                }
                catch (Exception e) {
                    VHVControl.this.requeryHandleException(e);
                }
            }
        };
        swingWorker.execute();
    }

    protected void requeryBeforeEDT() {
    }

    protected VersionTree requeryInBackground() throws Exception {
        return this._versionTreeDiagramPane.requeryInBackground();
    }

    protected void requeryAfterEDT(VersionTree tree) {
        this._versionTreeDiagramPane.requeryAfterEDT(tree);
        this._versionTreeDiagramPane.selectInContextVersion();
        this._versionTreeDiagramPane.scrollToInContextVersion();
        this.updateContextSensitiveActions();
    }

    protected void requeryHandleException(Exception e) {
        this._customizer.getExceptionHandler().handleException(e, (Component)Ide.getMainWindow());
    }

    private URL getRealURL(Context context) {
        URL url = context.getNode().getURL();
        if (url.getProtocol().startsWith("ide.vhv")) {
            url = VHVURLHelper.getRealURL(url);
        }
        return url;
    }
}

