/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.notinserver;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import oracle.aurora.compiler.ExternalEntity;
import oracle.aurora.compiler.QName;

public class ExternalSourceFile
extends ExternalEntity {
    File file;
    String clazz;
    String pkg;
    String encoding;

    public ExternalSourceFile(String fileName, String encoding) {
        super(0);
        this.file = new File(fileName);
        this.encoding = encoding;
        int begin = fileName.lastIndexOf(File.separatorChar) + 1;
        int end = fileName.lastIndexOf(46);
        if (end < begin) {
            end = fileName.length();
        }
        this.clazz = fileName.substring(begin, end);
    }

    public ExternalSourceFile(String fileName) {
        this(fileName, null);
    }

    public boolean isKind(int kind) {
        return kind == 0;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Reader getReader() throws IOException {
        InputStreamReader r = this.encoding == null ? new FileReader(this.file) : new InputStreamReader((InputStream)new FileInputStream(this.file), this.encoding);
        return r;
    }

    public InputStream getStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public Class getLoadedClass() {
        return null;
    }

    public QName getQualifiedName() {
        return new QName(this.pkg, this.clazz);
    }

    public String getPath() {
        return this.file.getAbsolutePath();
    }

    public String getNameForClassFile() {
        String name = this.file.getPath();
        int x = name.lastIndexOf(File.separatorChar);
        if (x >= 0) {
            name = name.substring(x + 1);
        }
        return name;
    }

    public String toString() {
        return this.getPath();
    }

    public boolean equals(Object otherObj) {
        boolean result = false;
        if (otherObj instanceof ExternalSourceFile) {
            try {
                File otherFile = ((ExternalSourceFile)otherObj).file;
                result = this.file.getCanonicalPath().equals(otherFile.getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    public int hashCode() {
        try {
            return this.file.getCanonicalPath().hashCode();
        }
        catch (IOException e) {
            return this.file.hashCode();
        }
    }

    public void setPackage(String pkg) {
        this.pkg = pkg;
    }
}

