/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms;

import java.io.UnsupportedEncodingException;
import oracle.aurora.rdbms.Handle;
import oracle.aurora.rdbms.HandleHolder;
import oracle.aurora.rdbms.KGEException;
import oracle.aurora.rdbms.ModifyPermissionException;
import oracle.aurora.rdbms.NameInUseException;
import oracle.aurora.rdbms.NoSchema;
import oracle.aurora.rdbms.ObjectTypeChangedException;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.rdbms.SourceHandle;
import oracle.aurora.rdbms.WouldReplaceException;
import sun.io.CharToByteConverter;
import sun.io.MalformedInputException;

public final class ResourceHandle
extends Handle {
    ResourceHandle(String name, Schema schema, long index, byte[] timestamp) {
        super(name, schema, index, timestamp);
    }

    public int type() {
        return 30;
    }

    public SourceHandle derivedFrom() throws ObjectTypeChangedException {
        return this.doDerivedFrom();
    }

    private static native void create(byte[] var0, String var1, int var2, boolean var3, HandleHolder var4, String var5) throws NameInUseException, WouldReplaceException, ModifyPermissionException;

    public static ResourceHandle create(byte[] data, String name, Schema schema, boolean replace) throws NameInUseException, WouldReplaceException, ModifyPermissionException {
        if (schema == null) {
            schema = Schema.currentSchema();
        }
        if (name == null) {
            throw new IllegalArgumentException("Null name supplied");
        }
        if (name.length() == 0 || name.charAt(0) == '/') {
            throw new IllegalArgumentException("Illegal name supplied");
        }
        if (schema instanceof NoSchema) {
            throw new IllegalArgumentException("Schema instanceof NoSchema");
        }
        int id = schema.ownerNumber();
        HandleHolder holder = new HandleHolder();
        try {
            ResourceHandle.create(data, name, id, replace, holder, null);
        }
        catch (KGEException e) {
            e.amendMessageAndRethrow("ResourceHandle.create for " + schema.toString() + "." + name);
        }
        ResourceHandle h = (ResourceHandle)holder.handle;
        if (h == null) {
            h = new ResourceHandle(holder.name, schema, holder.index, holder.timestamp);
        }
        h.data = data;
        return h;
    }

    public static ResourceHandle create(char[] cdata, String name, Schema schema, boolean replace) throws NameInUseException, WouldReplaceException, ModifyPermissionException {
        byte[] data = null;
        try {
            data = CharToByteConverter.getConverter((String)"UTF8").convertAll(cdata);
        }
        catch (MalformedInputException e) {
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        if (data == null) {
            return null;
        }
        return ResourceHandle.create(data, name, schema, replace);
    }

    public static ResourceHandle create(String data, String name, Schema schema, boolean replace) throws NameInUseException, WouldReplaceException, ModifyPermissionException {
        return ResourceHandle.create(data.toCharArray(), name, schema, replace);
    }

    static ResourceHandle intern(HandleHolder holder) {
        Schema schema;
        ResourceHandle h = (ResourceHandle)holder.handle;
        if (h == null && (schema = Schema.lookupFixed(holder.schemaNumber)) != null) {
            h = new ResourceHandle(holder.name, schema, holder.index, holder.timestamp);
        }
        return h;
    }

    public int resolve() {
        throw new Error("Resources can not be resolved:" + this + ".resolve");
    }
}

