/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms.url.jserver;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Properties;
import oracle.aurora.rdbms.url.jserver.JserverURLConnection;

public class Handler
extends URLStreamHandler {
    protected URLConnection openConnection(URL u) throws IOException {
        if (!"jserver".equals(u.getProtocol())) {
            throw new MalformedURLException("wrong protocol " + u.getProtocol());
        }
        JserverURLConnection conn = new JserverURLConnection(u);
        return conn;
    }

    public static void main(String[] argv) throws Exception {
        Properties properties = System.getProperties();
        properties.setProperty("java.protocol.handler.pkgs", "oracle.aurora.rdbms.url");
        URL url = new URL(argv[0]);
        URL[] urls = new URL[]{url};
        URLClassLoader loader = new URLClassLoader(urls);
        URL r = loader.getResource(argv[1]);
        System.out.println("getResource " + argv[0] + " = " + r);
        InputStream in = r.openConnection().getInputStream();
        Handler.copy("from url", in);
    }

    private static void copy(String msg, InputStream in) throws IOException {
        System.out.println(msg);
        int count = 0;
        StringBuffer buf = new StringBuffer();
        int c = in.read();
        while (c != -1) {
            buf.append(Integer.toHexString(c & 0xFF));
            buf.append(" ");
            if (++count % 16 == 0) {
                System.out.println(buf.toString());
                buf.setLength(0);
            }
            c = in.read();
        }
        System.out.println(buf.toString());
        System.out.println(count + " bytes");
    }
}

