/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.shell;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class CommandLineParser {
    private static String SPACE = " ";
    private static String QUOTE = "\"";
    private static char QUOTE_CHAR = (char)34;
    private static String BACK_SLASH = "\\";
    private static char PARAM_CHAR = (char)38;
    private static String ESCAPED_PARAM = "&&";
    private static String REDIRECT_PARAM = "&>";
    private static String ALL_PARAMS = "&*";
    private static String ESCAPED_NEW_LINE = "\\n";
    private static String NEW_LINE = "\n";
    private static String LITERAL_QUOTE = "\\\"";
    private static char COMMENT_CHAR = (char)35;
    private static String NEWLINE_PROMPT = "> ";
    private StringTokenizer parser;
    private BufferedReader input;
    private PrintStream output;
    private Vector tokens;
    private String[] args;
    private String fileRedirect = null;

    public CommandLineParser(BufferedReader in, PrintStream out) {
        this(in, out, new String[0]);
    }

    public CommandLineParser(BufferedReader in, PrintStream out, String[] args) {
        this.input = in;
        this.output = out;
        this.args = args == null ? new String[]{} : args;
    }

    public String fileRedirected() {
        return this.fileRedirect;
    }

    private String parse(String token) throws IOException {
        if (token.equals(SPACE)) {
            try {
                return this.parse(this.parser.nextToken(SPACE));
            }
            catch (NoSuchElementException e) {
                return token;
            }
        }
        if (token.charAt(0) == COMMENT_CHAR) {
            try {
                while (this.parser.hasMoreTokens()) {
                    this.parser.nextToken(SPACE);
                }
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
            return SPACE;
        }
        if (token.charAt(0) == QUOTE_CHAR) {
            if ((token = token.substring(1)).endsWith(QUOTE)) {
                return token.substring(0, token.length() - 1);
            }
            try {
                return token + this.parseQuotedString();
            }
            catch (NoSuchElementException e) {
                this.print(NEWLINE_PROMPT);
                this.parser = new StringTokenizer(this.input.readLine(), QUOTE, true);
                return token + NEW_LINE + this.parseQuotedString();
            }
        }
        if (token.equals(LITERAL_QUOTE)) {
            return QUOTE;
        }
        if (token.equals(ESCAPED_NEW_LINE)) {
            return NEW_LINE;
        }
        if (token.equals(BACK_SLASH)) {
            if (this.parser.hasMoreTokens()) {
                return SPACE;
            }
            token = token.substring(0, token.length() - 1);
            this.print(NEWLINE_PROMPT);
            this.parser = new StringTokenizer(this.input.readLine(), SPACE, true);
            try {
                token = this.parse(this.parser.nextToken(SPACE));
                return token;
            }
            catch (NoSuchElementException e) {
                return token;
            }
        }
        if (token.charAt(0) == PARAM_CHAR) {
            try {
                if (token.startsWith(ESCAPED_PARAM)) {
                    return token.substring(1);
                }
                if (token.startsWith(REDIRECT_PARAM)) {
                    this.fileRedirect = token.substring(2);
                    if (this.fileRedirect.length() == 0) {
                        this.fileRedirect = this.parse(this.parser.nextToken(SPACE));
                    }
                    return this.parse(this.parser.nextToken(SPACE));
                }
                if (token.equals(ALL_PARAMS)) {
                    for (int i = 1; i < this.args.length; ++i) {
                        this.tokens.addElement(this.args[i]);
                    }
                    return this.parse(this.parser.nextToken(SPACE));
                }
                try {
                    int paramNum = Integer.parseInt(token.substring(1));
                    return this.args[paramNum];
                }
                catch (NumberFormatException nfe) {
                    return token;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return this.parse(this.parser.nextToken(SPACE));
                }
            }
            catch (NoSuchElementException e) {
                return SPACE;
            }
        }
        return token;
    }

    private void parseLine() throws IOException {
        String line = this.input.readLine();
        if (line == null) {
            throw new EOFException();
        }
        this.parser = new StringTokenizer(line, SPACE, true);
        while (this.parser.hasMoreTokens()) {
            this.tokens.addElement(this.parse(this.parser.nextToken(SPACE)));
        }
    }

    private String parseQuotedString() throws IOException {
        String token;
        try {
            token = this.parser.nextToken(QUOTE);
        }
        catch (NoSuchElementException e) {
            this.print(NEWLINE_PROMPT);
            this.parser = new StringTokenizer(this.input.readLine(), QUOTE, true);
            return NEW_LINE + this.parseQuotedString();
        }
        if (token.equals(QUOTE)) {
            return "";
        }
        try {
            this.parser.nextToken();
        }
        catch (NoSuchElementException e) {
            this.print(NEWLINE_PROMPT);
            this.parser = new StringTokenizer(this.input.readLine(), QUOTE, true);
            return token + NEW_LINE + this.parseQuotedString();
        }
        if (token.equals(ESCAPED_NEW_LINE)) {
            return NEW_LINE;
        }
        if (token.endsWith(BACK_SLASH)) {
            token = token.substring(0, token.length() - 1);
            if (this.parser.hasMoreTokens()) {
                return token + QUOTE;
            }
        }
        return token;
    }

    private void print(String msg) {
        if (this.output != null) {
            this.output.print(msg);
        }
    }

    private void println(String msg) {
        if (this.output != null) {
            this.output.println(msg);
        }
    }

    public String[] tokens() throws IOException {
        this.tokens = new Vector();
        this.fileRedirect = null;
        this.parseLine();
        if (this.tokens.size() > 0 && SPACE.equals(this.tokens.lastElement())) {
            this.tokens.removeElementAt(this.tokens.size() - 1);
        }
        Object[] args = new String[this.tokens.size()];
        this.tokens.copyInto(args);
        return args;
    }
}

