/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.service;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Closeables;

@SupportedAnnotationTypes(value={"oracle.dbtools.common.service.model.Service"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class ConfigProcessor
extends AbstractProcessor {
    private final SortedSet<String> services = new TreeSet<String>();
    public static final String SERVICE_PATH = "META-INF/oracle.dbtools.common.services";

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.generateServices(this.processingEnv.getFiler());
        } else {
            this.loadExisting(this.processingEnv.getFiler());
            for (Element element : roundEnv.getElementsAnnotatedWith(Service.class)) {
                TypeElement type = (TypeElement)TypeElement.class.cast(element);
                this.services.add(type.getQualifiedName().toString());
            }
        }
        return true;
    }

    private void generateServices(Filer filer) {
        if (this.services.isEmpty()) {
            return;
        }
        Writer w = null;
        FileObject file = null;
        try {
            file = filer.createResource(StandardLocation.CLASS_OUTPUT, "", SERVICE_PATH, new Element[0]);
            w = file.openWriter();
            for (String service : this.services) {
                w.write(service);
                w.write("\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            Closeables.close(w);
        }
    }

    private void loadExisting(Filer filer) {
        FileObject file = null;
        BufferedReader r = null;
        try {
            String line;
            file = filer.getResource(StandardLocation.CLASS_OUTPUT, "", SERVICE_PATH);
            r = new BufferedReader(new InputStreamReader(file.openInputStream(), "UTF-8"));
            while ((line = r.readLine()) != null) {
                this.services.add(line);
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            Closeables.close(r);
        }
    }
}

