/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.service;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import oracle.dbtools.common.CommonMessages;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.service.NotAvailableException;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.service.ServiceLocatorException;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.__Reflections;
import oracle.dbtools.common.service.model.Cardinality;
import oracle.dbtools.common.service.model.Reference;

class Provider {
    private boolean activated;
    private final boolean immediate;
    private boolean available = true;
    private final Object impl;
    private final ServiceProperties properties;
    private static final String ACTIVATE = "activate";
    private static final String DEACTIVATE = "deactivate";

    Provider(Object impl, boolean immediate, ServiceProperties properties) {
        this.impl = impl;
        this.immediate = immediate;
        this.properties = properties;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('{');
        b.append(this.impl.getClass().getName());
        b.append(", ");
        b.append(this.immediate);
        b.append(", ");
        b.append(this.properties);
        b.append('}');
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void activate() {
        Provider provider = this;
        synchronized (provider) {
            if (!this.activated) {
                Field[] dependencies = __Reflections.getFieldsAnnotatedWith(this.impl.getClass(), Reference.class);
                this.inject(this.impl, dependencies);
                try {
                    Method activate = __Reflections.getMethod(this.impl.getClass(), ACTIVATE, ServiceProperties.class);
                    __Reflections.invoke(activate, this.impl, this.properties);
                    this.activated = true;
                }
                catch (NoSuchMethodException e) {
                    this.activated = true;
                }
                catch (IllegalArgumentException e) {
                    throw new ServiceLocatorException(TranslatableMessage.EMPTY_MESSAGE, (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new ServiceLocatorException(TranslatableMessage.EMPTY_MESSAGE, (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() instanceof NotAvailableException) {
                        this.available = false;
                    }
                    throw new ServiceLocatorException(new TranslatableMessage(CommonMessages.class, "Provider.4", "Exception occurred in activate() method", new Object[0]), e.getCause());
                }
            }
        }
    }

    void activateIfImmediate() {
        if (this.immediate) {
            this.activate();
        }
    }

    void deactivate() {
        if (this.activated) {
            try {
                Method deactivate = __Reflections.getMethod(this.impl.getClass(), DEACTIVATE, ServiceProperties.class);
                __Reflections.invoke(deactivate, this.impl, this.properties);
                this.activated = false;
            }
            catch (NoSuchMethodException e) {
                this.activated = true;
            }
            catch (IllegalArgumentException e) {
                throw new ServiceLocatorException(TranslatableMessage.EMPTY_MESSAGE, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ServiceLocatorException(TranslatableMessage.EMPTY_MESSAGE, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ServiceLocatorException(new TranslatableMessage(CommonMessages.class, "Provider.7", "Exception occurred in deactivate() method", new Object[0]), e.getCause());
            }
        }
    }

    void deactivate(Object impl) {
        if (this.impl == impl) {
            this.deactivate();
        }
    }

    <T> T match(Class<T> service, Map<String, String> properties) {
        if (this.available) {
            for (String key : properties.keySet()) {
                String actual = this.properties.get(key);
                if (actual != null) {
                    String expected = properties.get(key);
                    if (actual.equals(expected)) continue;
                    return null;
                }
                return null;
            }
            this.activate();
            if (this.available) {
                return service.cast(this.impl);
            }
        }
        return null;
    }

    private String camelCase(String identifier) {
        return Character.toUpperCase(identifier.charAt(0)) + identifier.substring(1);
    }

    private Class<?> dependencyType(Field dependency) {
        Reference ref = dependency.getAnnotation(Reference.class);
        Class<?> type = ref.type();
        if (Void.class.equals(type)) {
            type = dependency.getType();
        }
        return type;
    }

    private void inject(Object impl, Field dependency) {
        Class<?> type = this.dependencyType(dependency);
        Reference ref = dependency.getAnnotation(Reference.class);
        try {
            if (Cardinality.OneToOne == ref.cardinality()) {
                Object provider = ServiceLocator.acquire(type, ServiceLocator.properties(ref.properties()));
                this.inject(impl, dependency, provider);
            } else {
                Iterable<?> providers = ServiceLocator.acquireAll(type, ServiceLocator.properties(ref.properties()));
                for (Object provider : providers) {
                    this.inject(impl, dependency, provider);
                }
            }
        }
        catch (ServiceLocatorException e) {
            throw new ServiceLocatorException(new TranslatableMessage(CommonMessages.class, "Provider.8", "Error occurred while injecting: {0}", dependency), (Throwable)e);
        }
    }

    private void inject(Object impl, Field dependency, Object value) {
        Reference ref = dependency.getAnnotation(Reference.class);
        Class<?> type = this.dependencyType(dependency);
        String name = dependency.getName();
        Method setter = null;
        try {
            setter = __Reflections.getMethod(impl.getClass(), "set" + this.camelCase(name), type);
            try {
                __Reflections.invoke(setter, impl, value);
            }
            catch (InvocationTargetException e) {
                throw new ServiceLocatorException(new TranslatableMessage(CommonMessages.class, "Provider.10", "Error during invocation of setter for {0}", dependency), e.getCause());
            }
            catch (Exception e) {
                throw new ServiceLocatorException(new TranslatableMessage(CommonMessages.class, "Provider.11", "Failed to inject: {0}", dependency), (Throwable)e);
            }
        }
        catch (NoSuchMethodException e) {
            dependency.setAccessible(true);
            if (Cardinality.OneToOne == ref.cardinality()) {
                try {
                    dependency.set(impl, value);
                }
                catch (Exception ex) {
                    throw new ServiceLocatorException(new TranslatableMessage(CommonMessages.class, "Provider.12", "Failed to inject: {0}", dependency), ex.getCause());
                }
            }
            Object maybeCollection = null;
            try {
                maybeCollection = dependency.get(impl);
            }
            catch (Exception ex) {
                throw new ServiceLocatorException(new TranslatableMessage(CommonMessages.class, "Provider.13", "Failed to inject: {0}", dependency), ex.getCause());
            }
            if (maybeCollection instanceof Collection) {
                Collection collection = (Collection)maybeCollection;
                collection.add(value);
            }
            throw new ServiceLocatorException(new TranslatableMessage(CommonMessages.class, "Provider.14", "Expected field: {0}\\ to be an instance of a Collection sub-type", dependency));
        }
    }

    private void inject(Object impl, Field[] dependencies) {
        for (Field dependency : dependencies) {
            this.inject(impl, dependency);
        }
    }
}

