/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;

public abstract class Arrays {
    public static <T> Set<T> asSet(T ... elements) {
        TreeSet<T> s = new TreeSet<T>();
        s.addAll(java.util.Arrays.asList(elements));
        return s;
    }

    public static <T> boolean contains(T e, T ... ts) {
        boolean contains = false;
        for (T t : ts) {
            if (!e.equals(t)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public static <T> T[] flatten(T[] ... arrays) {
        ArrayList<T> flattened = new ArrayList<T>();
        for (T[] array : arrays) {
            if (null == array) continue;
            flattened.addAll(java.util.Arrays.asList(array));
        }
        for (T[] array : arrays) {
            if (null == array) continue;
            return flattened.toArray(array);
        }
        return null;
    }

    public static <T> T[] flatten(T[] array, T ... objects) {
        ArrayList<T> flattened = new ArrayList<T>(java.util.Arrays.asList(array));
        for (T object : objects) {
            if (null == object) continue;
            flattened.add(object);
        }
        return flattened.toArray(array);
    }

    public static <T> T[] flatten(T[] first, T[] second, T ... rest) {
        return Arrays.flatten(first, Arrays.flatten(second, rest));
    }

    public static <T> T[] flatten(T[] first, T[] second, T[] third, T ... rest) {
        return Arrays.flatten(first, Arrays.flatten(second, Arrays.flatten(third, rest)));
    }

    public static <T> T[] flatten(T[] first, T[] second, T[] third, T[] fourth, T ... rest) {
        return Arrays.flatten(first, Arrays.flatten(second, Arrays.flatten(third, Arrays.flatten(fourth, rest))));
    }
}

