/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.dbtools.common.CommonMessages;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.UnrecoverableException;
import oracle.dbtools.common.util.ResourceTracker;

public abstract class Closeables {
    private static final Closer CLOSEABLE = new BaseCloser<Closeable>(Closeable.class){

        @Override
        protected void closeType(Closeable closeable) throws IOException {
            closeable.close();
        }
    };
    private static final Closer COLLECTIONS_ITERATOR = new BaseCloser<Iterator>(Iterator.class){

        @Override
        protected boolean canClose(Object instance) {
            boolean isIterator = super.canClose(instance);
            return isIterator && instance.getClass().getName().startsWith("java.util.");
        }

        @Override
        protected void closeType(Iterator closeable) throws IOException {
        }
    };
    private static final Closer EMPTY_COLLECTIONS = new Closer(){

        @Override
        public boolean close(Object instance) throws IOException {
            return instance == Collections.EMPTY_LIST || instance == Collections.EMPTY_SET || instance == Collections.EMPTY_MAP;
        }
    };
    private static boolean FAIL_ON_NOT_CLOSED = false;
    private static final Set<Closer> THE_CLOSERS = new LinkedHashSet<Closer>(Arrays.asList(CLOSEABLE, COLLECTIONS_ITERATOR, EMPTY_COLLECTIONS));

    public static InputStream alsoClose(InputStream inputStream, final Object ... dependents) {
        return new FilterInputStream(inputStream){

            @Override
            public void close() throws IOException {
                Closeables.close(dependents);
            }
        };
    }

    public static <T> void close(T closeable) {
        if (closeable != null) {
            if (closeable instanceof Flushable) {
                try {
                    ((Flushable)closeable).flush();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            boolean closed = false;
            for (Closer closer : THE_CLOSERS) {
                try {
                    closed = closer.close(closeable);
                    if (!closed) continue;
                    break;
                }
                catch (IOException e) {
                }
            }
            if (!closed && FAIL_ON_NOT_CLOSED) {
                throw UnrecoverableException.unrecoverable(new TranslatableMessage(CommonMessages.class, "Closeables.0", "Don't know how to close instances of type: ", closeable.getClass().getName()));
            }
        }
        ResourceTracker.release(closeable);
    }

    public static <T> void close(T ... closeables) {
        for (T closeable : closeables) {
            Closeables.close(closeable);
        }
    }

    public static InputStream ignoreClose(InputStream doNotClose) {
        return new IgnoreCloseStream(doNotClose);
    }

    public static void register(Closer closer) {
        THE_CLOSERS.add(closer);
    }

    private static final class IgnoreCloseStream
    extends FilterInputStream {
        private IgnoreCloseStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() throws IOException {
        }

        public String toString() {
            return this.in.toString();
        }
    }

    public static interface Closer {
        public boolean close(Object var1) throws IOException;
    }

    public static abstract class BaseCloser<T>
    implements Closer {
        private final Class<T> type;

        protected BaseCloser(Class<T> expectedType) {
            this.type = expectedType;
        }

        @Override
        public boolean close(Object instance) throws IOException {
            if (instance != null && this.canClose(instance)) {
                this.closeType(this.type.cast(instance));
                return true;
            }
            return false;
        }

        public String toString() {
            return "BaseCloser [type=" + this.type + "]";
        }

        protected boolean canClose(Object instance) {
            return this.type.isAssignableFrom(instance.getClass());
        }

        protected abstract void closeType(T var1) throws IOException;
    }
}

