/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.StringTokenizer;
import oracle.dbtools.common.util.Identifiers;
import oracle.dbtools.common.util.URIs;
import oracle.dbtools.common.util.URLEncoding;

public abstract class Files {
    private static FileSystem fileSystem = new OSFileSystem();

    private Files() {
    }

    public static void createParentFolder(File file) {
        File parent = file.getParentFile();
        Files.mkdirs(parent);
    }

    public static File createTempFile(String prefix, String suffix, File folder) throws IOException {
        return fileSystem.createTempFile(prefix, suffix, folder);
    }

    public static File createTempFolder(File parent, String prefix) {
        StringBuilder name = new StringBuilder(prefix);
        name.append(Identifiers.randomIdentifier());
        File folder = Files.file(parent, name.toString());
        Files.mkdirs(folder);
        return folder;
    }

    public static boolean delete(File path) {
        boolean succeeded = true;
        if (path != null && path.exists()) {
            if (path.isDirectory()) {
                File child;
                File[] children;
                File[] arr$ = children = path.listFiles();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (succeeded = Files.delete(child = arr$[i$])); ++i$) {
                }
                if (succeeded) {
                    path.delete();
                }
            } else {
                succeeded = path.delete();
            }
        }
        return succeeded;
    }

    public static File file(File parent, String path) {
        path = Files.replaceVariables(path);
        File tmp = new File(parent, path);
        return Files.file(tmp.getPath());
    }

    public static File file(String path) {
        if (path == null) {
            throw new NullPointerException("Path is required");
        }
        while ((path.endsWith("/") || path.endsWith("\\")) && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        path = Files.replaceVariables(path);
        return fileSystem.file(path);
    }

    public static File file(String parent, String path) {
        parent = Files.replaceVariables(parent);
        path = Files.replaceVariables(path);
        return Files.file(fileSystem.file(parent), path);
    }

    public static File file(URI uri) {
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("URI is not absolute");
        }
        if (uri.isOpaque()) {
            throw new IllegalArgumentException("URI is not hierarchical");
        }
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase("file")) {
            throw new IllegalArgumentException("URI scheme is not \"file\"");
        }
        if (uri.getAuthority() != null) {
            throw new IllegalArgumentException("URI has an authority component");
        }
        if (uri.getFragment() != null) {
            throw new IllegalArgumentException("URI has a fragment component");
        }
        if (uri.getQuery() != null) {
            throw new IllegalArgumentException("URI has a query component");
        }
        String p = URIs.path(uri);
        if (p.equals("")) {
            throw new IllegalArgumentException("URI path component is empty");
        }
        return Files.file(p);
    }

    public static int indexOfPath(File f, String path) {
        path = path.replace("/", File.separator);
        String absPath = f.getAbsolutePath();
        return absPath.indexOf(path);
    }

    public static InputStream inputStream(File file) throws IOException {
        return fileSystem.inputStream(file);
    }

    public static void mkdirs(File file) {
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static OutputStream outputStream(File file) throws IOException {
        if (!file.exists()) {
            Files.mkdirs(file.getParentFile());
            file.createNewFile();
        }
        return fileSystem.outputStream(file);
    }

    public static Reader reader(File file) throws IOException {
        return fileSystem.reader(file);
    }

    public static Writer writer(File file) throws IOException {
        return Files.writer(file, false);
    }

    public static Writer writer(File file, boolean append) throws IOException {
        return fileSystem.writer(file, append);
    }

    static void setFileSystem(FileSystem fileSystem) {
        if (fileSystem == null) {
            fileSystem = new OSFileSystem();
        }
        Files.fileSystem = fileSystem;
    }

    static String uriSafe(String path) {
        boolean leadingSlash = path.startsWith("/");
        boolean trailingSlash = path.endsWith("/");
        StringBuilder b = new StringBuilder();
        if (leadingSlash) {
            b.append("/");
        }
        StringTokenizer st = new StringTokenizer(path, "/");
        while (st.hasMoreTokens()) {
            String segment = st.nextToken();
            b.append(URLEncoding.encode(segment).replace("+", "%20"));
            if (!st.hasMoreTokens()) continue;
            b.append('/');
        }
        if (trailingSlash) {
            b.append("/");
        }
        return b.toString();
    }

    private static String replaceVariables(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        int start = 0;
        int end = text.indexOf("${");
        while (end != -1) {
            b.append(text.substring(start, end));
            start = end;
            if ((end = text.indexOf(125, end + 2)) == -1) continue;
            String variable = text.substring(start + 2, end);
            String value = System.getProperty(variable);
            if (value == null) {
                b.append(text.substring(start, end + 1));
            } else {
                b.append(value);
            }
            start = end + 1;
            end = text.indexOf("${", start);
        }
        b.append(text.substring(start));
        return b.toString();
    }

    private static class OSFileSystem
    implements FileSystem {
        private OSFileSystem() {
        }

        @Override
        public File createTempFile(String prefix, String suffix, File folder) throws IOException {
            return File.createTempFile(prefix, suffix, folder);
        }

        @Override
        public File file(String path) {
            return new File(path);
        }

        @Override
        public InputStream inputStream(File file) throws IOException {
            return new FileInputStream(file);
        }

        @Override
        public OutputStream outputStream(File file) throws IOException {
            return new FileOutputStream(file);
        }

        @Override
        public Reader reader(File file) throws IOException {
            return new FileReader(file);
        }

        @Override
        public Writer writer(File file, boolean append) throws IOException {
            return new FileWriter(file, append);
        }
    }

    public static interface FileSystem {
        public File createTempFile(String var1, String var2, File var3) throws IOException;

        public File file(String var1);

        public InputStream inputStream(File var1) throws IOException;

        public OutputStream outputStream(File var1) throws IOException;

        public Reader reader(File var1) throws IOException;

        public Writer writer(File var1, boolean var2) throws IOException;
    }
}

