/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.common.util.AbstractIterator;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.RewindableIterator;
import oracle.dbtools.common.util.Selector;
import oracle.dbtools.common.util.Transform;

public final class Iterators {
    public static final AsString AS_STRING = new AsString();
    private static final Iterator EMPTY = Iterators.iterator(new Object[0]);
    private static final RewindableIterator EMPTY_REWINDABLE = new Rewindable(EMPTY){

        @Override
        public Iterator rewind() {
            return EMPTY;
        }
    };

    private Iterators() {
    }

    public static <T> void add(Collection<T> c, Iterator<T> items) {
        Iterators.add(c, items, false);
    }

    public static <T> void add(Collection<T> c, Iterator<? extends T> items, boolean ignoreNulls) {
        if (c != null && items != null) {
            while (items.hasNext()) {
                T item = items.next();
                if (Iterators.ignore(item, ignoreNulls)) continue;
                c.add(item);
            }
        }
    }

    public static <T> Iterator<T> alsoClose(Iterator<T> items, Object ... backingResources) {
        return new AlsoCloseIterator<T>(items, backingResources);
    }

    public static <T> int compare(Iterator<? extends T> i1, Iterator<? extends T> i2) {
        int c = 0;
        while (i1.hasNext()) {
            T v1 = i1.next();
            if (!i2.hasNext()) {
                c = 1;
                break;
            }
            T v2 = i2.next();
            c = ((Comparable)v1).compareTo(v2);
            if (c == 0) continue;
            break;
        }
        if (i2.hasNext()) {
            c = -1;
        }
        return c;
    }

    public static final <T> Iterator<T> empty() {
        return EMPTY;
    }

    public static final <T> Enumeration<T> enumeration(final Iterator<T> items) {
        return new Enumeration<T>(){

            @Override
            public boolean hasMoreElements() {
                return items.hasNext();
            }

            @Override
            public T nextElement() {
                return items.next();
            }

            public String toString() {
                return items.toString();
            }
        };
    }

    public static <T> boolean equals(Iterator<? extends T> i1, Iterator<? extends T> i2) {
        while (i1.hasNext()) {
            T v1 = i1.next();
            if (!i2.hasNext()) {
                return false;
            }
            T v2 = i2.next();
            boolean equal = v1 == v2 || v1.equals(v2);
            if (equal) continue;
            return false;
        }
        return !i2.hasNext();
    }

    public static final <T> Iterator<T> iterator(final Enumeration<T> items) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return items.hasMoreElements();
            }

            @Override
            public T next() {
                return items.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return items.toString();
            }
        };
    }

    public static <T> Iterator<T> iterator(final Iterable<? extends T> src) {
        if (src == null) {
            return null;
        }
        final Iterator<? extends T> iter = src.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public T next() {
                return iter.next();
            }

            @Override
            public void remove() {
                iter.remove();
            }

            public String toString() {
                return src.toString();
            }
        };
    }

    public static final <T> Iterator<T> iterator(T ... items) {
        return new ArrayIterator((Object[])items);
    }

    public static String join(Iterator<?> iter, String separator) {
        StringBuilder b = new StringBuilder();
        while (iter.hasNext()) {
            Object i = iter.next();
            b.append(i);
            if (!iter.hasNext()) continue;
            b.append(separator);
        }
        return b.toString();
    }

    public static <T> T max(Iterator<? extends T> i) {
        T candidate = i.next();
        while (i.hasNext()) {
            T next = i.next();
            if (((Comparable)next).compareTo(candidate) <= 0) continue;
            candidate = next;
        }
        return candidate;
    }

    public static final <T> T next(Iterator<? extends T> items) {
        T next = Iterators.nextOrNull(items);
        if (next == null) {
            throw new IllegalStateException("no more items");
        }
        return next;
    }

    public static final <T> T nextOrNull(Iterator<? extends T> items) {
        if (items.hasNext()) {
            return items.next();
        }
        return null;
    }

    public static final <T> RewindableIterator<T> rewindable(Iterator<T> items) {
        if (items == null) {
            return null;
        }
        if (!items.hasNext()) {
            return EMPTY_REWINDABLE;
        }
        return new Rewindable(items);
    }

    public static final <T> Iterator<T> select(Iterator<? extends T> items, Selector<? extends T> condition) {
        return new SelectorIterator<T>(items, condition);
    }

    public static final <T> Iterator<T> sequence(Iterator<Iterator<T>> items) {
        return new SequencedIterator<T>(items);
    }

    public static <T> Iterator<T> subset(Iterator<? extends T> items, int count) {
        return new SubSetIterator<T>(items, count);
    }

    public static final <X, Y> Iterator<Y> transform(Iterator<X> items, Transform<X, Y> transform) {
        if (transform == null) {
            return items;
        }
        return new TransformIterator<X, Y>(items, transform);
    }

    private static <T> boolean ignore(T item, boolean ignoreNulls) {
        return ignoreNulls && item == null;
    }

    private static class TransformIterator<X, Y>
    implements Iterator<Y>,
    Closeable {
        private final Iterator<X> items;
        private final Transform<X, Y> transform;

        TransformIterator(Iterator<X> items, Transform<X, Y> transform) {
            this.items = items;
            this.transform = transform;
        }

        @Override
        public void close() throws IOException {
            Closeables.close(this.items);
        }

        @Override
        public boolean hasNext() {
            return this.items.hasNext();
        }

        @Override
        public Y next() {
            return this.transform.apply(this.items.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.items.toString();
        }
    }

    private static class SubSetIterator<T>
    implements Iterator<T> {
        private final int count;
        private final Iterator<? extends T> iter;
        private int pos = 0;

        public SubSetIterator(Iterator<? extends T> iter, int count) {
            this.iter = iter;
            this.count = count;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext() && this.pos < this.count;
        }

        @Override
        public T next() {
            T next = null;
            if (this.pos < this.count) {
                next = this.iter.next();
                ++this.pos;
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SequencedIterator<T>
    extends AbstractIterator<T>
    implements Closeable {
        private Iterator<T> current = null;
        private final Iterator<Iterator<T>> items;

        public SequencedIterator(Iterator<Iterator<T>> items) {
            this.items = items;
        }

        @Override
        public void close() throws IOException {
            while (this.items.hasNext()) {
                Closeables.close(this.items.next());
            }
        }

        @Override
        protected final T advance() {
            T item = null;
            while (item == null) {
                while (this.current == null && this.items.hasNext()) {
                    Iterator<T> next = this.items.next();
                    if (next != null && next.hasNext()) {
                        this.current = next;
                        continue;
                    }
                    Closeables.close(next);
                }
                if (this.current == null) break;
                if (this.current.hasNext()) {
                    item = this.current.next();
                    continue;
                }
                this.current = null;
            }
            return item;
        }
    }

    private static class SelectorIterator<T>
    extends AbstractIterator<T>
    implements Iterator<T> {
        private final Selector<? extends T> condition;
        private final Iterator<? extends T> items;

        public SelectorIterator(Iterator<? extends T> items, Selector<? extends T> condition) {
            this.items = items;
            this.condition = condition;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SelectorIterator [");
            if (this.items != null) {
                builder.append("items=");
                builder.append(this.items);
                builder.append(", ");
            }
            if (this.condition != null) {
                builder.append("condition=");
                builder.append(this.condition);
            }
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected T advance() {
            Object item = null;
            boolean selected = false;
            while (!selected && this.items.hasNext()) {
                item = this.items.next();
                selected = (Boolean)this.condition.apply(item);
            }
            return (T)(selected ? item : null);
        }
    }

    private static final class AsString
    implements Transform<Object, String> {
        private AsString() {
        }

        @Override
        public String apply(Object x) {
            if (x == null) {
                return null;
            }
            return x.toString();
        }
    }

    private static class Rewindable<T>
    implements RewindableIterator<T>,
    Closeable {
        private final Iterator<T> target;
        private final List<T> values = new ArrayList<T>();
        private boolean rewound = false;

        private Rewindable(Iterator<T> target) {
            this.target = target;
        }

        @Override
        public boolean hasNext() {
            return this.target.hasNext();
        }

        @Override
        public T next() {
            T value = this.target.next();
            this.values.add(value);
            return value;
        }

        @Override
        public void remove() {
            this.target.remove();
        }

        @Override
        public void close() throws IOException {
            Closeables.close(this.target);
        }

        @Override
        public Iterator<T> rewind() {
            if (this.rewound) {
                throw new IllegalStateException("Already rewound");
            }
            Iterator items = Iterators.sequence(Iterators.iterator(this.values.iterator(), this.target));
            this.rewound = true;
            return items;
        }
    }

    private static final class ArrayIterator<T>
    implements Iterator<T> {
        private final T[] items;
        private int pos = 0;

        private ArrayIterator(T ... items) {
            this.items = items;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.items.length;
        }

        @Override
        public T next() {
            T item = this.items[this.pos];
            ++this.pos;
            return item;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return Arrays.toString(this.items);
        }
    }

    private static final class AlsoCloseIterator<T>
    implements Iterator<T>,
    Closeable {
        private final Object[] backingResources;
        private final Iterator<T> items;

        public AlsoCloseIterator(Iterator<T> items, Object[] backingResources) {
            this.items = items;
            this.backingResources = backingResources;
        }

        @Override
        public void close() throws IOException {
            Closeables.close(this.backingResources);
        }

        @Override
        public boolean hasNext() {
            return this.items.hasNext();
        }

        @Override
        public T next() {
            return this.items.next();
        }

        @Override
        public void remove() {
            this.items.remove();
        }

        public String toString() {
            return this.items.toString();
        }
    }
}

