/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class Log {
    private final Logger target;
    public static final Level FINE = Level.FINE;
    public static final Level INFO = Level.INFO;
    public static final Level SEVERE = Level.SEVERE;
    public static final Level WARNING = Level.WARNING;
    private static final int CALLER_STACK_DEPTH = 3;
    private static final PrintStream CONSOLE = System.out;

    private Log(Logger target) {
        this.target = target;
    }

    public void console(String msg) {
        CONSOLE.append(msg);
        CONSOLE.append('\n');
    }

    public void fine(String msg) {
        this.log(FINE, msg);
    }

    public void fine(Throwable t) {
        this.log(FINE, t);
    }

    public void info(String msg) {
        this.log(INFO, msg);
    }

    public void info(Throwable t) {
        this.log(INFO, t);
    }

    public boolean isLoggable(Level level) {
        return this.target.isLoggable(level);
    }

    public void severe(String msg) {
        this.log(SEVERE, msg);
    }

    public void severe(Throwable t) {
        this.log(SEVERE, t);
    }

    public void warning(String msg) {
        this.log(WARNING, msg);
    }

    public void warning(Throwable t) {
        this.log(WARNING, t);
    }

    private void inferCaller(LogRecord lr) {
        Throwable t = new Throwable();
        StackTraceElement methodCaller = t.getStackTrace()[3];
        lr.setSourceClassName(methodCaller.getClassName());
        lr.setSourceMethodName(methodCaller.getMethodName());
    }

    private void log(Level level, String msg) {
        if (this.isLoggable(level)) {
            LogRecord lr = new LogRecord(level, msg);
            this.inferCaller(lr);
            this.target.log(lr);
        }
    }

    private void log(Level level, Throwable t) {
        if (this.isLoggable(level)) {
            LogRecord lr = new LogRecord(level, t.getMessage());
            lr.setThrown(t);
            this.inferCaller(lr);
            this.target.log(lr);
        }
    }

    public static Log get(Class<?> clazz) {
        Logger target = Logger.getLogger(clazz.getName());
        return new Log(target);
    }
}

