/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Selector;
import oracle.dbtools.common.util.Transform;

public final class Maps {
    private Maps() {
    }

    public static final <K, V> boolean contains(Map<K, V> items, Map<K, V> subset) {
        for (K k : subset.keySet()) {
            V expected = items.get(k);
            V actual = subset.get(k);
            if (expected != null && expected.equals(actual)) continue;
            return false;
        }
        return true;
    }

    public static String join(Map<?, ?> items, String delimiter, String separator) {
        StringBuilder b = new StringBuilder();
        Iterator<?> iter = items.keySet().iterator();
        while (iter.hasNext()) {
            Object k = iter.next();
            Object v = items.get(k);
            b.append(k);
            b.append(delimiter);
            b.append(v);
            if (!iter.hasNext()) continue;
            b.append(separator);
        }
        return b.toString();
    }

    public static final <K, V> Iterable<V> select(Map<K, V> items, final Selector<K> condition) {
        return Iterables.transform(Iterables.select(items.entrySet(), new Selector<Map.Entry<K, V>>(){

            @Override
            public Boolean apply(Map.Entry<K, V> x) {
                return (Boolean)condition.apply(x.getKey());
            }
        }), new Transform<Map.Entry<K, V>, V>(){

            @Override
            public V apply(Map.Entry<K, V> x) {
                return x.getValue();
            }
        });
    }

    public static final <K, V> V selectFirst(Map<K, V> items, Selector<K> condition) {
        return Iterators.nextOrNull(Maps.select(items, condition).iterator());
    }

    public static Map<String, String> toMap(String ... propertyPairs) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        for (int i = 0; i < propertyPairs.length; ++i) {
            String key = propertyPairs[i];
            String value = propertyPairs[++i];
            properties.put(key, value);
        }
        return properties;
    }
}

