/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import oracle.dbtools.common.util.Timestamps;

public final class PrimitiveTypes {
    private static final List<Class<?>> PRIMITIVE_TYPES = Arrays.asList(String.class, Long.class, Integer.class, Boolean.class, Double.class, Timestamp.class, BigDecimal.class, BigInteger.class);
    private static final Pattern NUMERIC = Pattern.compile("^-?[0-9]+(\\.?[0-9]*)?([e|E]?[-|+]?[0-9]*)?$");

    private PrimitiveTypes() {
    }

    public static Class<?> classOf(String primitiveTypeName) {
        if (primitiveTypeName == null) {
            throw new NullPointerException("primitiveType must not be null");
        }
        Class primitiveType = null;
        if (primitiveTypeName.startsWith("java.lang.")) {
            primitiveTypeName = primitiveTypeName.substring("java.lang.".length());
        }
        if ("String".equals(primitiveTypeName)) {
            primitiveType = String.class;
        } else if ("Integer".equals(primitiveTypeName) || "int".equals(primitiveTypeName)) {
            primitiveType = Integer.class;
        } else if ("Long".equals(primitiveTypeName) || "long".equals(primitiveTypeName)) {
            primitiveType = Long.class;
        } else if ("Boolean".equals(primitiveTypeName) || "boolean".equals(primitiveTypeName)) {
            primitiveType = Boolean.class;
        } else if ("Double".equals(primitiveTypeName) || "double".equals(primitiveTypeName)) {
            primitiveType = Double.class;
        } else {
            throw new IllegalArgumentException(primitiveTypeName + " is not a supported primitive datatype");
        }
        return primitiveType;
    }

    public static boolean isNumeric(CharSequence text) {
        return NUMERIC.matcher(text).matches();
    }

    public static String string(Boolean value) {
        if (value == null) {
            return null;
        }
        return value != false ? "true" : "false";
    }

    public static String string(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> T valueOf(Object data, Class<T> primitiveType) {
        Object value = null;
        if (data instanceof CharSequence) {
            value = PrimitiveTypes.valueOf(data.toString(), primitiveType);
            return primitiveType.cast(value);
        } else if (data instanceof Number) {
            Number n = (Number)data;
            if (Integer.class == primitiveType) {
                value = n.intValue();
                return primitiveType.cast(value);
            } else if (Long.class == primitiveType) {
                value = n.longValue();
                return primitiveType.cast(value);
            } else if (Double.class == primitiveType) {
                value = n.doubleValue();
                return primitiveType.cast(value);
            } else if (Short.class == primitiveType) {
                value = n.shortValue();
                return primitiveType.cast(value);
            } else if (Byte.class == primitiveType) {
                value = n.byteValue();
                return primitiveType.cast(value);
            } else {
                if (Float.class != primitiveType) throw new IllegalArgumentException(primitiveType + " is not a supported primitive datatype");
                value = Float.valueOf(n.floatValue());
            }
            return primitiveType.cast(value);
        } else {
            if (!(data instanceof Boolean)) throw new IllegalArgumentException(primitiveType + " is not a supported primitive datatype");
            if (Boolean.class != primitiveType) throw new IllegalArgumentException(primitiveType + " is not a supported primitive datatype");
            value = data;
        }
        return primitiveType.cast(value);
    }

    public static <T> T valueOf(String data, Class<T> primitiveType) {
        if (data == null) {
            return null;
        }
        Object value = null;
        if (String.class == primitiveType) {
            value = data;
        } else if (Integer.class == primitiveType) {
            value = Integer.valueOf(data);
        } else if (Long.class == primitiveType) {
            value = Long.valueOf(data);
        } else if (Boolean.class == primitiveType) {
            value = Boolean.valueOf(data);
        } else if (Double.class == primitiveType) {
            value = Double.valueOf(data);
        } else if (Timestamp.class == primitiveType) {
            value = new Timestamp(Timestamps.valueOf(data));
        } else {
            throw new IllegalArgumentException(primitiveType + " is not a supported primitive datatype");
        }
        return primitiveType.cast(value);
    }

    public static boolean isPrimitive(Object instance) {
        if (instance == null) {
            return false;
        }
        Class<?> type = instance.getClass();
        return PRIMITIVE_TYPES.contains(type);
    }
}

