/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import oracle.dbtools.common.UnrecoverableException;
import oracle.dbtools.common.util.AbstractIterator;
import oracle.dbtools.common.util.ChunkedInputStream;

public class ReaderStream
extends ChunkedInputStream {
    private static final byte[] EMPTY = new byte[0];

    private ReaderStream(Reader r, Charset charset) {
        super(new CharChunker(r, charset));
    }

    public static InputStream stream(Reader r, Charset charset) {
        return new ReaderStream(r, charset);
    }

    private static final class CharChunker
    extends AbstractIterator<byte[]>
    implements ChunkedInputStream.Chunker {
        private final Charset charset;
        private final Reader r;

        private CharChunker(Reader r, Charset charset) {
            this.r = r;
            this.charset = charset;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        protected byte[] advance() {
            try {
                char[] chars = new char[2048];
                int read = this.r.read(chars);
                if (read == -1) {
                    return EMPTY;
                }
                String text = new String(chars, 0, read);
                return text.getBytes(this.charset);
            }
            catch (IOException e) {
                throw UnrecoverableException.unrecoverable(e);
            }
        }
    }
}

