/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import oracle.dbtools.common.UnrecoverableException;
import oracle.dbtools.common.util.Selector;

public abstract class Reflections {
    public static Iterable<Annotation> annotations(Class<?> clazz) {
        return Arrays.asList(clazz.getAnnotations());
    }

    public static Iterable<Annotation> annotations(Field f) {
        return Arrays.asList(f.getAnnotations());
    }

    public static Iterable<Method> declaredMethods(Class<?> clazz) {
        return Arrays.asList(clazz.getDeclaredMethods());
    }

    public static Iterable<Field> fields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> curr = clazz; curr != null && !curr.equals(Object.class); curr = curr.getSuperclass()) {
            Field[] current;
            for (Field field : current = curr.getDeclaredFields()) {
                fields.add(field);
            }
        }
        return fields;
    }

    public static Selector<Field> hasAnnotations() {
        return new Selector<Field>(){

            @Override
            public Boolean apply(Field x) {
                return x.getAnnotations().length > 0;
            }
        };
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw UnrecoverableException.unrecoverable(e);
        }
    }

    public static Object value(Object instance, Field f) {
        if (instance != null) {
            f.setAccessible(true);
            try {
                return f.get(instance);
            }
            catch (Exception e) {
                throw UnrecoverableException.unrecoverable(e);
            }
        }
        return null;
    }
}

