/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.util.Iterator;
import oracle.dbtools.common.util.AssociativeArray;
import oracle.dbtools.common.util.AssociativeArrays;
import oracle.dbtools.common.util.Selector;

public class SensitiveAssociativeArray<K, V>
extends AssociativeArrays.Base<K, V> {
    private final Selector<K> isSensitive;
    private final V substitute;
    private final AssociativeArray<K, V> target;

    SensitiveAssociativeArray(AssociativeArray<K, V> target, V substitute, Selector<K> isSensitive) {
        this.target = target;
        this.substitute = substitute;
        this.isSensitive = isSensitive;
    }

    @Override
    public V get(Object key) {
        V value = this.target.get(key);
        if (value != null && this.isSensitive(key)) {
            value = this.substitute;
        }
        return value;
    }

    @Override
    public Iterator<K> iterator() {
        return this.target.iterator();
    }

    @Override
    public String toString() {
        Iterator<K> keys = this.iterator();
        if (!keys.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (keys.hasNext()) {
            K key = keys.next();
            V value = this.get(key);
            sb.append((Object)(key == this ? "(this)" : key));
            sb.append('=');
            sb.append((Object)(value == this ? "(this)" : value));
            if (!keys.hasNext()) continue;
            sb.append(", ");
        }
        return sb.append('}').toString();
    }

    private boolean isSensitive(Object key) {
        return (Boolean)this.isSensitive.apply(key);
    }
}

