/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import oracle.dbtools.common.util.Closeables;

public class StreamCopy {
    private static final int BUFFER_SIZE = 65536;
    private static final EmptyStream EMPTY_STREAM = new EmptyStream();

    public static long drain(InputStream is, OutputStream os) throws IOException {
        if (is != null && os != null) {
            ReadableByteChannel source = Channels.newChannel(is);
            WritableByteChannel destination = Channels.newChannel(os);
            return StreamCopy.drain(source, destination);
        }
        return -1L;
    }

    public static long drain(Readable source, Appendable destination) throws IOException {
        long length = 0L;
        CharBuffer buffer = CharBuffer.allocate(65536);
        while (source.read(buffer) != -1) {
            buffer.flip();
            length += (long)buffer.limit();
            destination.append(buffer);
            buffer.compact();
        }
        return length;
    }

    public static long drain(ReadableByteChannel source, WritableByteChannel destination) throws IOException {
        long length = 0L;
        ByteBuffer buffer = ByteBuffer.allocate(65536);
        while (source.read(buffer) != -1) {
            buffer.flip();
            length += (long)buffer.limit();
            destination.write(buffer);
            buffer.compact();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            destination.write(buffer);
        }
        return length;
    }

    public static InputStream emptyStream() {
        return EMPTY_STREAM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String string(InputStream is) throws IOException {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            int read = 0;
            while (-1 != (read = is.read())) {
                os.write(read);
            }
            os.close();
            String string = new String(os.toByteArray(), "UTF-8");
            return string;
        }
        finally {
            Closeables.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String string(Reader r) throws IOException {
        StringBuilder b = new StringBuilder();
        try {
            char[] chars = new char[11];
            int count = -1;
            while (-1 != (count = r.read(chars, 0, chars.length))) {
                b.append(chars, 0, count);
            }
        }
        finally {
            Closeables.close(r);
        }
        return b.toString();
    }

    public static InputStream toInputStream(String string) throws IOException {
        if (null == string) {
            return EMPTY_STREAM;
        }
        return new ByteArrayInputStream(string.getBytes("UTF-8"));
    }

    private static final class EmptyStream
    extends InputStream {
        private EmptyStream() {
        }

        @Override
        public int read() throws IOException {
            return -1;
        }
    }
}

