/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

public abstract class Throwables {
    private Throwables() {
    }

    public static String stackTrace(Throwable t) {
        StringBuilder s = new StringBuilder();
        if (t != null) {
            StackTraceElement[] trace;
            for (StackTraceElement element : trace = t.getStackTrace()) {
                s.append("\tat " + element);
                s.append('\n');
            }
            Throwable cause = t.getCause();
            if (cause != null) {
                Throwables.stackTraceAsCause(s, cause, trace);
            }
        }
        return s.toString();
    }

    private static void stackTraceAsCause(StringBuilder s, Throwable t, StackTraceElement[] causedTrace) {
        Throwable cause;
        StackTraceElement[] trace = t.getStackTrace();
        int m = trace.length - 1;
        for (int n = causedTrace.length - 1; m >= 0 && n >= 0 && trace[m].equals(causedTrace[n]); --m, --n) {
        }
        int framesInCommon = trace.length - 1 - m;
        s.append("Caused by: \n" + t);
        for (int i = 0; i <= m; ++i) {
            s.append("\tat\n " + trace[i]);
        }
        if (framesInCommon != 0) {
            s.append("\t... " + framesInCommon + " more\n");
        }
        if ((cause = t.getCause()) != null) {
            Throwables.stackTraceAsCause(s, cause, trace);
        }
    }
}

