/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Pattern;

public abstract class Timestamps {
    private static final SimpleDateFormat RFC_3339_MUNGED = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final Pattern TIMESTAMP = Pattern.compile("^\\d{4}-[01]\\d-[0123]\\dT[012]\\d:[0-5]\\d:[0-5]\\d(.\\d{1,3})?(Z|([-+][012]\\d:[0-5]\\d))$");
    private static final TimeZone UTC = TimeZone.getTimeZone("Z");
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;

    public static boolean isTimestamp(CharSequence text) {
        return TIMESTAMP.matcher(text).matches();
    }

    public static String duration(long since) {
        long temp;
        long working = since;
        String ret = "";
        if (working > 86400000L) {
            temp = Double.valueOf(Math.floor(working / 86400000L)).intValue();
            ret = ret + temp + " Day" + (temp > 1L ? "s " : " ");
            working -= temp * 86400000L;
        }
        if (working > 3600000L) {
            temp = Double.valueOf(Math.floor(working / 3600000L)).intValue();
            ret = ret + temp + " Hour" + (temp > 1L ? "s " : " ");
            working -= temp * 3600000L;
        }
        if (working > 60000L) {
            temp = Double.valueOf(Math.floor(working / 60000L)).intValue();
            ret = ret + temp + " Minute" + (temp > 1L ? "s " : " ");
            working -= temp * 60000L;
        }
        if (working > 1000L) {
            temp = Double.valueOf(Math.floor(working / 1000L)).intValue();
            ret = ret + temp + " Second" + (temp > 1L ? "s " : " ");
            working -= temp * 1000L;
        }
        return ret;
    }

    public static String toString(long date) {
        Calendar c = Calendar.getInstance(UTC);
        c.setTimeInMillis(date);
        StringBuilder b = new StringBuilder();
        b.append(MessageFormat.format("{0,number,0000}-{1,number,00}-{2,number,00}T{3,number,00}:{4,number,00}:{5,number,00}", c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13)));
        int millis = c.get(14);
        if (millis > 0) {
            b.append(Double.toString((double)millis / 1000.0).substring(1));
        }
        b.append('Z');
        return b.toString();
    }

    public static long valueOf(String date) {
        if (Timestamps.isTimestamp(date)) {
            long millis = 0L;
            StringBuilder text = new StringBuilder(date);
            Date d = null;
            if (date.endsWith("Z")) {
                text.replace(text.length() - 1, text.length(), "-0000");
            } else {
                text.deleteCharAt(text.length() - 3);
            }
            int fraction = date.indexOf(46);
            if (fraction > 0) {
                int end = text.length() - 5;
                millis = (long)(1000.0 * Double.parseDouble("0" + text.substring(fraction, end)));
                text.delete(fraction, end);
            }
            String munged = text.toString();
            try {
                d = RFC_3339_MUNGED.parse(munged);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            return d.getTime() + millis;
        }
        throw new IllegalArgumentException("Not a correctly formatted timestamp: " + date);
    }
}

