/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import oracle.dbtools.common.util.AbortedException;
import oracle.dbtools.common.util.Transform;

public class TransformCache<A, V>
implements Transform<A, V> {
    private final ConcurrentMap<A, Future<V>> cache = new ConcurrentHashMap<A, Future<V>>();
    private final boolean nullValuesAllowed;
    private final Transform<A, V> transform;

    public TransformCache(Transform<A, V> transform) {
        this(transform, true);
    }

    public TransformCache(Transform<A, V> transform, boolean nullValuesAllowed) {
        this.transform = transform;
        this.nullValuesAllowed = nullValuesAllowed;
    }

    /*
     * Loose catch block
     */
    @Override
    public V apply(final A arg) {
        while (true) {
            Callable eval;
            FutureTask ft;
            FutureTask f;
            if ((f = (FutureTask)this.cache.get(arg)) == null && (f = (Future)this.cache.putIfAbsent(arg, ft = new FutureTask(eval = new Callable<V>(){

                @Override
                public V call() {
                    return TransformCache.this.transform.apply(arg);
                }
            }))) == null) {
                f = ft;
                ft.run();
            }
            try {
                Object transformedValue = f.get();
                if (transformedValue == null && !this.nullValuesAllowed) {
                    this.cache.remove(arg, f);
                }
                return transformedValue;
            }
            catch (InterruptedException e) {
                throw new AbortedException(e);
            }
            catch (CancellationException e) {
                this.cache.remove(arg, f);
                continue;
            }
            break;
        }
        catch (ExecutionException e) {
            throw TransformCache.launderThrowable(e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ConcurrentMap<A, Future<V>> concurrentMap = this.cache;
        synchronized (concurrentMap) {
            this.cache.clear();
        }
    }

    public void remove(A arg) {
        this.cache.remove(arg);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TransformCache [cache=");
        builder.append(this.cache);
        builder.append("]");
        return builder.toString();
    }

    private static RuntimeException launderThrowable(Throwable t) {
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new IllegalStateException("Not unchecked", t);
    }
}

