/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.common.util.Tree;

public class TreeBuilder<T> {
    private Node<T> current;
    private Node<T> root;

    public Tree<T> build() {
        return this.root;
    }

    public TreeBuilder<T> enter(T item) {
        Node<T> node = new Node<T>(item);
        if (this.current == null) {
            this.root = node;
        } else {
            this.current.add(node);
        }
        this.current = node;
        return this;
    }

    public TreeBuilder<T> exit() {
        this.current = this.current.parent();
        return this;
    }

    public String toString() {
        return this.toString(this.root);
    }

    private String toString(Node<T> node) {
        StringBuilder b = new StringBuilder();
        if (node != null) {
            T item = node.node();
            String name = item.getClass().getSimpleName();
            b.append('<');
            b.append(name);
            b.append(':');
            b.append(item.toString());
            b.append('>');
            for (Node child : ((Node)node).children) {
                b.append(this.toString(child));
            }
            b.append("</");
            b.append(name);
            b.append('>');
        }
        return b.toString();
    }

    private static class Node<T>
    implements Tree<T> {
        private final List<Node<T>> children = new ArrayList<Node<T>>();
        private final T node;
        private Node<T> parent = null;

        Node(T node) {
            this.node = node;
        }

        public void add(Node<T> node) {
            node.parent = this;
            this.children.add(node);
        }

        @Override
        public Iterator<Tree<T>> iterator() {
            return Iterators.transform(this.children.iterator(), new Transform<Node<T>, Tree<T>>(){

                @Override
                public Tree<T> apply(Node<T> x) {
                    return x;
                }
            });
        }

        @Override
        public T node() {
            return this.node;
        }

        public Node<T> parent() {
            return this.parent;
        }

        public String toString() {
            return this.node.toString();
        }
    }
}

