/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarEntry;
import oracle.dbtools.common.CommonMessages;
import oracle.dbtools.common.TranslatableException;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Files;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.Text;

public abstract class URIs {
    private static final String[] ESCAPED = new String[]{"%7B", "%7D", "%7C", "%5C", "%5E", "%7E", "%5B", "%5D", "%60"};
    private static final String[] UNWISE = new String[]{"{", "}", "|", "\\", "^", "[", "]", "`"};

    private URIs() {
    }

    public static URI create(String text) {
        if (text == null) {
            return null;
        }
        try {
            return new URI(URIs.escape(text));
        }
        catch (URISyntaxException e) {
            throw URIs.illegalUri(e);
        }
    }

    public static boolean exists(URI uri) {
        return URIs.status(uri) != Status.DOES_NOT_EXIST;
    }

    public static IllegalURIException illegalUri(URISyntaxException e) {
        throw new IllegalURIException(e);
    }

    public static InputStream inputStream(URI uri) throws IOException {
        if ("file".equals(uri.getScheme())) {
            return Files.inputStream(Files.file(uri));
        }
        URL url = uri.toURL();
        return url.openStream();
    }

    public static String path(URI uri) {
        if (URIs.isJarUri(uri)) {
            Pair<String, URI> parsed = URIs.parseJarUri(uri);
            return parsed.second().getPath();
        }
        return uri.getPath();
    }

    public static URI resolve(URI base, String path) {
        if (NullOrEmpty.nullOrEmpty(path)) {
            return base;
        }
        if (URIs.isJarUri(base)) {
            return URIs.resolveJarUri(base, path);
        }
        return base.resolve(URIs.create(URIs.escape(path)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Status status(URI uri) {
        Status status = Status.DOES_NOT_EXIST;
        InputStream in = null;
        try {
            String scheme = uri.getScheme().toLowerCase();
            if (scheme.equals("file")) {
                Status status2 = URIs.fileExists(uri);
                return status2;
            }
            if (scheme.equals("jar")) {
                Status status3 = URIs.jarExists(uri);
                return status3;
            }
            URLConnection conn = uri.toURL().openConnection();
            if (conn != null && (in = conn.getInputStream()) != null) {
                if (uri.getPath().endsWith("/")) {
                    Status status4 = Status.FOLDER;
                    return status4;
                }
                Status status5 = Status.FILE;
                return status5;
            }
        }
        catch (IOException e) {
            status = Status.DOES_NOT_EXIST;
        }
        finally {
            Closeables.close(in);
        }
        return status;
    }

    public static boolean within(URI uri, URI candidate) {
        if (URIs.isJarUri(uri) && URIs.isJarUri(candidate)) {
            return URIs.withinJarUri(uri, candidate);
        }
        if (URIs.isPathUri(uri) && URIs.isPathUri(candidate)) {
            return URIs.withinPathUri(uri, candidate);
        }
        if (!uri.isAbsolute() || !candidate.isAbsolute()) {
            return false;
        }
        return !uri.relativize(candidate).isAbsolute();
    }

    private static String escape(String text) {
        for (int i = 0; i < UNWISE.length; ++i) {
            text = text.replace(UNWISE[i], ESCAPED[i]);
        }
        return text;
    }

    private static Status fileExists(URI uri) {
        File f = Files.file(uri);
        if (f.exists()) {
            if (f.isDirectory()) {
                return Status.FOLDER;
            }
            return Status.FILE;
        }
        return Status.DOES_NOT_EXIST;
    }

    private static boolean isJarUri(URI uri) {
        return "jar".equalsIgnoreCase(uri.getScheme());
    }

    private static boolean isPathUri(URI uri) {
        return uri.getScheme() == null && uri.getPath() != null;
    }

    private static Status jarExists(String jarPath, String withinJarPath) throws IOException {
        URI uri = URIs.resolveJarUri(URIs.create(jarPath), withinJarPath);
        URLConnection conn = uri.toURL().openConnection();
        if (conn != null) {
            JarURLConnection jar = (JarURLConnection)conn;
            JarEntry entry = null;
            try {
                entry = jar.getJarEntry();
            }
            catch (IOException e) {
                return Status.DOES_NOT_EXIST;
            }
            if (entry == null) {
                return Status.DOES_NOT_EXIST;
            }
            if (entry.isDirectory()) {
                return Status.FOLDER;
            }
            return Status.FILE;
        }
        return Status.DOES_NOT_EXIST;
    }

    private static Status jarExists(URI jarUri) throws IOException {
        Pair<String, URI> parsed = URIs.parseJarUri(jarUri);
        String jarPath = parsed.first();
        String withinJarPath = parsed.second().toString();
        if (withinJarPath.endsWith("/")) {
            return URIs.jarExists(jarPath, withinJarPath);
        }
        Status status = URIs.jarExists(jarPath, withinJarPath + "/");
        if (Status.DOES_NOT_EXIST == status) {
            status = URIs.jarExists(jarPath, withinJarPath);
        }
        return status;
    }

    private static Pair<String, URI> parseJarUri(URI jarUri) {
        String text = jarUri.toString();
        int bang = text.indexOf("!");
        String prefix = null;
        String path = null;
        if (bang == -1 || bang == text.length() - 1) {
            path = "/";
            prefix = bang == -1 ? text : Text.stripSuffix(text, "!");
        } else {
            path = text.substring(bang + 1);
            prefix = text.substring(0, bang);
        }
        return Pair.pair(prefix, URIs.create(path));
    }

    private static URI resolveJarUri(URI jarUri, String path) {
        Pair<String, URI> jar = URIs.parseJarUri(jarUri);
        String prefix = jar.first();
        URI basePath = jar.second();
        URI pathResolved = URIs.resolve(basePath, path);
        StringBuilder b = new StringBuilder();
        b.append(prefix);
        b.append("!");
        b.append(pathResolved.toString());
        return URIs.create(b.toString());
    }

    private static boolean withinJarUri(URI uri, URI candidate) {
        Pair<String, URI> j1 = URIs.parseJarUri(uri);
        Pair<String, URI> j2 = URIs.parseJarUri(candidate);
        if (j1.first().equals(j2.first())) {
            return URIs.within(j1.second(), j2.second());
        }
        return false;
    }

    private static boolean withinPathUri(URI uri, URI candidate) {
        String prefix = uri.getPath();
        if (!prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        return candidate.getPath().startsWith(prefix);
    }

    public static enum Status {
        DOES_NOT_EXIST,
        FILE,
        FOLDER;

    }

    public static class IllegalURIException
    extends RuntimeException
    implements TranslatableException {
        private final TranslatableMessage msg;
        private final String uri;
        private static final long serialVersionUID = -2655880863766154319L;

        private IllegalURIException(URISyntaxException e) {
            super(e);
            this.uri = e.getInput();
            int position = e.getIndex();
            this.msg = position < 0 ? new TranslatableMessage(CommonMessages.class, "URIs.0", "The URI is not well-formed, reason: {0}", e.getReason()) : new TranslatableMessage(CommonMessages.class, "URIs.1", "The URI is not well-formed, reason: {0} at position: {1}", e.getReason(), e.getIndex());
        }

        @Override
        public String getMessage() {
            return this.msg.toString();
        }

        @Override
        public TranslatableMessage getTranslatableMessage() {
            return this.msg;
        }

        public String uri() {
            return this.uri;
        }
    }
}

