/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.x3p;

import java.util.ArrayList;
import java.util.Stack;
import javax.xml.namespace.QName;
import oracle.dbtools.common.util.Selector;
import oracle.dbtools.common.util.Selectors;
import oracle.dbtools.common.x3p.X3PAttributes;
import oracle.dbtools.common.x3p.X3PElement;
import oracle.dbtools.common.x3p.X3PFilter;
import oracle.dbtools.common.x3p.X3PFilterAdaptor;
import oracle.dbtools.common.x3p.X3PPath;
import oracle.dbtools.common.x3p.X3PSelector;
import oracle.dbtools.common.x3p.model.Behavioral;

public abstract class MatchFilter
extends X3PFilterAdaptor {
    @Behavioral
    private final Selector<X3PSelector> condition;
    private final Stack<X3PElement> elements = new Stack();
    private final Stack<QName> path = new Stack();

    public MatchFilter(Selector<X3PSelector> condition) {
        this.condition = condition;
    }

    public MatchFilter(X3PPath ... paths) {
        this(Selectors.or(MatchFilter.asList(paths)));
    }

    @Override
    public void characters(char[] ch, int start, int length, X3PFilter.Mutator mutator) {
        X3PElement e = this.element();
        if (this.match(e)) {
            this.characters(e.getPath(), ch, start, length, mutator);
        }
    }

    @Override
    public void endElement(QName name, X3PFilter.Mutator mutator) {
        X3PElement e = this.element();
        if (this.match(e)) {
            this.endElement(e.getPath(), mutator);
        }
        this.pop();
    }

    @Override
    public void startElement(QName name, X3PAttributes atts, X3PFilter.Mutator mutator) {
        X3PElement e = this.push(name, atts);
        if (this.match(e)) {
            this.startElement(e.getPath(), atts, mutator);
        }
    }

    protected void characters(X3PPath path, char[] ch, int offset, int length, X3PFilter.Mutator mutator) {
    }

    protected void endElement(X3PPath path, X3PFilter.Mutator mutator) {
    }

    protected void startElement(X3PPath path, X3PAttributes atts, X3PFilter.Mutator mutator) {
    }

    private X3PElement element() {
        if (this.elements.isEmpty()) {
            return null;
        }
        return this.elements.peek();
    }

    private boolean match(X3PSelector path) {
        return (Boolean)this.condition.apply(path);
    }

    private X3PPath path() {
        return new X3PPath(this.path);
    }

    private void pop() {
        if (!this.path.isEmpty()) {
            this.path.pop();
        }
        if (!this.elements.isEmpty()) {
            this.elements.pop();
        }
    }

    private X3PElement push(QName name, X3PAttributes attrs) {
        this.path.push(name);
        return this.elements.push(new X3PElement(this.path(), attrs));
    }

    private static Iterable<Selector<X3PSelector>> asList(X3PPath ... paths) {
        ArrayList<Selector<X3PSelector>> selectors = new ArrayList<Selector<X3PSelector>>();
        for (X3PPath path : paths) {
            selectors.add(path);
        }
        return selectors;
    }
}

