/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.x3p;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.dbtools.common.x3p.X3PFilter;
import oracle.dbtools.common.x3p.X3PFilterChain;
import oracle.dbtools.common.x3p.X3PHandler;
import oracle.dbtools.common.x3p.X3PPath;
import oracle.dbtools.common.x3p.X3PReader;
import oracle.dbtools.common.x3p.X3PWriterOptions;
import oracle.dbtools.common.x3p.impl.Event;
import oracle.dbtools.common.x3p.impl.X3PFactoryImpl;

public class X3PFactory {
    public static X3PFilterChain chain(X3PFilter ... filters) {
        return X3PFactoryImpl.chain(filters);
    }

    public static X3PFilter[] compose(X3PFilter ... filters) {
        return filters;
    }

    public static X3PFilter[] compose(X3PFilter start, X3PFilter[] next, X3PFilter ... filters) {
        return X3PFactory.recompose(X3PFactory.compose(start), next, filters);
    }

    public static X3PFilter[] compose(X3PFilter[] first, X3PFilter ... filters) {
        return X3PFactory.recompose(first, filters);
    }

    public static Iterable<X3PReader> compose(X3PReader ... reader) {
        if (reader.length == 1) {
            return X3PFactoryImpl.compose(reader[0]);
        }
        throw new RuntimeException("composing more than one item has been found to be redundant, expect the compose method to be removed in the near future");
    }

    public static void drain(X3PHandler w, X3PReader r) throws IOException {
        r.setHandler(w);
        while (r.next()) {
        }
    }

    public static X3PReader newReader(InputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException();
        }
        return X3PFactory.newReader(new StreamSource(stream));
    }

    public static X3PReader newReader(InputStream stream, X3PFilter ... filters) throws IOException {
        if (stream == null) {
            throw new NullPointerException();
        }
        return X3PFactory.chain(filters).filter(X3PFactory.compose(X3PFactory.newReader(stream)));
    }

    public static X3PReader newReader(Source input) throws IOException {
        return X3PFactoryImpl.newReader(input);
    }

    public static InputStream newStream(InputStream input, X3PFilter ... filters) throws IOException {
        if (input == null || filters == null) {
            throw new NullPointerException();
        }
        X3PFilterChain chain = X3PFactory.chain(filters);
        X3PReader r = chain.filter(X3PFactory.compose(X3PFactory.newReader(input)));
        return X3PFactory.newStream(r, new X3PWriterOptions(true, true, new X3PPath[0]));
    }

    public static InputStream newStream(InputStream input, X3PFilterChain chain) throws IOException {
        if (input == null || chain == null) {
            throw new NullPointerException();
        }
        X3PReader r = chain.filter(X3PFactory.compose(X3PFactory.newReader(input)));
        return X3PFactory.newStream(r, new X3PWriterOptions(true, true, new X3PPath[0]));
    }

    public static InputStream newStream(Iterator<Event> events) throws IOException {
        return X3PFactory.newStream(X3PFactoryImpl.newReader(events).iterator().next(), new X3PWriterOptions(true, true, new X3PPath[0]));
    }

    public static InputStream newStream(X3PReader input, X3PWriterOptions options) throws IOException {
        if (input == null) {
            throw new NullPointerException();
        }
        return X3PFactoryImpl.newStream(input, options);
    }

    public static X3PHandler newWriter(OutputStream output, X3PWriterOptions options) throws IOException {
        if (output == null) {
            throw new NullPointerException();
        }
        return X3PFactory.newWriter(new StreamResult(output), options);
    }

    public static X3PHandler newWriter(StreamResult output, X3PWriterOptions options) throws IOException {
        if (output == null) {
            throw new NullPointerException();
        }
        return X3PFactoryImpl.newWriter(output, options);
    }

    public static X3PHandler newWriter(Writer output, X3PWriterOptions options) throws IOException {
        if (output == null) {
            throw new NullPointerException();
        }
        return X3PFactory.newWriter(new StreamResult(output), options);
    }

    private static X3PFilter[] recompose(X3PFilter[] ... filters) {
        int flatCount = 0;
        for (X3PFilter[] composed : filters) {
            if (null == composed) continue;
            flatCount += composed.length;
        }
        X3PFilter[] flattened = new X3PFilter[flatCount];
        int index = 0;
        for (X3PFilter[] composed : filters) {
            if (null == composed) continue;
            System.arraycopy(composed, 0, flattened, index, composed.length);
            index += composed.length;
        }
        return flattened;
    }
}

