/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.x3p;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import oracle.dbtools.common.x3p.X3PElement;
import oracle.dbtools.common.x3p.X3PSelector;

public class X3PPath
implements X3PSelector {
    private final List<QName> segments = new ArrayList<QName>();

    public X3PPath(Iterable<QName> segments) {
        for (QName segment : segments) {
            this.segments.add(segment);
        }
    }

    public X3PPath(QName ... segments) {
        for (QName segment : segments) {
            this.segments.add(segment);
        }
    }

    public X3PPath(X3PPath base, QName ... segments) {
        this.segments.addAll(base.segments);
        for (QName segment : segments) {
            this.segments.add(segment);
        }
    }

    @Override
    public Boolean apply(X3PSelector x) {
        if (x instanceof X3PElement) {
            return this.equals(((X3PElement)x).getPath());
        }
        return this.equals(x);
    }

    public X3PPath child(QName name) {
        return X3PPath.path(this, name);
    }

    public X3PPath child(String name) {
        return this.child(new QName(this.lastSegment().getNamespaceURI(), name, this.lastSegment().getPrefix()));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.segments == null ? 0 : ((Object)this.segments).hashCode());
        return result;
    }

    public QName lastSegment() {
        if (this.size() == 0) {
            return null;
        }
        return this.segments.get(this.segments.size() - 1);
    }

    public X3PPath parent() {
        List<QName> pSegs = this.segments.subList(0, this.segments.size() - 1);
        if (pSegs.size() == 0) {
            return null;
        }
        return new X3PPath(pSegs);
    }

    public int size() {
        return this.segments.size();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        Iterator<QName> iter = this.segments.iterator();
        while (iter.hasNext()) {
            b.append('/');
            b.append(iter.next().getLocalPart());
        }
        return b.toString();
    }

    public boolean within(X3PPath path) {
        if (path.size() <= this.size()) {
            for (int i = 0; i < path.size(); ++i) {
                QName otherName;
                QName thisName = this.segments.get(i);
                if (thisName.equals(otherName = path.segments.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static X3PPath[] childPaths(QName node, X3PPath ... parents) {
        X3PPath[] childPaths = new X3PPath[parents.length];
        for (int i = 0; i < parents.length; ++i) {
            childPaths[i] = X3PPath.path(parents[i], node);
        }
        return childPaths;
    }

    public static X3PPath path(QName ... segments) {
        return new X3PPath(segments);
    }

    public static X3PPath path(X3PPath base, QName ... segments) {
        return new X3PPath(base, segments);
    }

    public static QName qName(String ns, String localPart) {
        return X3PPath.qName(ns, localPart, "");
    }

    public static QName qName(String ns, String localPart, String prefix) {
        return new QName(ns, localPart, prefix);
    }
}

