/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.x3p.impl;

import java.io.Closeable;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import oracle.dbtools.common.buffers.BufferHandle;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.x3p.Namespaces;
import oracle.dbtools.common.x3p.X3PAttribute;
import oracle.dbtools.common.x3p.X3PAttributes;
import oracle.dbtools.common.x3p.X3PHandler;
import oracle.dbtools.common.x3p.X3PPath;
import oracle.dbtools.common.x3p.X3PWriterOptions;
import oracle.dbtools.common.x3p.impl.ForceTransformerFactory;
import oracle.dbtools.common.x3p.impl.NewlineNormalizer;
import oracle.dbtools.common.x3p.impl.XmlDecl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

class X3PWriter
implements X3PHandler,
Closeable {
    private final Namespaces namespaces;
    private final NamespaceHandler nsHandler = new NamespaceHandler();
    private final StreamResult output;
    private boolean preRoot = true;
    private final ContentHandler serializer;
    private int startDocumentEvent = 0;

    public X3PWriter(StreamResult output, X3PWriterOptions options) throws IOException {
        this.output = output;
        this.serializer = X3PWriter.newSerializer(output, options);
        this.namespaces = new Namespaces(this.nsHandler);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        try {
            if (this.preRoot) {
                if (new String(ch, start, length).trim().isEmpty()) {
                    return;
                }
                this.preRoot = false;
            }
            this.preamble();
            this.serializer.characters(ch, start, length);
        }
        catch (SAXException e) {
            throw this.wrap(e);
        }
    }

    @Override
    public void close() throws IOException {
        Closeables.close(this.serializer);
    }

    @Override
    public void endDocument() {
        try {
            this.preamble();
            this.serializer.endDocument();
        }
        catch (SAXException e) {
            throw this.wrap(e);
        }
    }

    @Override
    public void endElement(QName name) {
        try {
            this.serializer.endElement(name.getNamespaceURI(), name.getLocalPart(), this.qName(name));
            this.namespaces.exit();
        }
        catch (SAXException e) {
            throw this.wrap(e);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) {
    }

    @Override
    public void processingInstruction(String target, String data) {
        try {
            this.preamble();
            this.serializer.processingInstruction(target, data);
        }
        catch (SAXException e) {
            throw this.wrap(e);
        }
    }

    @Override
    public void skippedEntity(String name) {
        try {
            this.preamble();
            this.serializer.skippedEntity(name);
        }
        catch (SAXException e) {
            throw this.wrap(e);
        }
    }

    @Override
    public void startDocument() {
        ++this.startDocumentEvent;
    }

    @Override
    public void startElement(QName name, X3PAttributes atts) {
        if (this.preRoot) {
            this.preRoot = false;
        }
        try {
            this.preamble();
            this.startNS(name, atts);
            String uri = name.getNamespaceURI();
            String localName = name.getLocalPart();
            String qName = this.qName(name);
            Attributes attrs = this.adapt(atts);
            this.serializer.startElement(uri, localName, qName, attrs);
        }
        catch (SAXException e) {
            throw this.wrap(e);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        this.namespaces.add(prefix, uri);
    }

    @Override
    public void stream(BufferHandle stream) {
        try {
            this.preamble();
        }
        catch (SAXException e) {
            throw this.wrap(e);
        }
    }

    protected StreamResult getStreamResult() {
        return this.output;
    }

    private Attributes adapt(X3PAttributes atts) {
        if (atts == null) {
            return null;
        }
        return new AttributesAdaptor(atts);
    }

    private void preamble() throws SAXException {
        if (this.startDocumentEvent == 1) {
            this.serializer.startDocument();
            this.startDocumentEvent = 0;
        }
    }

    private String qName(QName name) {
        if (name.getPrefix().isEmpty()) {
            return name.getLocalPart();
        }
        return name.getPrefix() + ":" + name.getLocalPart();
    }

    private void startNS(QName name, X3PAttributes attrs) throws SAXException {
        this.namespaces.add(name.getPrefix(), name.getNamespaceURI());
        if (attrs != null) {
            for (X3PAttribute a : attrs) {
                QName n = a.getName();
                if (n.getNamespaceURI().isEmpty()) continue;
                this.namespaces.add(n.getPrefix(), n.getNamespaceURI());
            }
        }
        this.namespaces.enter();
    }

    private RuntimeException wrap(SAXException e) {
        return new RuntimeException(e);
    }

    private static String cdata(X3PPath[] cData) {
        StringBuilder b = new StringBuilder();
        for (X3PPath path : cData) {
            QName lastSegment = path.lastSegment();
            String ns = lastSegment.getNamespaceURI();
            String localPart = lastSegment.getLocalPart();
            if (!ns.isEmpty()) {
                b.append(ns);
                b.append(':');
            }
            b.append(localPart);
            b.append(' ');
        }
        return b.toString();
    }

    private static ContentHandler newSerializer(StreamResult output, X3PWriterOptions options) throws IOException {
        TransformerFactory transFact = ForceTransformerFactory.newInstance();
        SAXTransformerFactory saxTransFact = (SAXTransformerFactory)transFact;
        try {
            TransformerHandler h = saxTransFact.newTransformerHandler();
            Transformer t = h.getTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            if (options.indent()) {
                t.setOutputProperty("indent", "yes");
            } else {
                t.setOutputProperty("indent", "no");
            }
            if (options.cData().length > 0) {
                t.setOutputProperty("cdata-section-elements", X3PWriter.cdata(options.cData()));
            }
            StreamResult out = NewlineNormalizer.normalize(output);
            h.setResult(out);
            return new XmlDecl(options.emitDecl(), h, out.getWriter());
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private class NamespaceHandler
    implements Namespaces.Handler {
        private NamespaceHandler() {
        }

        @Override
        public void end(String prefix) {
            try {
                X3PWriter.this.serializer.endPrefixMapping(prefix);
            }
            catch (SAXException e) {
                throw X3PWriter.this.wrap(e);
            }
        }

        @Override
        public void start(String prefix, String uri) {
            try {
                X3PWriter.this.serializer.startPrefixMapping(prefix, uri);
            }
            catch (SAXException e) {
                throw X3PWriter.this.wrap(e);
            }
        }
    }

    private static final class AttributesAdaptor
    implements Attributes {
        private final X3PAttributes atts;

        private AttributesAdaptor(X3PAttributes atts) {
            this.atts = atts;
        }

        @Override
        public int getIndex(String qName) {
            String prefix = "";
            String localName = qName;
            int colon = qName.indexOf(58);
            if (colon != -1) {
                prefix = qName.substring(0, colon);
                localName = qName.substring(colon + 1);
            }
            int pos = 0;
            for (X3PAttribute a : this.atts) {
                QName name = a.getName();
                if (prefix.equals(name.getPrefix()) && localName.equals(name.getLocalPart())) {
                    return pos;
                }
                ++pos;
            }
            return -1;
        }

        @Override
        public int getIndex(String uri, String localName) {
            int pos = 0;
            for (X3PAttribute a : this.atts) {
                QName name = a.getName();
                if (uri.equals(name.getNamespaceURI()) && localName.equals(name.getLocalPart())) {
                    return pos;
                }
                ++pos;
            }
            return -1;
        }

        @Override
        public int getLength() {
            return this.atts.size();
        }

        @Override
        public String getLocalName(int index) {
            boolean pos = false;
            for (X3PAttribute a : this.atts) {
                if (0 != index) continue;
                return a.getName().getLocalPart();
            }
            return null;
        }

        @Override
        public String getQName(int index) {
            int pos = 0;
            for (X3PAttribute a : this.atts) {
                if (pos == index) {
                    QName name = a.getName();
                    String prefix = name.getPrefix();
                    String localName = name.getLocalPart();
                    if (prefix.isEmpty()) {
                        return localName;
                    }
                    return prefix + ":" + localName;
                }
                ++pos;
            }
            return null;
        }

        @Override
        public String getType(int index) {
            return "";
        }

        @Override
        public String getType(String qName) {
            return "";
        }

        @Override
        public String getType(String uri, String localName) {
            return "";
        }

        @Override
        public String getURI(int index) {
            boolean pos = false;
            for (X3PAttribute a : this.atts) {
                if (0 != index) continue;
                return a.getName().getNamespaceURI();
            }
            return null;
        }

        @Override
        public String getValue(int index) {
            return this.atts.get(index);
        }

        @Override
        public String getValue(String qName) {
            return null;
        }

        @Override
        public String getValue(String uri, String localName) {
            QName name = new QName(uri, localName);
            return this.atts.get(name);
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append('[');
            for (X3PAttribute a : this.atts) {
                QName name = a.getName();
                if (name.getPrefix().isEmpty()) {
                    b.append(name.getLocalPart());
                } else {
                    b.append(name.getPrefix());
                    b.append(':');
                    b.append(name.getLocalPart());
                }
                b.append('=');
                b.append(a.getValue());
                b.append(", ");
            }
            b.append(']');
            return b.toString();
        }
    }
}

