/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.x3p.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XmlDecl
implements ContentHandler,
Closeable {
    private boolean beforeContent = true;
    private final boolean emitDecl;
    private final ContentHandler h;
    private final Writer out;
    private static final String XML_DECL = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";

    public XmlDecl(boolean emitDecl, ContentHandler h, Writer out) {
        this.emitDecl = emitDecl;
        this.h = h;
        this.out = out;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.h.characters(ch, start, length);
    }

    @Override
    public void close() throws IOException {
        this.out.flush();
    }

    @Override
    public void endDocument() throws SAXException {
        this.h.endDocument();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.h.endElement(uri, localName, qName);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.h.endPrefixMapping(prefix);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.h.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.preamble();
        this.h.processingInstruction(target, data);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.h.setDocumentLocator(locator);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.preamble();
        this.h.skippedEntity(name);
    }

    @Override
    public void startDocument() throws SAXException {
        this.h.startDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.preamble();
        this.h.startElement(uri, localName, qName, atts);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.h.startPrefixMapping(prefix, uri);
    }

    private void preamble() throws SAXException {
        if (this.emitDecl && this.beforeContent) {
            try {
                this.out.write(XML_DECL);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
            this.beforeContent = false;
        }
    }
}

