/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.actions;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.scheduler.editors.graphical.GraphicalEditor;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.ide.view.View;
import oracle.javatools.util.Version;

public class SchedulerGraphicalEditorAction
extends AbstractMenuAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch() {
        DBObject dBObject = this.getDBObject();
        WaitCursor waitCursor = new WaitCursor((Component)Ide.getMainWindow());
        try {
            waitCursor.show();
            Editor editor = SchedulerGraphicalEditorAction.openNewTempWorksheet(dBObject);
            if (editor != null) {
                View.updateToolbarActions((Toolbar)editor.getToolbar());
            }
        }
        finally {
            waitCursor.hide();
        }
    }

    public void setArgs(String string) {
    }

    public static Editor openNewTempWorksheet(DBObject dBObject) {
        try {
            URL uRL = SchedulerGraphicalEditorAction.createWorksheetURL(dBObject.getConnectionName());
            ViewerNode viewerNode = new ViewerNode();
            viewerNode.setURL(uRL);
            viewerNode.setViewedObject(dBObject);
            Context context = Context.newIdeContext((Node)viewerNode);
            context.setProperty("Connections.db_name", (Object)dBObject.getConnectionName());
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context, GraphicalEditor.class);
            Editor editor = EditorManager.getEditorManager().openEditor(openEditorOptions);
            return editor;
        }
        catch (Exception exception) {
            Logger.getLogger(SchedulerGraphicalEditorAction.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            return null;
        }
    }

    public static URL createWorksheetURL(String string) {
        URL uRL = null;
        try {
            File file = File.createTempFile("scheduler", ".txt");
            file.deleteOnExit();
            uRL = URLFactory.newURL((String)"sqldev.scheduler", (String)file.getPath());
        }
        catch (IOException iOException) {
            Logger.getLogger(SchedulerGraphicalEditorAction.class.getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        return uRL;
    }

    public boolean isEnabled(Context context) {
        Version version = new Version("10");
        return DBUtil.checkVersion((Connection)this.getDBObject().getConnection(), null, (Version)version) && super.isEnabled(context);
    }
}

