/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.dialogs.newjob;

import java.awt.CardLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialogTab;
import oracle.dbtools.raptor.ui.controls.CardLayoutActionControl;
import oracle.dbtools.raptor.ui.controls.PropertyPanelActionControl;
import oracle.dbtools.raptor.ui.controls.TableActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.dialogs.newjob.NewJobModel;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.QualifiedIdentifier;

public class NewJobCreateActionDialogTab_JobArguments
extends ActionDialogTab
implements PropertyChangeListener,
DocumentListener,
LayoutControl {
    private static final String METADATA_ATTRIBUTE_PREFIX = "META_ATTRIBUTE.";
    private NewJobModel model;
    Connection conn = null;
    CardLayoutActionControl whereJobCtl = null;
    CardLayout _cardLayout;
    protected JPanel topCardPanel;
    private PropertyPanelActionControl topPanelCtl = null;
    private ActionControl programArgumentCtl = null;
    private ActionControl storedProcedureArgumentCtl = null;
    private ActionControl executableCtl = null;
    private ActionControl noArgCtl = null;
    private List<JobArgument> job_arguments = new ArrayList<JobArgument>();
    private TextBoxActionControl nameExecCtl = null;
    private TableActionControl tableExecCtl = null;
    private String[] newArgValues = null;
    private String _currentSelector;

    public NewJobCreateActionDialogTab_JobArguments(String string, String string2, NewJobModel newJobModel) {
        super(string, string2);
        this.model = newJobModel;
        if (this.model != null && newJobModel.getOperation() != NewJobModel.Operation.CREATE_NEW) {
            this.newArgValues = newJobModel.getPreviousJobJobArgData();
        }
    }

    public List<ActionControl> createControls(Connection connection) {
        this.conn = connection;
        this.programArgumentCtl = this.createProgramArgumentControl(connection);
        this.storedProcedureArgumentCtl = this.createStoredProcedureArgumentControl(connection);
        this.executableCtl = this.createExecutableControl(connection);
        this.noArgCtl = this.createChainPlSqlControl(connection);
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add(this.programArgumentCtl);
        arrayList.add(this.storedProcedureArgumentCtl);
        arrayList.add(this.executableCtl);
        arrayList.add(this.noArgCtl);
        this.topPanelCtl = new PropertyPanelActionControl("JOB_ARGUMENT_PANEL", null, arrayList);
        this.topPanelCtl.setFillVertical(true);
        this.topPanelCtl.setSpringVertical(true);
        this.createUI();
        ArrayList<ActionControl> arrayList2 = new ArrayList<ActionControl>();
        arrayList2.add((ActionControl)this.topPanelCtl);
        return arrayList2;
    }

    public void createUI() {
        this.topCardPanel = this.topPanelCtl.getUI();
        this.topCardPanel.removeAll();
        this._cardLayout = new CardLayout(0, 0);
        this.topCardPanel.setLayout(this._cardLayout);
        this.topCardPanel.add(this.noArgCtl.getUI(), "NOARG_CHOICE");
        this.topCardPanel.add(this.storedProcedureArgumentCtl.getUI(), "STORED_PROCEDURE_CHOICE");
        this.topCardPanel.add(this.programArgumentCtl.getUI(), "NAMED_PROGRAM_CHOICE");
        this.topCardPanel.add(this.executableCtl.getUI(), "EXECUTABLE_CHOICE");
    }

    private ActionControl createProgramArgumentControl(Connection connection) {
        PropertyPanelActionControl propertyPanelActionControl = new PropertyPanelActionControl("JOB_ARGUMENT_PANEL_PROGRAM", null);
        TextBoxActionControl textBoxActionControl = null;
        TableActionControl tableActionControl = null;
        textBoxActionControl = new TextBoxActionControl("NAMED_PROGRAM_NAME", SchedulerArb.getString("JOBCLASSPANEL_NAME_LABEL"), "");
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        Collections.addAll(arrayList2, SchedulerArb.getString("JOB_CREATE_JOB_ARGUMENT_PROGRAM_ARG_TABLE_COLUMN_ARGNAME_LABEL"), SchedulerArb.getString("JOB_CREATE_JOB_ARGUMENT_PROGRAM_ARG_TABLE_COLUMN_ARGTYPE_LABEL"), SchedulerArb.getString("JOB_CREATE_JOB_ARGUMENT_PROGRAM_ARG_TABLE_COLUMN_ARGDEFAULTVALUE_LABEL"), SchedulerArb.getString("JOB_CREATE_JOB_ARGUMENT_PROGRAM_ARG_TABLE_COLUMN_ARGNEWVALUE_LABEL"));
        tableActionControl = new TableActionControl("NAMED_PROGRAM_TABLE", SchedulerArb.getString("JOB_CREATE_JOB_ARGUMENT_PROGRAM_ARGUMENTS_LABEL"), arrayList2, arrayList, 20);
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        arrayList3.add(textBoxActionControl);
        arrayList3.add(tableActionControl);
        propertyPanelActionControl.addChildControls(arrayList3);
        return propertyPanelActionControl;
    }

    private ActionControl createStoredProcedureArgumentControl(Connection connection) {
        PropertyPanelActionControl propertyPanelActionControl = new PropertyPanelActionControl("JOB_ARGUMENT_PANEL_STORED_PROCEDURE", null);
        TextBoxActionControl textBoxActionControl = null;
        TableActionControl tableActionControl = null;
        textBoxActionControl = new TextBoxActionControl("STORED_PROCEDURE_NAME", SchedulerArb.getString("JOBCLASSPANEL_NAME_LABEL"), "");
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        Collections.addAll(arrayList2, SchedulerArb.getString("JOB_CREATE_JOB_ARGUMENT_PROGRAM_ARG_TABLE_COLUMN_ARGNAME_LABEL"), SchedulerArb.getString("JOB_CREATE_JOB_ARGUMENT_PROGRAM_ARG_TABLE_COLUMN_ARGTYPE_LABEL"), SchedulerArb.getString("JOB_CREATE_JOB_ARGUMENT_PROGRAM_ARG_TABLE_COLUMN_ARGNEWVALUE_LABEL"));
        tableActionControl = new TableActionControl("STORED_PROCEDURE_TABLE", SchedulerArb.getString("JOB_CREATE_JOB_ARGUMENT_PROGRAM_ARGUMENTS_LABEL"), arrayList2, arrayList, 20);
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        arrayList3.add(textBoxActionControl);
        arrayList3.add(tableActionControl);
        propertyPanelActionControl.addChildControls(arrayList3);
        return propertyPanelActionControl;
    }

    protected ActionControl createExecutableControl(Connection connection) {
        PropertyPanelActionControl propertyPanelActionControl = new PropertyPanelActionControl("JOB_ARGUMENT_PANEL_EXECUTABLE", null);
        this.nameExecCtl = new TextBoxActionControl("EXECUTABLE_NAME", SchedulerArb.getString("JOBCLASSPANEL_NAME_LABEL"), "");
        this.nameExecCtl.setEditable(false);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        Collections.addAll(arrayList2, SchedulerArb.getString("JOB_CREATE_JOB_ARGUMENT_PROGRAM_ARG_TABLE_COLUMN_ARGNEWVALUE_LABEL"));
        this.tableExecCtl = new TableActionControl("EXECUTABLE_TABLE", SchedulerArb.getString("JOB_CREATE_JOB_ARGUMENT_PROGRAM_ARGUMENTS_LABEL"), (TableActionControl.RowFactory)new ExecJobArgumentRowFactory(), arrayList2, arrayList, 20, true);
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        arrayList3.add(this.nameExecCtl);
        arrayList3.add(this.tableExecCtl);
        propertyPanelActionControl.addChildControls(arrayList3);
        return propertyPanelActionControl;
    }

    private ActionControl createChainPlSqlControl(Connection connection) {
        PropertyPanelActionControl propertyPanelActionControl = new PropertyPanelActionControl();
        return propertyPanelActionControl;
    }

    private void show(String string) {
        this._cardLayout.show(this.topCardPanel, string);
        this.setCurrentSelector(string);
    }

    private void setCurrentSelector(String string) {
        this._currentSelector = string;
    }

    private String getCurrentSelectorKey() {
        return this._currentSelector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = propertyChangeEvent.getPropertyName();
        String string6 = ((ActionControl.Value)propertyChangeEvent.getNewValue()).get();
        if (string6 == null || string6.trim().length() == 0) {
            return;
        }
        if (string5.equals("WHAT_JOB_TYPE_PANEL_STORED_PROCEDURE")) {
            if (this.topPanelCtl != null) {
                Object object;
                Object object2;
                String string7;
                Object object3;
                ArrayList arrayList;
                TableActionControl tableActionControl;
                List list = this.topPanelCtl.getChildControls();
                ActionControl actionControl = (ActionControl)list.get(1);
                TextBoxActionControl textBoxActionControl = (TextBoxActionControl)actionControl.getChildControls().get(0);
                textBoxActionControl.enableUI(true);
                textBoxActionControl.set(string6);
                textBoxActionControl.enableUI(false);
                string = this.model.getSchemaForStoredProcedure();
                String[] stringArray = this.getJobArgumentSplit(string6);
                if (stringArray.length == 2) {
                    string4 = stringArray[0];
                    string2 = stringArray[1];
                } else {
                    string4 = null;
                    string2 = stringArray[0];
                }
                if (Connections.getInstance().lock(this.conn)) {
                    tableActionControl = null;
                    arrayList = null;
                    object3 = new ArrayList();
                    try {
                        Hashtable<String, String> hashtable = new Hashtable<String, String>();
                        hashtable.put("schemaName", string);
                        hashtable.put("procName", string2);
                        if (string4 != null) {
                            hashtable.put("packageName", string4);
                        }
                        string7 = DBUtil.getInstance((Connection)this.conn);
                        string7.setRaiseError(true);
                        object2 = this.getSchedulerGeneratorQuery(this.conn, "PROGRAM_MODEL_PROCEDURE_ARGUMENTS", hashtable);
                        tableActionControl = string7.executeOracleQuery((String)object2, hashtable);
                        if (tableActionControl != null) {
                            object = tableActionControl.getResultSet();
                            this.setProcedureArgumentsFromResultSet((ResultSet)object, (List<String>)object3);
                        }
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                    finally {
                        if (tableActionControl != null) {
                            tableActionControl.close();
                        }
                        if (arrayList != null) {
                            arrayList.close();
                        }
                        Connections.getInstance().unlock(this.conn);
                    }
                }
                tableActionControl = (TableActionControl)actionControl.getChildControls().get(1);
                arrayList = new ArrayList();
                object3 = this.job_arguments.listIterator();
                int n = 0;
                string7 = "";
                while (object3.hasNext()) {
                    object2 = (JobArgument)object3.next();
                    string7 = this.model.getOperation() != NewJobModel.Operation.CREATE_NEW ? (this.newArgValues != null && this.newArgValues.length > n ? this.newArgValues[n] : "") : "";
                    object = new StoredProcedureJobArgumentRow(((JobArgument)object2).getArgumentName(), ((JobArgument)object2).getArgumentType(), string7);
                    arrayList.add(object);
                    ++n;
                }
                tableActionControl.setRows(arrayList);
            }
            return;
        }
        if (string5.equals("WHAT_JOB_TYPE_PANEL_NAMED_PROGRAM")) {
            if (this.topPanelCtl != null) {
                Object object;
                String string8;
                Object object4;
                ArrayList arrayList;
                TableActionControl tableActionControl;
                List list = this.topPanelCtl.getChildControls();
                ActionControl actionControl = (ActionControl)list.get(0);
                TextBoxActionControl textBoxActionControl = (TextBoxActionControl)actionControl.getChildControls().get(0);
                textBoxActionControl.enableUI(true);
                textBoxActionControl.set(string6);
                textBoxActionControl.enableUI(false);
                String[] stringArray = this.getJobArgumentSplit(string6);
                if (stringArray.length == 2) {
                    string = stringArray[0];
                    string3 = stringArray[1];
                } else {
                    string = this.model.getSchema();
                    string3 = stringArray[0];
                }
                ArrayList arrayList2 = new ArrayList();
                if (Connections.getInstance().lock(this.conn)) {
                    tableActionControl = null;
                    arrayList = null;
                    try {
                        object4 = new Hashtable<String, String>();
                        object4.put("OWNER", string);
                        object4.put("PROGRAM_NAME", string3);
                        DBUtil dBUtil = DBUtil.getInstance((Connection)this.conn);
                        dBUtil.setRaiseError(true);
                        string8 = this.getSchedulerGeneratorQuery(this.conn, "PROGRAM_MODEL_PROGRAM_ARGUMENTS");
                        tableActionControl = dBUtil.executeOracleQuery(string8, (Map)object4);
                        if (tableActionControl != null) {
                            object = tableActionControl.getResultSet();
                            this.setProgramArgumentsFromResultSet((ResultSet)object);
                        }
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                    finally {
                        if (tableActionControl != null) {
                            tableActionControl.close();
                        }
                        if (arrayList != null) {
                            arrayList.close();
                        }
                        Connections.getInstance().unlock(this.conn);
                    }
                }
                tableActionControl = (TableActionControl)actionControl.getChildControls().get(1);
                arrayList = new ArrayList();
                object4 = this.job_arguments.listIterator();
                int n = 0;
                string8 = "";
                while (object4.hasNext()) {
                    object = (JobArgument)object4.next();
                    Integer n2 = ((JobArgument)object).getArgumentPosition();
                    String string9 = ((JobArgument)object).getArgumentName();
                    String string10 = ((JobArgument)object).getArgumentType();
                    String string11 = ((JobArgument)object).getArgumentDefaultValue();
                    String string12 = ((JobArgument)object).getArgumentMetadataAttribute();
                    string8 = this.model.getOperation() != NewJobModel.Operation.CREATE_NEW ? (this.newArgValues != null && this.newArgValues.length > n ? this.newArgValues[n] : "") : "";
                    NamedProgramJobArgumentRow namedProgramJobArgumentRow = new NamedProgramJobArgumentRow(string9, string10, string12, string11, string8);
                    arrayList.add(namedProgramJobArgumentRow);
                    ++n;
                }
                tableActionControl.setRows(arrayList);
            }
            return;
        }
        if (string5.equals("WHAT_JOB_TYPE_PANEL_EXECUTABLE")) {
            if (this.topPanelCtl != null) {
                Object object;
                Object object5;
                String string13;
                Object object6;
                ResultSetWrapper resultSetWrapper;
                this.nameExecCtl.enableUI(true);
                this.nameExecCtl.set(string6);
                this.nameExecCtl.enableUI(false);
                if (Connections.getInstance().lock(this.conn)) {
                    resultSetWrapper = null;
                    try {
                        object6 = new Hashtable<String, String>();
                        object6.put("OBJECT_NAME", this.model.getDBObjectName());
                        string13 = DBUtil.getInstance((Connection)this.conn);
                        string13.setRaiseError(true);
                        object5 = this.getQuery(this.conn, "getJobArgsData");
                        resultSetWrapper = string13.executeOracleQuery((String)object5, (Map)object6);
                        if (resultSetWrapper != null) {
                            object = resultSetWrapper.getResultSet();
                            this.setExecutableArgumentsFromResultSet((ResultSet)object);
                        }
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                    finally {
                        if (resultSetWrapper != null) {
                            resultSetWrapper.close();
                        }
                        Connections.getInstance().unlock(this.conn);
                    }
                }
                resultSetWrapper = new ArrayList();
                object6 = this.job_arguments.listIterator();
                string13 = "";
                while (object6.hasNext()) {
                    object5 = (JobArgument)object6.next();
                    string13 = this.model.getOperation() != NewJobModel.Operation.CREATE_NEW ? (object5 != null ? ((JobArgument)object5).getArgumentNewValue() : "") : "";
                    object = new ExecJobArgumentRow(string13);
                    resultSetWrapper.add(object);
                }
                this.tableExecCtl.setRows(resultSetWrapper);
            }
            return;
        }
        if (string6.equals(NewJobModel.JOB_TYPE_EXECUTABLE)) {
            this.show("EXECUTABLE_CHOICE");
        } else if (string6.equals(NewJobModel.JOB_TYPE_REMOTE_STORED_PROCEDURE)) {
            this.show("EXECUTABLE_CHOICE");
        } else if (string6.equals(NewJobModel.JOB_TYPE_STORED_PROCEDURE)) {
            this.show("STORED_PROCEDURE_CHOICE");
        } else if (string6.equals(NewJobModel.JOB_TYPE_NAMED_PROGRAM)) {
            this.show("NAMED_PROGRAM_CHOICE");
        } else if (string6.equals(NewJobModel.JOB_TYPE_CHAIN) || string6.equals(NewJobModel.JOB_TYPE_SCRIPT) || string6.equals(NewJobModel.JOB_TYPE_PLSQL_BLOCK)) {
            this.show("NOARG_CHOICE");
        }
    }

    private String[] getJobArgumentSplit(String string) {
        QualifiedIdentifier qualifiedIdentifier = new QualifiedIdentifier(string);
        String string2 = qualifiedIdentifier.getUserNameId().getId(false);
        String string3 = qualifiedIdentifier.getObjectNameId().getId(false);
        String[] stringArray = new String[string2 == null ? 1 : 2];
        int n = 0;
        if (string2 != null) {
            stringArray[n++] = string2;
        }
        stringArray[n] = string3;
        return stringArray;
    }

    public void setNumberOfJobArguments(Integer n) {
    }

    public Integer getNumberOfJobArguments() {
        return null;
    }

    public void createEmptyJobArgument() {
        JobArgument jobArgument = this.createJobArgument("", 0, "", "", "");
        this.job_arguments.add(jobArgument);
    }

    private void clearJobArgumentList() {
        this.job_arguments.clear();
    }

    public void setProcedureArgumentsFromResultSet(ResultSet resultSet, List<String> list) throws SQLException {
        this.clearJobArgumentList();
        if (resultSet != null) {
            while (resultSet.next()) {
                String string = this.getStringFromRS(resultSet, "ARGUMENT_NAME");
                int n = this.getIntFromRS(resultSet, "POSITION");
                String string2 = this.getStringFromRS(resultSet, "DATA_TYPE");
                String string3 = this.getStringFromRS(resultSet, "DEFAULT_VALUE");
                String string4 = this.getStringFromRS(resultSet, "IN_OUT");
                this.createJobArgument(string, n, string2, string3, string4);
            }
            this.setNumberOfJobArguments(this.job_arguments.size());
        }
    }

    public List<String> getValuesFromResultSet(ResultSet resultSet) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (resultSet != null) {
            while (resultSet.next()) {
                arrayList.add(this.getStringFromRS(resultSet, "VALUE"));
            }
        }
        return arrayList;
    }

    public void setProgramArgumentsFromResultSet(ResultSet resultSet) throws SQLException {
        this.clearJobArgumentList();
        if (resultSet != null) {
            while (resultSet.next()) {
                this.createNamedProgramJobArgument(this.getStringFromRS(resultSet, "ARGUMENT_NAME"), Integer.valueOf(this.getStringFromRS(resultSet, "ARGUMENT_POSITION")), this.getStringFromRS(resultSet, "ARGUMENT_TYPE"), this.getStringFromRS(resultSet, "DEFAULT_VALUE"), this.getStringFromRS(resultSet, "OUT_ARGUMENT"), this.getStringFromRS(resultSet, "METADATA_ATTRIBUTE"));
            }
            this.setNumberOfJobArguments(this.job_arguments.size());
        }
    }

    public void setExecutableArgumentsFromResultSet(ResultSet resultSet) throws SQLException {
        this.clearJobArgumentList();
        if (resultSet != null) {
            while (resultSet.next()) {
                this.createExecutableJobArgument(this.getStringFromRS(resultSet, "ARGUMENT_NAME"), Integer.valueOf(this.getStringFromRS(resultSet, "ARGUMENT_POSITION")), this.getStringFromRS(resultSet, "ARGUMENT_TYPE"), this.getStringFromRS(resultSet, "VALUE"));
            }
            this.setNumberOfJobArguments(this.job_arguments.size());
        }
    }

    private JobArgument createJobArgument(String string, int n, String string2, String string3, String string4) {
        JobArgument jobArgument = new JobArgument();
        jobArgument.setPosition(n);
        jobArgument.setArgumentName(string);
        jobArgument.setArgumentType(string2);
        jobArgument.setArgumentDefaultValue(string3);
        jobArgument.setArgumentInOut(string4);
        if (n > this.job_arguments.size()) {
            this.job_arguments.add(jobArgument);
        } else {
            this.job_arguments.add(n, jobArgument);
        }
        return jobArgument;
    }

    private void createNamedProgramJobArgument(String string, int n, String string2, String string3, String string4, String string5) {
        JobArgument jobArgument = new JobArgument();
        jobArgument.setPosition(n);
        jobArgument.setArgumentName(string);
        jobArgument.setArgumentType(string2);
        jobArgument.setArgumentDefaultValue(string3);
        jobArgument.setArgumentMetadataAttribute(string5);
        jobArgument.setArgumentInOut(string4);
        this.addJobArgumentList(jobArgument, n);
    }

    private void addJobArgumentList(JobArgument jobArgument, int n) {
        if (n > this.job_arguments.size()) {
            this.job_arguments.add(jobArgument);
        } else {
            this.job_arguments.add(n, jobArgument);
        }
    }

    private void createExecutableJobArgument(String string, int n, String string2, String string3) {
        JobArgument jobArgument = new JobArgument();
        jobArgument.setPosition(n);
        jobArgument.setArgumentName(string);
        jobArgument.setArgumentType(string2);
        jobArgument.setArgumentDefaultValue("");
        jobArgument.setArgumentMetadataAttribute("");
        jobArgument.setArgumentNewValue(string3);
        jobArgument.setArgumentInOut("");
        this.addJobArgumentList(jobArgument, n);
    }

    private String getStringFromRS(ResultSet resultSet, String string) {
        try {
            return resultSet.getString(string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    private int getIntFromRS(ResultSet resultSet, String string) {
        try {
            return resultSet.getInt(string);
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    private long getLongFromRS(ResultSet resultSet, String string) {
        try {
            return resultSet.getLong(string);
        }
        catch (Throwable throwable) {
            return 0L;
        }
    }

    private boolean getBooleanFromRS(ResultSet resultSet, String string) {
        try {
            return resultSet.getBoolean(string);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    protected String getSchedulerGeneratorQuery(Connection connection, String string) {
        String string2 = DBUtil.getDbVersion((Connection)connection).toCanonicalString();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        return dBMSSchedulerCodeGenerator.generate(string2, string, null);
    }

    protected String getSchedulerGeneratorQuery(Connection connection, String string, Map map) {
        String string2 = DBUtil.getDbVersion((Connection)connection).toCanonicalString();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        return dBMSSchedulerCodeGenerator.generate(string2, string, (Map<String, Object>)map);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        try {
            ((JTextComponent)this.nameExecCtl.getUI()).setText(documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength()));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        try {
            ((JTextComponent)this.nameExecCtl.getUI()).setText(documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength()));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        try {
            ((JTextComponent)this.nameExecCtl.getUI()).setText(documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength()));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void initialize(Connection connection) {
        super.initialize(connection);
    }

    public class JobArgument {
        Integer serialIndex = new Integer(0);
        String argument_name = null;
        Integer argument_position = null;
        String argument_type = null;
        String argument_default_value = null;
        String argument_new_value = null;
        String argument_in_out = null;
        String argument_metadata_attribute = null;

        public JobArgument() {
        }

        public JobArgument(Integer n, String string, String string2, String string3, String string4, String string5) {
            this.argument_position = n;
            this.argument_new_value = string;
            this.argument_name = string2;
            this.argument_type = string3;
            this.argument_default_value = string4;
            this.argument_in_out = string5;
        }

        public JobArgument(Integer n, String string, String string2, String string3, String string4, String string5, String string6) {
            this.argument_position = n;
            this.argument_new_value = string;
            this.argument_name = string2;
            this.argument_type = string3;
            this.argument_default_value = string4;
            this.argument_in_out = string5;
            this.argument_metadata_attribute = string6;
        }

        public void setPosition(Integer n) {
            this.argument_position = n;
        }

        public Integer getArgumentPosition() {
            return this.argument_position;
        }

        public void setArgumentNewValue(String string) {
            this.argument_new_value = string;
        }

        public String getArgumentNewValue() {
            return this.argument_new_value;
        }

        public void setArgumentName(String string) {
            this.argument_name = string;
        }

        public String getArgumentName() {
            return this.argument_name;
        }

        public void setArgumentType(String string) {
            this.argument_type = string;
        }

        public String getArgumentType() {
            return this.argument_type;
        }

        public void setArgumentDefaultValue(String string) {
            this.argument_default_value = string;
        }

        public String getArgumentDefaultValue() {
            return this.argument_default_value;
        }

        public void setArgumentInOut(String string) {
            this.argument_in_out = string;
        }

        public String getArgumentInOut() {
            return this.argument_in_out;
        }

        public void setArgumentMetadataAttribute(String string) {
            this.argument_metadata_attribute = string;
        }

        public String getArgumentMetadataAttribute() {
            return this.argument_metadata_attribute;
        }

        public String toString() {
            return "Position=" + this.getArgumentPosition() + ", name=" + this.getArgumentName() + ", type=" + this.getArgumentType() + ", Default_Value=" + this.getArgumentDefaultValue() + ", value=" + this.getArgumentNewValue();
        }

        public void print() {
        }
    }

    private class ExecJobArgumentRowFactory
    implements TableActionControl.RowFactory {
        int rowCount = 1;

        private ExecJobArgumentRowFactory() {
        }

        public TableActionControl.Row createRow(int n, TableActionControl.Row row) {
            ExecJobArgumentRow execJobArgumentRow = null;
            execJobArgumentRow = new ExecJobArgumentRow("null");
            ++this.rowCount;
            return execJobArgumentRow;
        }
    }

    private class ExecJobArgumentRow
    implements TableActionControl.Row {
        private String[] _cols;

        ExecJobArgumentRow(String string) {
            this._cols = new String[]{string};
        }

        String[] getCols() {
            return this._cols;
        }

        public String getValue(int n) {
            return this._cols[n];
        }

        public boolean isValueEditable(int n) {
            return true;
        }

        public void setValue(int n, String string) {
            this._cols[n] = string;
        }
    }

    private class NamedProgramJobArgumentRow
    implements TableActionControl.Row {
        private String[] _cols;

        NamedProgramJobArgumentRow(String string, String string2, String string3, String string4, String string5) {
            String string6 = string4;
            if (string3 != null && string3.trim().length() > 0) {
                string6 = NewJobCreateActionDialogTab_JobArguments.METADATA_ATTRIBUTE_PREFIX + string3;
            }
            this._cols = new String[]{string, string2, string6, string5};
        }

        String[] getCols() {
            return this._cols;
        }

        public String getValue(int n) {
            return this._cols[n];
        }

        public boolean isValueEditable(int n) {
            String string;
            return this._cols == null || !((string = this._cols[1]) != null && string.trim().length() > 0 ? n == 0 || n == 1 || n == 2 : n == 0 || n == 1 || n == 2 || n == 3);
        }

        public void setValue(int n, String string) {
            this._cols[n] = string;
        }
    }

    private class StoredProcedureJobArgumentRow
    implements TableActionControl.Row {
        private String[] _cols;

        StoredProcedureJobArgumentRow(String string, String string2, String string3) {
            this._cols = new String[]{string, string2, string3};
        }

        String[] getCols() {
            return this._cols;
        }

        public String getValue(int n) {
            return this._cols[n];
        }

        public boolean isValueEditable(int n) {
            return n != 0 && n != 1;
        }

        public void setValue(int n, String string) {
            this._cols[n] = string;
        }
    }
}

