/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.dialogs.newjob;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.raptor.datatypes.objects.OraINTERVALDS;
import oracle.dbtools.raptor.ui.actions.ActionValues;
import oracle.dbtools.raptor.ui.actions.ActionValuesLookup;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.dialogs.newjob.NewJobModel;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.QualifiedIdentifier;
import oracle.dbtools.scheduler.panels.schedule.ScheduleWhenModel;

public class NewJobScriptGenerator {
    private HashMap<String, String> attributesDefaults = new HashMap<String, String>(){
        {
            this.put("auto_drop", "FALSE");
            this.put("restartable", "FALSE");
            this.put("job_style", "REGULAR");
            this.put("job_priority", "3");
            this.put("job_weight", "1");
            this.put("parallel_instances", "FALSE");
            this.put("logging_level", "DBMS_SCHEDULER.LOGGING_OFF");
            this.put("stop_on_window_close", "FALSE");
            this.put("follow_default_time_zone", "FALSE");
            this.put("instance_id", null);
            this.put("max_runs", null);
            this.put("store_output", "TRUE");
            this.put("connect_credential_name", null);
            this.put("max_failures", null);
            this.put("max_run_duration", null);
            this.put("schedule_limit", null);
        }
    };
    private Hashtable<String, Integer> raiseEvents = new Hashtable<String, Integer>(){
        {
            this.put("job_started", 1);
            this.put("job_succeeded", 2);
            this.put("job_failed", 4);
            this.put("job_broken", 8);
            this.put("job_completed", 16);
            this.put("job_stopped", 32);
            this.put("job_sch_lim_reached", 64);
            this.put("job_disabled", 128);
            this.put("job_chain_stalled", 256);
        }
    };
    private NewJobModel jobModel;

    public NewJobScriptGenerator(NewJobModel newJobModel) {
        this.jobModel = newJobModel;
    }

    public Map<String, Object> getScriptParams(ActionValues actionValues) {
        String string;
        String string2;
        String string3 = null;
        try {
            string3 = this.jobModel.getDBObjectSchemaName();
            if (string3 == null) {
                string3 = this.jobModel.getSchema();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        String string4 = actionValues.get("JOB_NAME");
        String string5 = actionValues.get("COMMENTS");
        String string6 = actionValues.get("JOB_CLASS");
        if (string6.equals("\"SYS\".\"DEFAULT_JOB_CLASS\"")) {
            string6 = null;
        }
        String string7 = actionValues.get("WHAT_WHEN/WHAT_JOB_TYPE_PANEL_NAME");
        String string8 = actionValues.get("WHAT_WHEN/WHEN_JOB_TYPE_PANEL_NAME", ScheduleWhenModel.Property.REPEAT_INTERVAL.getValueName());
        String string9 = actionValues.get("WHAT_WHEN/WHEN_JOB_TYPE_PANEL_NAME", ScheduleWhenModel.Property.START_DATE.getValueName());
        String string10 = actionValues.get("WHAT_WHEN/WHEN_JOB_TYPE_PANEL_NAME", ScheduleWhenModel.Property.END_DATE.getValueName());
        String string11 = actionValues.get("WHAT_WHEN/WHEN_JOB_TYPE_PANEL_NAME", ScheduleWhenModel.Property.EVENT_CONDITION.getValueName());
        String string12 = actionValues.get("WHAT_WHEN/WHEN_JOB_TYPE_PANEL_NAME", ScheduleWhenModel.QUEUE_SPEC);
        String string13 = actionValues.get("WHAT_WHEN/WHEN_JOB_TYPE_PANEL_NAME", ScheduleWhenModel.SCHEDULE_SPEC);
        if (string11 != null && string11.length() == 0) {
            string11 = null;
        }
        if (string10 != null && string10.length() == 0) {
            string10 = null;
        }
        if (string9 != null && string9.length() == 0) {
            string9 = null;
        }
        if (string8 != null && string8.length() == 0) {
            string8 = null;
        }
        if (string12 != null && string12.length() == 0) {
            string12 = null;
        }
        if (string13 != null && string13.length() == 0) {
            string13 = null;
        }
        TreeMap<String, Boolean> treeMap = new TreeMap<String, Boolean>();
        String string14 = this.getCredential(string7, actionValues);
        String string15 = this.getConnectCredential(actionValues);
        String string16 = this.getDestination(string7, actionValues);
        String string17 = this.getJobArgumentName(string7, (ActionValuesLookup)actionValues);
        String[] stringArray = this.getJobArguments(string7, actionValues);
        int n = 0;
        if (stringArray != null) {
            n = stringArray.length;
        }
        if ((string2 = this.getNotificationRecipients(actionValues)) != null) {
            string2 = string2.trim();
        }
        if ((string = this.getNotificationSender(actionValues)) == null) {
            treeMap.put("sender", new Boolean(true));
        } else {
            treeMap.put("sender", new Boolean(false));
        }
        String string18 = this.getNotificationBody(actionValues);
        String string19 = this.getNotificationSubject(actionValues);
        String string20 = this.getNotificationSelectedEvents(actionValues);
        String string21 = this.getNotificationFilterCondition(actionValues);
        if (string21 == null) {
            treeMap.put("filter_condition", new Boolean(true));
        } else {
            treeMap.put("filter_condition", new Boolean(false));
        }
        String string22 = this.getPropertyAutoDrop(actionValues);
        String string23 = this.getPropertyRestartable(actionValues);
        String string24 = this.getPropertyStoreOutput(actionValues);
        String string25 = this.getPropertyJobStyle(actionValues);
        String string26 = this.getPropertyJobPriority(actionValues);
        String string27 = this.getPropertyJobWeight(actionValues);
        String string28 = this.getPropertyParallelInstances(actionValues);
        String string29 = this.getPropertyLoggingLevel(actionValues);
        String string30 = this.getPropertyStopOnWindowClose(actionValues);
        String string31 = this.getPropertyFollowDefaultTimeZone(actionValues);
        String string32 = this.getPropertyInstanceID(actionValues);
        String string33 = this.getPropertyMaxRuns(actionValues);
        String string34 = this.getPropertyMaxRunDuration(actionValues);
        String string35 = this.getPropertyScheduleLimit(actionValues);
        String string36 = this.getPropertyMaxFailures(actionValues);
        int n2 = this.getPropertyRaiseEvents(actionValues);
        TreeMap<String, Boolean> treeMap2 = new TreeMap<String, Boolean>();
        treeMap2.put("auto_drop", !string22.equals(this.attributesDefaults.get("auto_drop")));
        treeMap2.put("restartable", !string23.equals(this.attributesDefaults.get("restartable")));
        treeMap2.put("job_style", !string25.equals(this.attributesDefaults.get("job_style")));
        treeMap2.put("job_priority", !string26.equals(this.attributesDefaults.get("job_priority")));
        treeMap2.put("job_weight", !this.checkequals(string27, this.attributesDefaults.get("job_weight")));
        if (string24 != null) {
            treeMap2.put("store_output", !string24.equals(this.attributesDefaults.get("store_ouput")));
        }
        if (!this.checkequals(string15, this.attributesDefaults.get("connect_credential_name"))) {
            treeMap2.put("connect_credential_name", new Boolean(true));
            if (string15 == null) {
                treeMap.put("connect_credential_name", new Boolean(true));
            }
        }
        if (string28 != null) {
            treeMap2.put("parallel_instances", !string28.equals(this.attributesDefaults.get("parallel_instances")));
        }
        treeMap2.put("stop_on_window_close", !string30.equals(this.attributesDefaults.get("stop_on_window_close")));
        if (string31 != null) {
            treeMap2.put("follow_default_timezone", !string31.equals(this.attributesDefaults.get("follow_default_time_zone")));
        }
        if (!this.checkequals(string32, this.attributesDefaults.get("instance_id"))) {
            treeMap2.put("instance_id", new Boolean(true));
            if (string32 == null) {
                treeMap.put("instance_id", new Boolean(true));
            }
        }
        if (!this.checkequals(string33, this.attributesDefaults.get("max_runs"))) {
            treeMap2.put("max_runs", new Boolean(true));
            if (string33 == null) {
                treeMap.put("max_runs", new Boolean(true));
            }
        }
        if (!this.checkequals(string36, this.attributesDefaults.get("max_failures"))) {
            treeMap2.put("max_failures", new Boolean(true));
            if (string36 == null) {
                treeMap.put("max_failures", new Boolean(true));
            }
        }
        if (!this.checkequals(string34, this.attributesDefaults.get("max_run_duration"))) {
            treeMap2.put("max_run_duration", new Boolean(true));
            if (string34 == null) {
                treeMap.put("max_run_duration", new Boolean(true));
            } else {
                treeMap.put("max_run_duration", new Boolean(false));
            }
        } else {
            treeMap2.put("max_run_duration", new Boolean(false));
        }
        if (!this.checkequals(string35, this.attributesDefaults.get("schedule_limit"))) {
            treeMap2.put("schedule_limit", new Boolean(true));
            if (string35 == null) {
                treeMap.put("schedule_limit", new Boolean(true));
            }
        }
        if (n2 != 0) {
            treeMap2.put("raise_events", new Boolean(true));
        }
        TreeMap<String, Object> treeMap3 = new TreeMap<String, Object>();
        treeMap3.put("name", string4);
        treeMap3.put("owner", string3);
        if (string5 != null) {
            treeMap3.put("comments", string5.replaceAll("'", "''"));
        } else {
            treeMap3.put("comments", string5);
        }
        treeMap3.put("job_class", string6);
        treeMap3.put("job_type", this.getJobType(string7, actionValues));
        String string37 = this.getJobAction(string7, actionValues);
        if (string37 != null) {
            treeMap3.put("job_action", string37.replaceAll("'", "''"));
        } else {
            treeMap3.put("job_action", string37);
        }
        treeMap3.put("program_name", this.getProgramName(string7, actionValues));
        treeMap3.put("number_of_arguments", n);
        treeMap3.put("event_condition", this.wrapQuotes(string11));
        treeMap3.put("end_date", string10);
        treeMap3.put("start_date", string9);
        treeMap3.put("queue_spec", string12);
        treeMap3.put("repeat_interval", string8);
        treeMap3.put("credential_name", string14);
        treeMap3.put("destination_name", string16);
        treeMap3.put("auto_drop", string22);
        treeMap3.put("restartable", string23);
        treeMap3.put("job_style", string25);
        treeMap3.put("job_priority", string26);
        treeMap3.put("job_weight", string27);
        treeMap3.put("parallel_instances", string28);
        treeMap3.put("logging_level", string29);
        treeMap3.put("stop_on_window_close", string30);
        treeMap3.put("follow_default_timezone", string31);
        treeMap3.put("instance_id", string32);
        treeMap3.put("max_runs", string33);
        treeMap3.put("store_output", string24);
        treeMap3.put("connect_credential_name", string15);
        treeMap3.put("max_failures", string36);
        treeMap3.put("max_run_duration", string34);
        treeMap3.put("schedule_limit", string35);
        treeMap3.put("raise_events", n2);
        treeMap3.put("recipients", string2);
        treeMap3.put("sender", string);
        treeMap3.put("subject", string19);
        treeMap3.put("body", string18);
        treeMap3.put("events", string20);
        treeMap3.put("filter_condition", string21);
        treeMap3.put("schedule_spec", string13);
        hashtable.put("model", treeMap3);
        hashtable.put("changes", treeMap2);
        hashtable.put("isnull", treeMap);
        return hashtable;
    }

    public String getScript(ActionValues actionValues) {
        return this.getScript(actionValues, this.getScriptParams(actionValues));
    }

    protected String getScript(ActionValues actionValues, Map<String, Object> map) {
        Object object;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        Map map2 = (Map)map.get("model");
        String string6 = actionValues.get("WHAT_WHEN/WHAT_JOB_TYPE_PANEL_NAME");
        String string7 = actionValues.get("WHAT_WHEN/WHEN_JOB_TYPE_PANEL_NAME", ScheduleWhenModel.Property.EVENT_TYPE.getValueName());
        ScheduleWhenModel.EventType eventType = string7 != null ? ScheduleWhenModel.EventType.valueOf(string7) : null;
        String[] stringArray = this.getJobArguments(this.getJobWhatFromAC(actionValues), actionValues);
        String string8 = (String)map2.get("recipients");
        boolean bl = new Boolean(actionValues.get("ENABLED"));
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        String string9 = dBMSSchedulerCodeGenerator.generate(string5 = this.jobModel.getDBVersion(), string4 = this.getDBMSSchedulerCreateJobCodeGeneratorOption(string6, eventType), map);
        String string10 = string9.trim();
        if (string10.endsWith("END;")) {
            string10 = string10.substring(0, string10.length() - 4);
        } else if (string10.endsWith("END")) {
            string10 = string10.substring(0, string10.length() - 3);
        }
        if (stringArray != null && stringArray.length > 0) {
            string3 = "JOB_CREATE_SET_ARGUMENT_BY_POSITION";
            for (int i = 0; i < stringArray.length; ++i) {
                string = string2 = stringArray[i];
                object = new Integer(i + 1);
                if (string == null || string.length() <= 0) continue;
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                hashtable.put("argument_value", string);
                hashtable.put("argument_position", object);
                TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
                treeMap.put("args", hashtable);
                treeMap.put("model", map2);
                String string11 = dBMSSchedulerCodeGenerator.generate(string5, string3, treeMap);
                string10 = string10 + "\n" + string11;
            }
        }
        if ((string3 = dBMSSchedulerCodeGenerator.generate(string5, "CREATE_JOB_DESTINATION_CREDENTIAL", map)) != null) {
            string10 = string10 + "\n" + string3;
        }
        String string12 = this.getDBMSSchedulerCreateJobAttributeCodeGeneratorOption();
        string2 = dBMSSchedulerCodeGenerator.generate(string5, string12, map);
        string10 = string10 + "\n" + string2;
        if (string8 != null && string8.length() > 0) {
            string = this.getDBMSSchedulerCreateJobEmailNotificationCodeGenertorOption();
            object = dBMSSchedulerCodeGenerator.generate(string5, string, map);
            string10 = string10 + "\n" + (String)object;
        }
        if (bl) {
            string = this.getDBMSSchedulerCreateJobExplicitEnableCodeGenertorOption();
            object = dBMSSchedulerCodeGenerator.generate(string5, string, map);
            string10 = string10 + "\n" + (String)object;
        }
        string10 = string10 + "\nEND;\n";
        return string10;
    }

    public String getSummary(ActionValues actionValues) {
        return this.getSummary(actionValues, this.getScriptParams(actionValues));
    }

    protected String getSummary(ActionValues actionValues, Map<String, Object> map) {
        Map map2 = (Map)map.get("model");
        String string = actionValues.get("WHAT_WHEN/WHAT_JOB_TYPE_PANEL_NAME");
        String string2 = actionValues.get("WHAT_WHEN/WHEN_JOB_TYPE_PANEL_NAME", ScheduleWhenModel.Property.EVENT_TYPE.getValueName());
        ActionValuesLookup actionValuesLookup = actionValues.getTabLookup("job_destination_panel");
        String string3 = actionValuesLookup != null ? actionValuesLookup.get("WHERE_TOP_PANEL/DESTINATION_EXEC_CARDPANEL_NAME") : null;
        boolean bl = new Boolean(actionValues.get("ENABLED"));
        String string4 = this.getPropertyAutoDrop(actionValues);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.formatSummaryProp(false, SchedulerArb.getString("JOB_CREATE_DETAILS_JOB_NAME_LABEL"), (String)map2.get("name")));
        stringBuilder.append(this.formatSummaryProp(true, SchedulerArb.getString("JOB_CREATE_DETAILS_ENABLED_LABEL"), Boolean.toString(bl)));
        stringBuilder.append(this.formatSummaryProp(true, SchedulerArb.getString("JOB_CREATE_DETAILS_DESCRIPTION_LABEL"), (String)map2.get("comments")));
        stringBuilder.append(this.formatSummaryProp(true, SchedulerArb.getString("JOB_CREATE_DETAILS_JOB_CLASS_LABEL"), (String)map2.get("job_class")));
        stringBuilder.append(this.formatSummaryProp(true, SchedulerArb.getString("JOB_CREATE_DETAILS_WHAT_PANEL_TITLE"), string));
        stringBuilder.append(this.formatSummaryProp(true, SchedulerArb.getString("JOB_CREATE_DETAILS_WHEN_PANEL_TITLE"), string2));
        if (string3 != null) {
            stringBuilder.append(this.formatSummaryProp(true, SchedulerArb.getString("JOB_CREATE_TAB_DESTINATION"), string3));
        }
        stringBuilder.append(this.formatSummaryProp(true, SchedulerArb.getString("JOB_CREATE_PROPERTIES_AUTODROP_LABEL"), Boolean.toString(Boolean.parseBoolean(string4))));
        return stringBuilder.toString();
    }

    protected String formatSummaryProp(boolean bl, String string, String string2) {
        String string3 = bl ? "\n" : "";
        return string3 + string + " - " + string2;
    }

    private void printSet(Set<String> set, String string) {
    }

    private String getDBMSSchedulerCreateJobCodeGeneratorOption(String string, ScheduleWhenModel.EventType eventType) {
        String string2 = NewJobModel.JOB_TYPE_PLSQL_BLOCK;
        String string3 = NewJobModel.JOB_TYPE_CHAIN;
        String string4 = NewJobModel.JOB_TYPE_STORED_PROCEDURE;
        String string5 = NewJobModel.JOB_TYPE_REMOTE_STORED_PROCEDURE;
        String string6 = NewJobModel.JOB_TYPE_NAMED_PROGRAM;
        String string7 = NewJobModel.JOB_TYPE_EXECUTABLE;
        String string8 = NewJobModel.JOB_TYPE_SCRIPT;
        if (eventType != null && string != null) {
            if (string.equals(string6)) {
                switch (eventType.getScheduleType()) {
                    case NAMED: 
                    case WINDOW: 
                    case WINDOW_GROUP: {
                        return "CREATE_JOB_PROG_AND_SCHEDULE";
                    }
                    case IMMEDIATE: 
                    case ONCE: 
                    case CALENDAR: {
                        return "CREATE_JOB_PROG_AND_INLINE_SCHEDULE";
                    }
                    case EVENT: {
                        return "CREATE_JOB_PROG_AND_EVENT";
                    }
                }
            } else if (string.equals(string3) || string.equals(string2) || string.equals(string4) || string.equals(string5) || string.equals(string7) || string.equals(string8)) {
                switch (eventType.getScheduleType()) {
                    case NAMED: 
                    case WINDOW: 
                    case WINDOW_GROUP: {
                        return "CREATE_JOB_INLINE_PROG_AND_SCHEDULE";
                    }
                    case IMMEDIATE: 
                    case ONCE: 
                    case CALENDAR: {
                        return "CREATE_JOB_BASIC";
                    }
                    case EVENT: {
                        return "CREATE_JOB_INLINE_PROG_AND_EVENT";
                    }
                }
            }
        }
        return null;
    }

    private String getDBMSSchedulerCreateJobAttributeCodeGeneratorOption() {
        return "JOB_CREATE_SET_ATTRIBUTES";
    }

    private String getDBMSSchedulerCreateJobExplicitEnableCodeGenertorOption() {
        return "JOB_CREATE_SET_ATTRIBUTES_EXPLICIT_ENABLE";
    }

    private String getJobAction(String string, ActionValues actionValues) {
        if (string.equals(NewJobModel.JOB_TYPE_PLSQL_BLOCK)) {
            return actionValues.get("WHAT_WHEN/WHAT_JOB_TYPE_PANEL_NAME/WHAT_PANEL/WHAT_JOB_TYPE_PANEL_PLSQL_BLOCK");
        }
        if (string.equals(NewJobModel.JOB_TYPE_EXECUTABLE)) {
            return actionValues.get("WHAT_WHEN/WHAT_JOB_TYPE_PANEL_NAME/WHAT_EXECUTABLE_PANEL/WHAT_JOB_TYPE_PANEL_EXECUTABLE");
        }
        if (string.equals(NewJobModel.JOB_TYPE_SCRIPT)) {
            return actionValues.get("WHAT_WHEN/WHAT_JOB_TYPE_PANEL_NAME/WHAT_SCRIPT_PANEL/WHAT_JOB_TYPE_PANEL_SCRIPT");
        }
        if (string.equals(NewJobModel.JOB_TYPE_STORED_PROCEDURE)) {
            String string2 = actionValues.get("WHAT_WHEN/WHAT_JOB_TYPE_PANEL_NAME/WHAT_STORED_PROCEDURE_PANEL/WHAT_JOB_TYPE_PANEL_STORED_PROCEDURE_SCHEMA");
            String string3 = actionValues.get("WHAT_WHEN/WHAT_JOB_TYPE_PANEL_NAME/WHAT_STORED_PROCEDURE_PANEL/WHAT_JOB_TYPE_PANEL_STORED_PROCEDURE");
            return this.makeIdentifier(string2, string3);
        }
        if (string.equals(NewJobModel.JOB_TYPE_REMOTE_STORED_PROCEDURE)) {
            return actionValues.get("WHAT_WHEN/WHAT_JOB_TYPE_PANEL_NAME/WHAT_REMOTE_STORED_PROCEDURE_PANEL/REMOTE_STORED_PROCEDURE");
        }
        if (string.equals(NewJobModel.JOB_TYPE_CHAIN)) {
            return actionValues.get("WHAT_WHEN/WHAT_JOB_TYPE_PANEL_NAME/WHAT_CHAIN_PANEL/WHAT_JOB_TYPE_PANEL_CHAIN");
        }
        return null;
    }

    private String getJobType(String string, ActionValues actionValues) {
        if (string == null) {
            return null;
        }
        if (string.equals(NewJobModel.JOB_TYPE_PLSQL_BLOCK)) {
            return "PLSQL_BLOCK";
        }
        if (string.equals(NewJobModel.JOB_TYPE_EXECUTABLE)) {
            return "EXECUTABLE";
        }
        if (string.equals(NewJobModel.JOB_TYPE_SCRIPT)) {
            return this.getScriptType(string, actionValues);
        }
        if (string.equals(NewJobModel.JOB_TYPE_STORED_PROCEDURE)) {
            return "STORED_PROCEDURE";
        }
        if (string.equals(NewJobModel.JOB_TYPE_REMOTE_STORED_PROCEDURE)) {
            return "STORED_PROCEDURE";
        }
        if (string.equals(NewJobModel.JOB_TYPE_CHAIN)) {
            return "CHAIN";
        }
        if (string.equals(NewJobModel.JOB_TYPE_NAMED_PROGRAM)) {
            return null;
        }
        return null;
    }

    private String getProgramName(String string, ActionValues actionValues) {
        if (string.equals(NewJobModel.JOB_TYPE_NAMED_PROGRAM)) {
            String string2 = actionValues.get("WHAT_WHEN/WHAT_JOB_TYPE_PANEL_NAME/WHAT_NAME_PROGRAM_PANEL/WHAT_JOB_TYPE_PANEL_NAMED_PROGRAM");
            return string2;
        }
        return null;
    }

    private String getScriptType(String string, ActionValues actionValues) {
        if (string.equals(NewJobModel.JOB_TYPE_SCRIPT)) {
            String string2 = actionValues.get("WHAT_WHEN/WHAT_JOB_TYPE_PANEL_NAME/WHAT_SCRIPT_PANEL/WHAT_JOB_TYPE_PANEL_SCRIPT_TYPE");
            if (string2.equals(NewJobModel.SCRIPT_TYPE_SQLPLUS)) {
                return "SQL_SCRIPT";
            }
            if (string2.equals(NewJobModel.SCRIPT_TYPE_BACKUP)) {
                return "BACKUP_SCRIPT";
            }
            if (string2.equals(NewJobModel.SCRIPT_TYPE_EXTERNAL)) {
                return "EXTERNAL_SCRIPT";
            }
        }
        return null;
    }

    private String[] getJobArguments(String string, ActionValues actionValues) {
        String[] stringArray = null;
        ActionValuesLookup actionValuesLookup = actionValues.getTabLookup("job_arguments_panel");
        if (string.equals(NewJobModel.JOB_TYPE_NAMED_PROGRAM)) {
            String string2;
            Iterator iterator;
            List list = actionValuesLookup.getList("JOB_ARGUMENT_PANEL/JOB_ARGUMENT_PANEL_PROGRAM/NAMED_PROGRAM_TABLE", SchedulerArb.getString("JOB_CREATE_JOB_ARGUMENT_PROGRAM_ARG_TABLE_COLUMN_ARGNAME_LABEL"));
            List list2 = actionValuesLookup.getList("JOB_ARGUMENT_PANEL/JOB_ARGUMENT_PANEL_PROGRAM/NAMED_PROGRAM_TABLE", SchedulerArb.getString("JOB_CREATE_JOB_ARGUMENT_PROGRAM_ARG_TABLE_COLUMN_ARGDEFAULTVALUE_LABEL"));
            List list3 = actionValuesLookup.getList("JOB_ARGUMENT_PANEL/JOB_ARGUMENT_PANEL_PROGRAM/NAMED_PROGRAM_TABLE", SchedulerArb.getString("JOB_CREATE_JOB_ARGUMENT_PROGRAM_ARG_TABLE_COLUMN_ARGTYPE_LABEL"));
            List list4 = actionValuesLookup.getList("JOB_ARGUMENT_PANEL/JOB_ARGUMENT_PANEL_PROGRAM/NAMED_PROGRAM_TABLE", SchedulerArb.getString("JOB_CREATE_JOB_ARGUMENT_PROGRAM_ARG_TABLE_COLUMN_ARGNEWVALUE_LABEL"));
            if (list != null && (iterator = list.iterator()) != null) {
                while (iterator.hasNext()) {
                    string2 = (String)iterator.next();
                }
            }
            if (list2 != null && (iterator = list2.iterator()) != null) {
                while (iterator.hasNext()) {
                    string2 = (String)iterator.next();
                }
            }
            if (list3 != null && (iterator = list3.iterator()) != null) {
                while (iterator.hasNext()) {
                    string2 = (String)iterator.next();
                }
            }
            if (list4 != null && (iterator = list4.iterator()) != null) {
                stringArray = new String[list4.size()];
                int n = 0;
                while (iterator.hasNext()) {
                    String string3;
                    stringArray[n] = string3 = (String)iterator.next();
                    ++n;
                }
            }
            return stringArray;
        }
        if (string.equals(NewJobModel.JOB_TYPE_EXECUTABLE) || string.equals(NewJobModel.JOB_TYPE_REMOTE_STORED_PROCEDURE)) {
            List list = actionValuesLookup.getList("JOB_ARGUMENT_PANEL/JOB_ARGUMENT_PANEL_EXECUTABLE/EXECUTABLE_TABLE", SchedulerArb.getString("JOB_CREATE_JOB_ARGUMENT_PROGRAM_ARG_TABLE_COLUMN_ARGNEWVALUE_LABEL"));
            if (list != null) {
                Iterator iterator = list.iterator();
                stringArray = new String[list.size()];
                int n = 0;
                while (iterator.hasNext()) {
                    String string4;
                    stringArray[n] = string4 = (String)iterator.next();
                    ++n;
                }
            }
            return stringArray;
        }
        if (string.equals(NewJobModel.JOB_TYPE_STORED_PROCEDURE)) {
            List list = actionValuesLookup.getList("JOB_ARGUMENT_PANEL/JOB_ARGUMENT_PANEL_STORED_PROCEDURE/STORED_PROCEDURE_TABLE", SchedulerArb.getString("JOB_CREATE_JOB_ARGUMENT_PROGRAM_ARG_TABLE_COLUMN_ARGNEWVALUE_LABEL"));
            if (list != null) {
                Iterator iterator = list.iterator();
                stringArray = new String[list.size()];
                int n = 0;
                while (iterator.hasNext()) {
                    String string5;
                    stringArray[n] = string5 = (String)iterator.next();
                    ++n;
                }
            }
            return stringArray;
        }
        return null;
    }

    private String getJobArgumentName(String string, ActionValuesLookup actionValuesLookup) {
        if (string.equals(NewJobModel.JOB_TYPE_NAMED_PROGRAM)) {
            String string2 = actionValuesLookup.get("JOB_ARGUMENT_PANEL/JOB_ARGUMENT_PANEL_PROGRAM/NAMED_PROGRAM_NAME");
            return string2;
        }
        if (string.equals(NewJobModel.JOB_TYPE_EXECUTABLE)) {
            String string3 = actionValuesLookup.get("JOB_ARGUMENT_PANEL/JOB_ARGUMENT_PANEL_EXECUTABLE/EXECUTABLE_NAME");
            return string3;
        }
        if (string.equals(NewJobModel.JOB_TYPE_STORED_PROCEDURE)) {
            String string4 = actionValuesLookup.get("JOB_ARGUMENT_PANEL/JOB_ARGUMENT_PANEL_STORED_PROCEDURE/STORED_PROCEDURE_NAME");
            return string4;
        }
        if (string.equals(NewJobModel.JOB_TYPE_REMOTE_STORED_PROCEDURE)) {
            String string5 = actionValuesLookup.get("JOB_ARGUMENT_PANEL/JOB_ARGUMENT_PANEL_STORED_PROCEDURE/STORED_PROCEDURE_NAME");
            return string5;
        }
        return null;
    }

    private String getNotificationRecipients(ActionValues actionValues) {
        ActionValuesLookup actionValuesLookup = actionValues.getTabLookup("job_email_notification_panel");
        if (actionValuesLookup == null) {
            return null;
        }
        String string = actionValuesLookup.get("NOTIFICATION_RECIPIENTS");
        if (string != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        return string;
    }

    private String getNotificationSender(ActionValues actionValues) {
        ActionValuesLookup actionValuesLookup = actionValues.getTabLookup("job_email_notification_panel");
        if (actionValuesLookup == null) {
            return null;
        }
        String string = actionValuesLookup.get("NOTIFICATION_SENDER");
        if (string != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        return string;
    }

    private String getNotificationSubject(ActionValues actionValues) {
        ActionValuesLookup actionValuesLookup = actionValues.getTabLookup("job_email_notification_panel");
        if (actionValuesLookup == null) {
            return null;
        }
        String string = actionValuesLookup.get("NOTIFICATION_SUBJECT");
        if (string != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        return string;
    }

    private String getNotificationBody(ActionValues actionValues) {
        ActionValuesLookup actionValuesLookup = actionValues.getTabLookup("job_email_notification_panel");
        if (actionValuesLookup == null) {
            return null;
        }
        String string = actionValuesLookup.get("NOTIFICATION_BODY");
        if (string != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        return string;
    }

    private String getNotificationSelectedEvents(ActionValues actionValues) {
        ActionValuesLookup actionValuesLookup = actionValues.getTabLookup("job_email_notification_panel");
        if (actionValuesLookup == null) {
            return null;
        }
        List list = actionValuesLookup.getList("NOTIFICATION_SELECT_EVENTS", "selected");
        Iterator iterator = list.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next() + ", ");
        }
        String string = stringBuffer.toString().trim();
        string = string.substring(0, string.length() - 1);
        return string;
    }

    private String getNotificationFilterCondition(ActionValues actionValues) {
        ActionValuesLookup actionValuesLookup = actionValues.getTabLookup("job_email_notification_panel");
        if (actionValuesLookup == null) {
            return null;
        }
        String string = actionValuesLookup.get("NOTIFICATION_FILTER_CONDITION");
        if (string != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        return string;
    }

    private String getCredential(String string, ActionValues actionValues) {
        String string2 = null;
        ActionValuesLookup actionValuesLookup = actionValues.getTabLookup("job_destination_panel");
        if (actionValuesLookup == null) {
            return null;
        }
        String string3 = actionValues.get("WHAT_WHEN/WHAT_JOB_TYPE_PANEL_NAME/WHAT_SCRIPT_PANEL/WHAT_JOB_TYPE_PANEL_SCRIPT_TYPE");
        if (string3 == null) {
            string3 = "";
        }
        String string4 = actionValuesLookup.get("WHERE_TOP_PANEL/DESTINATION_EXEC_CARDPANEL_NAME");
        String string5 = actionValuesLookup.get("WHERE_TOP_PANEL/DESTINATION_NONEXEC_CARDPANEL_NAME");
        String string6 = actionValuesLookup.get("WHERE_TOP_PANEL/DESTINATION_SCRIPT_CARDPANEL_NAME");
        if (string.equals(NewJobModel.JOB_TYPE_EXECUTABLE) || string3.equals(NewJobModel.SCRIPT_TYPE_EXTERNAL)) {
            if (string4.equals(NewJobModel.JOB_WHERE_LOCAL)) {
                string2 = actionValuesLookup.get("WHERE_TOP_PANEL/DESTINATION_EXEC_CARDPANEL_NAME/JOB_WHERES_EXEC_LOCAL_CRED");
            } else if (string4.equals(NewJobModel.JOB_WHERE_REMOTE)) {
                string2 = actionValuesLookup.get("WHERE_TOP_PANEL/DESTINATION_EXEC_CARDPANEL_NAME/JOB_WHERES_EXEC_REMOTE_CRED");
            } else if (string4.equals(NewJobModel.JOB_WHERE_MULTIPLE)) {
                string2 = actionValuesLookup.get("WHERE_TOP_PANEL/DESTINATION_EXEC_CARDPANEL_NAME/JOB_WHERES_EXEC_MULTIPLE_CRED");
            }
            if (string2 != null && (string2.equals("") || string2.equals("\"\""))) {
                return null;
            }
            return string2;
        }
        if (string.equals(NewJobModel.JOB_TYPE_SCRIPT)) {
            if (string6.equals(NewJobModel.JOB_WHERE_LOCAL)) {
                string2 = actionValuesLookup.get("WHERE_TOP_PANEL/DESTINATION_SCRIPT_CARDPANEL_NAME/WHERE_LOCAL_PANEL/JOB_WHERES_EXEC_LOCAL_CRED");
            } else if (string6.equals(NewJobModel.JOB_WHERE_REMOTE)) {
                string2 = actionValuesLookup.get("WHERE_TOP_PANEL/DESTINATION_SCRIPT_CARDPANEL_NAME/WHERE_REMOTE_PANEL/JOB_WHERES_REMOTE_CRED");
            } else if (string4.equals(NewJobModel.JOB_WHERE_MULTIPLE)) {
                string2 = actionValuesLookup.get("WHERE_TOP_PANEL/DESTINATION_SCRIPT_CARDPANEL_NAME/WHERE_MULTIPLE_PANEL/JOB_WHERES_MULTIPLE_CRED");
            }
            if (string2 != null && (string2.equals("") || string2.equals("\"\""))) {
                return null;
            }
            return string2;
        }
        if (string5.equals(NewJobModel.JOB_WHERE_REMOTE)) {
            string2 = actionValuesLookup.get("WHERE_TOP_PANEL/DESTINATION_NONEXEC_CARDPANEL_NAME/WHERE_REMOTE_PANEL/JOB_WHERES_REMOTE_CRED");
        } else if (string5.equals(NewJobModel.JOB_WHERE_MULTIPLE)) {
            string2 = actionValuesLookup.get("WHERE_TOP_PANEL/DESTINATION_NONEXEC_CARDPANEL_NAME/WHERE_MULTIPLE_PANEL/JOB_WHERES_MULTIPLE_CRED");
        }
        if (string2 != null && (string2.equals("") || string2.equals("\"\""))) {
            return null;
        }
        return string2;
    }

    private String getConnectCredential(ActionValues actionValues) {
        String string = null;
        ActionValuesLookup actionValuesLookup = actionValues.getTabLookup("job_destination_panel");
        if (actionValuesLookup == null) {
            return null;
        }
        String string2 = actionValuesLookup.get("WHERE_TOP_PANEL/DESTINATION_SCRIPT_CARDPANEL_NAME");
        if (string2 == null) {
            return null;
        }
        if (string2.equals(NewJobModel.JOB_WHERE_LOCAL)) {
            string = actionValuesLookup.get("WHERE_TOP_PANEL/DESTINATION_SCRIPT_CARDPANEL_NAME/WHERE_LOCAL_PANEL/CONNECT_CREDENTIAL_NAME");
        } else if (string2.equals(NewJobModel.JOB_WHERE_REMOTE)) {
            string = actionValuesLookup.get("WHERE_TOP_PANEL/DESTINATION_SCRIPT_CARDPANEL_NAME/WHERE_REMOTE_PANEL/CONNECT_CREDENTIAL_NAME");
        } else if (string2.equals(NewJobModel.JOB_WHERE_MULTIPLE)) {
            string = actionValuesLookup.get("WHERE_TOP_PANEL/DESTINATION_SCRIPT_CARDPANEL_NAME/WHERE_MULTIPLE_PANEL/CONNECT_CREDENTIAL_NAME");
        }
        if (string != null && (string.equals("") || string.equals("\"\""))) {
            return null;
        }
        return string;
    }

    private String getDestination(String string, ActionValues actionValues) {
        String string2 = null;
        ActionValuesLookup actionValuesLookup = actionValues.getTabLookup("job_destination_panel");
        if (actionValuesLookup == null) {
            return null;
        }
        String string3 = actionValues.get("WHAT_WHEN/WHAT_JOB_TYPE_PANEL_NAME/WHAT_SCRIPT_PANEL/WHAT_JOB_TYPE_PANEL_SCRIPT_TYPE");
        if (string3 == null) {
            string3 = "";
        }
        String string4 = actionValuesLookup.get("WHERE_TOP_PANEL/DESTINATION_EXEC_CARDPANEL_NAME");
        String string5 = actionValuesLookup.get("WHERE_TOP_PANEL/DESTINATION_NONEXEC_CARDPANEL_NAME");
        String string6 = actionValuesLookup.get("WHERE_TOP_PANEL/DESTINATION_SCRIPT_CARDPANEL_NAME");
        if (string.equals(NewJobModel.JOB_TYPE_EXECUTABLE) || string3.equals(NewJobModel.SCRIPT_TYPE_EXTERNAL)) {
            if (string4.equals(NewJobModel.JOB_WHERE_LOCAL)) {
                string2 = null;
            } else if (string4.equals(NewJobModel.JOB_WHERE_REMOTE)) {
                string2 = actionValuesLookup.get("WHERE_TOP_PANEL/DESTINATION_EXEC_CARDPANEL_NAME/JOB_WHERES_EXEC_REMOTE_DEST");
            } else if (string4.equals(NewJobModel.JOB_WHERE_MULTIPLE)) {
                string2 = actionValuesLookup.get("WHERE_TOP_PANEL/DESTINATION_EXEC_CARDPANEL_NAME/JOB_WHERES_EXEC_MULTIPLE_DEST");
            }
            if (string2 != null && (string2.equals("") || string2.equals("\"\""))) {
                return null;
            }
            return string2;
        }
        if (string.equals(NewJobModel.JOB_TYPE_SCRIPT)) {
            if (string6.equals(NewJobModel.JOB_WHERE_LOCAL)) {
                string2 = null;
            } else if (string6.equals(NewJobModel.JOB_WHERE_REMOTE)) {
                string2 = actionValuesLookup.get("WHERE_TOP_PANEL/DESTINATION_SCRIPT_CARDPANEL_NAME/WHERE_REMOTE_PANEL/JOB_WHERES_REMOTE_DEST");
            } else if (string6.equals(NewJobModel.JOB_WHERE_MULTIPLE)) {
                string2 = actionValuesLookup.get("WHERE_TOP_PANEL/DESTINATION_SCRIPT_CARDPANEL_NAME/WHERE_MULTIPLE_PANEL/JOB_WHERES_MULTIPLE_DEST");
            }
            if (string2 != null && (string2.equals("") || string2.equals("\"\""))) {
                return null;
            }
            return string2;
        }
        if (string5.equals(NewJobModel.JOB_WHERE_LOCAL)) {
            string2 = null;
        } else if (string5.equals(NewJobModel.JOB_WHERE_REMOTE)) {
            string2 = actionValuesLookup.get("WHERE_TOP_PANEL/DESTINATION_NONEXEC_CARDPANEL_NAME/WHERE_REMOTE_PANEL/JOB_WHERES_REMOTE_DEST");
        } else if (string5.equals(NewJobModel.JOB_WHERE_MULTIPLE)) {
            string2 = actionValuesLookup.get("WHERE_TOP_PANEL/DESTINATION_NONEXEC_CARDPANEL_NAME/WHERE_MULTIPLE_PANEL/JOB_WHERES_MULTIPLE_DEST");
        }
        if (string2 != null && (string2.equals("") || string2.equals("\"\""))) {
            return null;
        }
        return string2;
    }

    private String getPropertyAutoDrop(ActionValues actionValues) {
        ActionValuesLookup actionValuesLookup = actionValues.getTabLookup("job_advanced_properties_panel");
        String string = actionValuesLookup.get("AUTO_DROP");
        return string;
    }

    private String getPropertyRestartable(ActionValues actionValues) {
        ActionValuesLookup actionValuesLookup = actionValues.getTabLookup("job_advanced_properties_panel");
        String string = actionValuesLookup.get("RESTARTABLE");
        return string;
    }

    private String getPropertyJobStyle(ActionValues actionValues) {
        ActionValuesLookup actionValuesLookup = actionValues.getTabLookup("job_advanced_properties_panel");
        String string = actionValuesLookup.get("JOB_STYLE");
        return string;
    }

    private String getPropertyJobPriority(ActionValues actionValues) {
        ActionValuesLookup actionValuesLookup = actionValues.getTabLookup("job_advanced_properties_panel");
        String string = actionValuesLookup.get("JOB_PRIORITY");
        return string;
    }

    private String getPropertyJobWeight(ActionValues actionValues) {
        ActionValuesLookup actionValuesLookup = actionValues.getTabLookup("job_advanced_properties_panel");
        String string = actionValuesLookup.get("JOB_WEIGHT");
        if (string == null) {
            return this.attributesDefaults.get("job_weight");
        }
        return string;
    }

    private String getPropertyParallelInstances(ActionValues actionValues) {
        ActionValuesLookup actionValuesLookup = actionValues.getTabLookup("job_advanced_properties_panel");
        String string = actionValuesLookup.get("PARALLEL_INSTANCES");
        return string;
    }

    private String getPropertyLoggingLevel(ActionValues actionValues) {
        ActionValuesLookup actionValuesLookup = actionValues.getTabLookup("job_advanced_properties_panel");
        String string = actionValuesLookup.get("LOGGING_LEVEL");
        return string;
    }

    private String getPropertyStopOnWindowClose(ActionValues actionValues) {
        ActionValuesLookup actionValuesLookup = actionValues.getTabLookup("job_advanced_properties_panel");
        String string = actionValuesLookup.get("STOP_ON_WINDOW_CLOSE");
        return string;
    }

    private String getPropertyFollowDefaultTimeZone(ActionValues actionValues) {
        ActionValuesLookup actionValuesLookup = actionValues.getTabLookup("job_advanced_properties_panel");
        String string = actionValuesLookup.get("FOLLOW_DEFAULT_TIME_ZONE");
        return string;
    }

    private String getPropertyInstanceID(ActionValues actionValues) {
        ActionValuesLookup actionValuesLookup = actionValues.getTabLookup("job_advanced_properties_panel");
        String string = actionValuesLookup.get("INSTANCE_ID");
        return string;
    }

    private String getPropertyMaxRuns(ActionValues actionValues) {
        ActionValuesLookup actionValuesLookup = actionValues.getTabLookup("job_advanced_properties_panel");
        String string = actionValuesLookup.get("MAX_RUNS");
        return string;
    }

    private String getPropertyStoreOutput(ActionValues actionValues) {
        ActionValuesLookup actionValuesLookup = actionValues.getTabLookup("job_advanced_properties_panel");
        String string = actionValuesLookup.get("STORE_OUTPUT");
        return string;
    }

    private String getPropertyConnectCredentialName(ActionValues actionValues) {
        ActionValuesLookup actionValuesLookup = actionValues.getTabLookup("job_advanced_properties_panel");
        String string = actionValuesLookup.get("CONNECT_CREDENTIAL_NAME");
        return string;
    }

    private String getPropertyScheduleLimit(ActionValues actionValues) {
        ActionValuesLookup actionValuesLookup = actionValues.getTabLookup("job_advanced_properties_panel");
        String string = actionValuesLookup.get("SCHEDULE_LIMIT");
        return string;
    }

    private String getPropertyMaxRunDuration(ActionValues actionValues) {
        ActionValuesLookup actionValuesLookup = actionValues.getTabLookup("job_advanced_properties_panel");
        String string = actionValuesLookup.get("MAX_RUN_DURATION");
        return string;
    }

    private String getPropertyMaxFailures(ActionValues actionValues) {
        ActionValuesLookup actionValuesLookup = actionValues.getTabLookup("job_advanced_properties_panel");
        String string = actionValuesLookup.get("MAX_FAILURES");
        return string;
    }

    private int getPropertyRaiseEvents(ActionValues actionValues) {
        ActionValuesLookup actionValuesLookup = actionValues.getTabLookup("job_advanced_properties_panel");
        if (actionValuesLookup == null) {
            return 0;
        }
        List list = actionValuesLookup.getList("RAISE_EVENTS", "selected");
        if (list == null) {
            return 0;
        }
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            n += this.raiseEvents.get(iterator.next()).intValue();
        }
        return n;
    }

    private String getDBMSSchedulerCreateJobEmailNotificationCodeGenertorOption() {
        return "JOB_CREATE_ADD_EMAIL_NOTIFICATION";
    }

    private String getDBMSSchedulerRemoveJobEmailNotificationCodeGenertorOption() {
        return "JOB_CLEAR_REMOVE_EMAIL_NOTIFICATION";
    }

    private String makeIdentifier(String string, String string2) {
        String string3 = string + "." + string2;
        if (string3 != null && string3.trim().length() == 0) {
            string3 = null;
        }
        if (string3 != null) {
            string3 = new QualifiedIdentifier(string3).getId();
        }
        return string3;
    }

    public String getEditScript(ActionValues actionValues) {
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        String string = null;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        TreeMap<String, Object> treeMap2 = new TreeMap<String, Object>();
        TreeMap<String, Boolean> treeMap3 = new TreeMap<String, Boolean>();
        TreeMap<String, Boolean> treeMap4 = new TreeMap<String, Boolean>();
        this.populateChangedInformation(actionValues, this.jobModel, treeMap, treeMap2, treeMap3, treeMap4);
        hashtable.put("schema", treeMap);
        hashtable.put("model", treeMap2);
        hashtable.put("changes", treeMap3);
        hashtable.put("isnull", treeMap4);
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        String string2 = this.jobModel.getDBVersion();
        String string3 = this.getDBMSSchedulerEditJobGeneratorOption(this.getJobWhatFromAC(actionValues), this.getJobWhereFromAC(actionValues));
        string = dBMSSchedulerCodeGenerator.generate(string2, string3, hashtable).trim();
        if (string.startsWith("BEGIN")) {
            string = string.substring(6).trim();
        }
        if (string.endsWith("END;")) {
            string = string.substring(0, string.length() - 4).trim();
        } else if (string.endsWith("END")) {
            string = string.substring(0, string.length() - 3).trim();
        }
        String[] stringArray = this.replaceNullWithString(this.jobModel.getPreviousJobJobArgData(), "");
        String[] stringArray2 = this.replaceNullWithString(this.getJobArguments(this.getJobWhatFromAC(actionValues), actionValues), "");
        if (!this.checkEquality(stringArray, stringArray2)) {
            Object object4;
            int n;
            String string4;
            if (stringArray != null && stringArray.length > 0) {
                string4 = "JOB_EDIT_RESET_ARGUMENT_BY_POSITION";
                for (n = 0; n < stringArray.length; ++n) {
                    object3 = new Integer(n + 1);
                    object2 = new Hashtable();
                    object2.put("argument_position", object3);
                    object = new TreeMap();
                    object.put("args", object2);
                    object.put("model", treeMap2);
                    object4 = dBMSSchedulerCodeGenerator.generate(string2, string4, (Map<String, Object>)object);
                    string = string + "\n" + (String)object4;
                }
            }
            if (stringArray2 != null && stringArray2.length > 0) {
                string4 = "JOB_CREATE_SET_ARGUMENT_BY_POSITION";
                for (n = 0; n < stringArray2.length; ++n) {
                    object3 = stringArray2[n];
                    if (object3 == null) {
                        object3 = "";
                    }
                    object2 = object3;
                    object = new Integer(n + 1);
                    object4 = new Hashtable<String, Object>();
                    object4.put("argument_value", object2);
                    object4.put("argument_position", object);
                    TreeMap<String, Object> treeMap5 = new TreeMap<String, Object>();
                    treeMap5.put("args", object4);
                    treeMap5.put("model", treeMap2);
                    String string5 = dBMSSchedulerCodeGenerator.generate(string2, string4, treeMap5);
                    string = string + "\n" + string5;
                }
            }
        }
        boolean bl2 = bl = (Boolean)treeMap3.get("recipients") != false || (Boolean)treeMap3.get("sender") != false || (Boolean)treeMap3.get("filter_condition") != false || (Boolean)treeMap3.get("subject") != false || (Boolean)treeMap3.get("body") != false || (Boolean)treeMap3.get("events") != false;
        if (bl) {
            String string6 = this.getDBMSSchedulerRemoveJobEmailNotificationCodeGenertorOption();
            object3 = dBMSSchedulerCodeGenerator.generate(string2, string6, hashtable);
            string = string + "\n" + object3;
            object2 = this.getDBMSSchedulerCreateJobEmailNotificationCodeGenertorOption();
            object = dBMSSchedulerCodeGenerator.generate(string2, (String)object2, hashtable);
            string = string + "\n" + (String)object;
        }
        String string7 = this.getSchedulerEditEnableGeneratorOption();
        if ((string = string + "\n" + dBMSSchedulerCodeGenerator.generate(string2, string7, hashtable).trim()).trim().length() > 0) {
            string = "BEGIN\n" + string + "\nEND; \n/";
        }
        return string;
    }

    private String getSchedulerEditGeneratorOption_Basic() {
        return "JOB_UPDATE_BASIC";
    }

    private String getSchedulerEditGeneratorOption_Program_Schedule() {
        return "JOB_UPDATE_PROG_SCHED";
    }

    private String getSchedulerEditGeneratorOption_Program_Event() {
        return "JOB_UPDATE_PROG_EVENT";
    }

    private String getSchedulerEditGeneratorOption_Program_InlineSchedule() {
        return "JOB_UPDATE_PROG_INLINE_SCHED";
    }

    private String getSchedulerEditGeneratorOption_InlineProgram_Event() {
        return "JOB_UPDATE_INLINE_PROG_EVENT";
    }

    private String getSchedulerEditEnableGeneratorOption() {
        return "JOB_UPDATE_ENABLED";
    }

    public void printActionControlNames(ActionValues actionValues) {
        Set set;
        Set set2;
        Set set3;
        System.out.println("Data Collection Begins =================================");
        System.out.println("=================================");
        Set set4 = actionValues.getListNames();
        this.printSet(set4, "listNames");
        System.out.println("---------------------------------");
        Set set5 = actionValues.getNames();
        this.printSet(set5, "names");
        System.out.println("---------------------------------");
        Set set6 = actionValues.getTabNames();
        this.printSet(set6, "tabnames");
        System.out.println("---------------------------------");
        ActionValuesLookup actionValuesLookup = actionValues.getTabLookup("job_destination_panel");
        if (actionValuesLookup != null) {
            set3 = actionValuesLookup.getNames();
            System.out.println("------------");
            this.printSet(set3, "job_dests");
            set2 = actionValuesLookup.getListNames();
            this.printSet(set2, "job_dest_list");
        }
        System.out.println("---------------------------------");
        set3 = actionValues.getTabLookup("job_arguments_panel");
        set2 = set3.getNames();
        this.printSet(set2, "job_jas");
        Set set7 = set3.getListNames();
        this.printSet(set7, "job_jas_list");
        set3.getNames();
        System.out.println("---------------------------------");
        ActionValuesLookup actionValuesLookup2 = actionValues.getTabLookup("job_email_notification_panel");
        if (actionValuesLookup2 != null) {
            set = actionValuesLookup2.getNames();
            this.printSet(set, "not_names");
            System.out.println("---------------------------------");
        }
        set = actionValues.getTabLookup("job_advanced_properties_panel");
        Set set8 = set.getNames();
        this.printSet(set8, "ap_names");
        System.out.println("=================================");
        System.out.println("Data Collection ends =================================");
    }

    private boolean checkequals(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        if (string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    private boolean checkequals(String[] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            return stringArray2 == null;
        }
        if (stringArray2 == null) {
            return false;
        }
        int n = stringArray.length;
        int n2 = stringArray2.length;
        if (n != n2) {
            return false;
        }
        int n3 = 0;
        block0: for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (!stringArray[i].trim().equals(stringArray2[j].trim())) continue;
                ++n3;
                continue block0;
            }
        }
        return n3 == n;
    }

    private boolean checkEquality(String[] stringArray, String[] stringArray2) {
        boolean bl = true;
        if (stringArray == null) {
            return stringArray2 == null;
        }
        if (stringArray2 == null) {
            return false;
        }
        int n = stringArray.length;
        int n2 = stringArray2.length;
        if (n != n2) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (stringArray[i].trim().equals(stringArray2[i].trim())) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private void populatePropertyChanges(ActionValues actionValues, NewJobModel newJobModel, Map<String, Object> map, Map<String, Boolean> map2, Map<String, Boolean> map3) {
        String string = this.getPropertyAutoDrop(actionValues);
        String string2 = this.getPropertyRestartable(actionValues);
        String string3 = this.getPropertyJobPriority(actionValues);
        String string4 = this.getPropertyJobWeight(actionValues);
        String string5 = this.getPropertyJobStyle(actionValues);
        String string6 = this.getPropertyParallelInstances(actionValues);
        String string7 = this.getPropertyLoggingLevel(actionValues);
        String string8 = this.getPropertyStopOnWindowClose(actionValues);
        String string9 = this.getPropertyFollowDefaultTimeZone(actionValues);
        String string10 = this.getPropertyInstanceID(actionValues);
        String string11 = this.getPropertyMaxRuns(actionValues);
        String string12 = this.getPropertyStoreOutput(actionValues);
        String string13 = this.getConnectCredential(actionValues);
        String string14 = this.getPropertyMaxRunDuration(actionValues);
        String string15 = this.getPropertyScheduleLimit(actionValues);
        String string16 = this.getPropertyMaxFailures(actionValues);
        int n = this.getPropertyRaiseEvents(actionValues);
        String string17 = (String)newJobModel.getPreviousJobData("oldAutoDrop");
        String string18 = (String)newJobModel.getPreviousJobData("oldRestartable");
        String string19 = (String)newJobModel.getPreviousJobData("oldJobPriority");
        String string20 = (String)newJobModel.getPreviousJobData("oldJobWeight");
        String string21 = (String)newJobModel.getPreviousJobData("oldParallelInstances");
        String string22 = newJobModel.getLoggingLevelPreviousJobData();
        String string23 = (String)newJobModel.getPreviousJobData("oldStopOnWindowClose");
        String string24 = (String)newJobModel.getPreviousJobData("oldFollowDefaultTimeZone");
        String string25 = (String)newJobModel.getPreviousJobData("oldInstanceId");
        OraINTERVALDS oraINTERVALDS = (OraINTERVALDS)newJobModel.getPreviousJobData("oldMaxRunDuration");
        String string26 = null;
        if (oraINTERVALDS != null) {
            string26 = oraINTERVALDS.toString();
        }
        OraINTERVALDS oraINTERVALDS2 = (OraINTERVALDS)newJobModel.getPreviousJobData("oldScheduleLimit");
        String string27 = null;
        if (oraINTERVALDS2 != null) {
            string27 = oraINTERVALDS2.toString();
        }
        String string28 = (String)newJobModel.getPreviousJobData("oldMaxRuns");
        String string29 = (String)newJobModel.getPreviousJobData("oldStoreOutput");
        String string30 = (String)newJobModel.getPreviousJobData("oldConnectCredentialOwner");
        String string31 = null;
        if (string30 != null) {
            string31 = "\"" + string30 + "\"" + ".\"" + (String)newJobModel.getPreviousJobData("oldConnectCredentialName") + "\"";
        }
        String string32 = (String)newJobModel.getPreviousJobData("oldMaxFailures");
        int n2 = newJobModel.getRaisedEventsPreviousJobData();
        if (!this.checkequals(string, string17)) {
            map2.put("auto_drop", new Boolean(true));
            map.put("auto_drop", string);
        } else {
            map2.put("auto_drop", new Boolean(false));
            map.put("auto_drop", string17);
        }
        if (!this.checkequals(string2, string18)) {
            map2.put("restartable", new Boolean(true));
            map.put("restartable", string2);
        } else {
            map2.put("restartable", new Boolean(false));
            map.put("restartable", string18);
        }
        if (!this.checkequals(string3, string19)) {
            map2.put("job_priority", new Boolean(true));
            map.put("job_priority", string3);
        } else {
            map2.put("job_priority", new Boolean(false));
            map.put("job_priority", string19);
        }
        if (!this.checkequals(string4, string20)) {
            map2.put("job_weight", new Boolean(true));
            map.put("job_weight", string4);
        } else {
            map2.put("job_weight", new Boolean(false));
            map.put("job_weight", string20);
        }
        if (string6 != null) {
            if (!this.checkequals(string6, string21)) {
                map2.put("parallel_instances", new Boolean(true));
                map.put("parallel_instances", string6);
            } else {
                map2.put("parallel_instances", new Boolean(false));
                map.put("parallel_instances", string21);
            }
        } else {
            map3.put("parallel_instances", new Boolean(true));
        }
        if (!this.checkequals(string7, string22)) {
            map2.put("logging_level", new Boolean(true));
            map.put("logging_level", string7);
        } else {
            map2.put("logging_level", new Boolean(false));
            map.put("logging_level", string22);
        }
        if (!this.checkequals(string8, string23)) {
            map2.put("stop_on_window_close", new Boolean(true));
            map.put("stop_on_window_close", string8);
        } else {
            map2.put("stop_on_window_close", new Boolean(false));
            map.put("stop_on_window_close", string23);
        }
        if (newJobModel.FeatureMin112()) {
            if (string9 != null) {
                if (!this.checkequals(string9, string24)) {
                    map2.put("follow_default_timezone", new Boolean(true));
                    map.put("follow_default_timezone", string9);
                } else {
                    map2.put("follow_default_timezone", new Boolean(false));
                    map.put("follow_default_timezone", string24);
                }
            } else {
                map3.put("follow_default_timezone", new Boolean(true));
            }
        }
        if (!this.checkequals(string10, string25)) {
            map2.put("instance_id", new Boolean(true));
            if (string10 != null) {
                map.put("instance_id", string10);
            } else {
                map3.put("instance_id", new Boolean(true));
            }
        } else {
            map2.put("instance_id", new Boolean(false));
            map.put("instance_id", string25);
        }
        if (!this.checkequals(string12, string29)) {
            map2.put("store_output", new Boolean(true));
            map.put("store_output", string12);
        } else {
            map2.put("store_output", new Boolean(false));
            map.put("store_output", string29);
        }
        if (!this.checkequals(string13, string31)) {
            map2.put("connect_credential_name", new Boolean(true));
            if (string13 != null) {
                map.put("connect_credential_name", string13);
            } else {
                map3.put("connect_credential_name", new Boolean(true));
            }
        } else {
            map2.put("connect_credential_name", new Boolean(false));
            map.put("connect_credential_name", string31);
        }
        if (!this.checkequals(string11, string28)) {
            map2.put("max_runs", new Boolean(true));
            if (string11 != null) {
                map.put("max_runs", string11);
            } else {
                map3.put("max_runs", new Boolean(true));
            }
        } else {
            map2.put("max_runs", new Boolean(false));
            map.put("max_runs", string28);
        }
        if (!this.checkequals(string14, string26)) {
            map2.put("max_run_duration", new Boolean(true));
            if (string14 != null) {
                map.put("max_run_duration", string14);
            } else {
                map3.put("max_run_duration", new Boolean(true));
            }
        } else {
            map2.put("max_run_duration", new Boolean(false));
            map.put("max_run_duration", string26);
        }
        if (!this.checkequals(string15, string27)) {
            map2.put("schedule_limit", new Boolean(true));
            if (string15 != null) {
                map.put("schedule_limit", string15);
            } else {
                map3.put("schedule_limit", new Boolean(true));
            }
        } else {
            map2.put("schedule_limit", new Boolean(false));
            map.put("schedule_limit", string28);
        }
        if (!this.checkequals(string16, string32)) {
            map2.put("max_failures", new Boolean(true));
            if (string16 != null) {
                map.put("max_failures", string16);
            } else {
                map3.put("max_failures", new Boolean(true));
            }
        } else {
            map2.put("max_failures", new Boolean(false));
            map.put("max_failures", string16);
        }
        if (n != n2) {
            map2.put("raise_events", new Boolean(true));
            map.put("raise_events", n);
        } else {
            map2.put("raise_events", new Boolean(false));
            map.put("raise_events", n2);
        }
    }

    private void populateNotificationChanges(ActionValues actionValues, NewJobModel newJobModel, Map<String, Object> map, Map<String, Boolean> map2, Map<String, Boolean> map3) {
        String string;
        String string2 = newJobModel.getJobNotificationData("oldJobNotificationRecipient");
        if (!this.checkequals(string2, string = this.getNotificationRecipients(actionValues))) {
            map2.put("recipients", new Boolean(true));
            map.put("recipients", string);
        } else {
            map2.put("recipients", new Boolean(false));
            map.put("recipients", string2);
        }
        String string3 = newJobModel.getJobNotificationData("oldJobNotificationSender");
        String string4 = this.getNotificationSender(actionValues);
        if (!this.checkequals(string3, string4)) {
            map2.put("sender", new Boolean(true));
            map.put("sender", string4);
            if (string4 == null) {
                map3.put("sender", new Boolean(true));
            } else {
                map3.put("sender", new Boolean(false));
            }
        } else {
            map2.put("sender", new Boolean(false));
            map.put("sender", string3);
        }
        String string5 = newJobModel.getJobNotificationData("oldJobNotificationSubject");
        String string6 = this.getNotificationSubject(actionValues);
        if (!this.checkequals(string5, string6)) {
            map2.put("subject", new Boolean(true));
            map.put("subject", string6);
        } else {
            map2.put("subject", new Boolean(false));
            map.put("subject", string5);
        }
        String string7 = newJobModel.getJobNotificationData("oldJobNotificationBody");
        String string8 = this.getNotificationBody(actionValues);
        String string9 = null;
        String string10 = null;
        if (string8 != null) {
            string10 = string8.replaceAll("(\r\n|\r|\n|\n\r)", "");
        }
        if (string7 != null) {
            string9 = string7.replaceAll("(\r\n|\r|\n|\n\r)", "");
        }
        if (!this.checkequals(string9, string10)) {
            map2.put("body", new Boolean(true));
            map.put("body", string8);
        } else {
            map2.put("body", new Boolean(false));
            map.put("body", string7);
        }
        String string11 = newJobModel.getJobNotificationData("oldJobNotificationSelectedEvents");
        String[] stringArray = null;
        if (string11 != null) {
            stringArray = string11.split(",");
        }
        String string12 = this.getNotificationSelectedEvents(actionValues);
        String[] stringArray2 = null;
        if (string12 != null) {
            string12 = string12.trim().toUpperCase();
            stringArray2 = string12.split(",");
        }
        if (stringArray != null) {
            if (!this.checkequals(stringArray, stringArray2)) {
                map2.put("events", new Boolean(true));
                map.put("events", string12);
            } else {
                map2.put("events", new Boolean(false));
                map.put("events", string11);
            }
        } else if (string != null && string.length() > 0 && stringArray2 != null && stringArray2.length > 0) {
            map2.put("events", new Boolean(true));
            map.put("events", string12);
        } else {
            map2.put("events", new Boolean(false));
            map.put("events", string11);
        }
        String string13 = newJobModel.getJobNotificationData("oldJobNotificationFilterCondition");
        String string14 = this.getNotificationFilterCondition(actionValues);
        if (!this.checkequals(string13, string14)) {
            map2.put("filter_condition", new Boolean(true));
            map.put("filter_condition", string14);
            if (string14 == null) {
                map3.put("filter_condition", new Boolean(true));
            } else {
                map3.put("filter_condition", new Boolean(false));
            }
        } else {
            map2.put("filter_condition", new Boolean(false));
            map.put("filter_condition", string13);
        }
    }

    private void populateChangedInformation(ActionValues actionValues, NewJobModel newJobModel, Map<String, String> map, Map<String, Object> map2, Map<String, Boolean> map3, Map<String, Boolean> map4) {
        String string = (String)newJobModel.getPreviousJobData("oldObjectName");
        String string2 = (String)newJobModel.getPreviousJobData("oldOwner");
        map2.put("name", string);
        map2.put("owner", string2);
        map.put("schema", "owner");
        boolean bl = new Boolean((String)newJobModel.getPreviousJobData("oldEnabled"));
        boolean bl2 = this.getEnabledFromAC(actionValues);
        if (bl != bl2) {
            map3.put("enabled", new Boolean(true));
        } else {
            map3.put("enabled", new Boolean(false));
        }
        if (bl2) {
            map2.put("enabled", new Boolean(true));
        } else {
            map2.put("enabled", new Boolean(false));
        }
        String string3 = (String)newJobModel.getPreviousJobData("oldComments");
        String string4 = this.getJobDesciptionFromAC(actionValues);
        if (!this.checkequals(string3, string4)) {
            map3.put("comments", new Boolean(true));
            if (string4 == null || string4.length() == 0) {
                map4.put("comments", new Boolean(true));
                map2.put("comments", string4);
            } else {
                map2.put("comments", string4.replaceAll("'", "''"));
            }
        } else {
            map3.put("comments", new Boolean(false));
            map2.put("comments", string3);
        }
        String string5 = (String)newJobModel.getPreviousJobData("oldJobclass");
        String string6 = this.getJobClassFromAC(actionValues);
        if (!this.checkequals(string5, string6)) {
            map3.put("job_class", new Boolean(true));
            if (string6 == null || string6.equals("")) {
                map4.put("job_class", new Boolean(true));
            }
            map2.put("job_class", string6);
        } else {
            map3.put("job_class", new Boolean(false));
            map2.put("job_class", string5);
        }
        String string7 = (String)newJobModel.getPreviousJobData("oldJobType");
        String string8 = this.getJobType(this.getJobWhatFromAC(actionValues), actionValues);
        if (!this.checkequals(string7, string8)) {
            map3.put("job_type", new Boolean(true));
            if (string8 == null) {
                map4.put("job_type", new Boolean(true));
            }
            map2.put("job_type", string8);
        } else {
            map3.put("job_type", new Boolean(false));
            map2.put("job_type", string7);
        }
        String string9 = (String)newJobModel.getPreviousJobData("oldJobAction");
        if (string9 == null) {
            string9 = "";
        }
        String string10 = this.getJobAction(this.getJobWhatFromAC(actionValues), actionValues);
        String string11 = null;
        String string12 = null;
        if (string10 != null) {
            string12 = string10.replaceAll("(\r\n|\r|\n|\n\r)", "");
        }
        if (string9 != null) {
            string11 = string9.replaceAll("(\r\n|\r|\n|\n\r)", "");
        }
        if (!this.checkequals(string11, string12)) {
            map3.put("job_action", new Boolean(true));
            if (string10 == null) {
                map4.put("job_action", new Boolean(true));
                map2.put("job_action", string10);
            } else {
                map2.put("job_action", string10.replaceAll("'", "''"));
            }
        } else {
            map3.put("job_action", new Boolean(false));
            map2.put("job_action", string9);
        }
        String string13 = (String)newJobModel.getPreviousJobData("oldProgramName");
        String string14 = this.getOnlyProgramName(this.getProgramName(this.getJobWhatFromAC(actionValues), actionValues));
        if (!this.checkequals(string13, string14)) {
            map3.put("program_name", new Boolean(true));
            if (string14 == null) {
                map4.put("program_name", new Boolean(true));
            }
            map2.put("program_name", string14);
        } else {
            map3.put("program_name", new Boolean(false));
            map2.put("program_name", string13);
        }
        map2.put("event_condition", this.wrapQuotes(this.getJobEventConditionFromAC(actionValues)));
        map2.put("end_date", this.getJobEventEndDateFromAC(actionValues));
        map2.put("start_date", this.getJobEventStartDateFromAC(actionValues));
        map2.put("queue_spec", this.getJobQueueSpecFromAC(actionValues));
        map2.put("repeat_interval", this.getJobRepeatIntervalFromAC(actionValues));
        map2.put("schedule_spec", this.getJobScheduleSpecFromAC(actionValues));
        newJobModel.getWhenModel().getChanges(map3);
        newJobModel.getWhenModel().getIsNull(map4);
        String string15 = (String)newJobModel.getPreviousJobData("oldCredentialName");
        String string16 = (String)newJobModel.getPreviousJobData("oldCredentialOwner");
        string15 = string15 == null || string15.trim().length() == 0 ? null : "\"" + string16 + "\"." + "\"" + string15 + "\"";
        String string17 = this.getCredential(this.getJobWhatFromAC(actionValues), actionValues);
        if (!this.checkequals(string15, string17)) {
            map3.put("credential_name", new Boolean(true));
            if (string17 == null) {
                map4.put("credential_name", new Boolean(true));
            }
            map2.put("credential_name", string17);
        } else {
            map3.put("credential_name", new Boolean(false));
            map2.put("credential_name", string15);
        }
        String string18 = (String)newJobModel.getPreviousJobData("oldDestinationName");
        String string19 = (String)newJobModel.getPreviousJobData("oldDestinationOwner");
        string18 = string18 == null || string18.trim().length() == 0 ? null : "\"" + string19 + "\"." + "\"" + string18 + "\"";
        String string20 = this.getDestination(this.getJobWhatFromAC(actionValues), actionValues);
        if (!this.checkequals(string18, string20)) {
            map3.put("destination_name", new Boolean(true));
            if (string20 == null || string20.equals("")) {
                map4.put("destination_name", new Boolean(true));
            }
            map2.put("destination_name", string20);
        } else {
            map3.put("destination_name", new Boolean(false));
            map2.put("destination_name", string18);
        }
        int n = new Integer((Integer)newJobModel.getPreviousJobData("oldNumArgs"));
        String[] stringArray = this.getJobArguments(this.getJobWhatFromAC(actionValues), actionValues);
        int n2 = 0;
        if (stringArray != null) {
            n2 = stringArray.length;
        }
        if (n != n2) {
            map3.put("number_of_arguments", new Boolean(true));
            map2.put("number_of_arguments", n2);
        } else {
            map3.put("number_of_arguments", new Boolean(false));
            map2.put("number_of_arguments", n);
        }
        this.populateNotificationChanges(actionValues, newJobModel, map2, map3, map4);
        this.populatePropertyChanges(actionValues, newJobModel, map2, map3, map4);
    }

    private String getJobNameFromAC(ActionValues actionValues) {
        String string = actionValues.get("NAME_ENABLED/JOB_NAME");
        return string;
    }

    private boolean getEnabledFromAC(ActionValues actionValues) {
        boolean bl = new Boolean(actionValues.get("ENABLED"));
        return bl;
    }

    private String getJobDesciptionFromAC(ActionValues actionValues) {
        String string = actionValues.get("COMMENTS");
        if (string != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    private String getJobClassFromAC(ActionValues actionValues) {
        String string = actionValues.get("JOB_CLASS");
        return string;
    }

    private String getJobWhatFromAC(ActionValues actionValues) {
        String string = actionValues.get("WHAT_WHEN/WHAT_JOB_TYPE_PANEL_NAME");
        return string;
    }

    private ScheduleWhenModel.EventType getJobWhereFromAC(ActionValues actionValues) {
        String string = actionValues.get("WHAT_WHEN/WHEN_JOB_TYPE_PANEL_NAME", ScheduleWhenModel.Property.EVENT_TYPE.getValueName());
        ScheduleWhenModel.EventType eventType = string != null ? ScheduleWhenModel.EventType.valueOf(string) : null;
        return eventType;
    }

    private String getJobEventConditionFromAC(ActionValues actionValues) {
        String string = actionValues.get("WHAT_WHEN/WHEN_JOB_TYPE_PANEL_NAME", ScheduleWhenModel.Property.EVENT_CONDITION.getValueName());
        if (string != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    private String getJobEventEndDateFromAC(ActionValues actionValues) {
        String string = actionValues.get("WHAT_WHEN/WHEN_JOB_TYPE_PANEL_NAME", ScheduleWhenModel.Property.END_DATE.getValueName());
        if (string != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    private String getJobEventStartDateFromAC(ActionValues actionValues) {
        String string = actionValues.get("WHAT_WHEN/WHEN_JOB_TYPE_PANEL_NAME", ScheduleWhenModel.Property.START_DATE.getValueName());
        if (string != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    private String getJobQueueSpecFromAC(ActionValues actionValues) {
        String string = actionValues.get("WHAT_WHEN/WHEN_JOB_TYPE_PANEL_NAME", ScheduleWhenModel.QUEUE_SPEC);
        if (string != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    private String getJobRepeatIntervalFromAC(ActionValues actionValues) {
        String string = actionValues.get("WHAT_WHEN/WHEN_JOB_TYPE_PANEL_NAME", ScheduleWhenModel.Property.REPEAT_INTERVAL.getValueName());
        if (string != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    private String getJobScheduleSpecFromAC(ActionValues actionValues) {
        String string = actionValues.get("WHAT_WHEN/WHEN_JOB_TYPE_PANEL_NAME", ScheduleWhenModel.SCHEDULE_SPEC);
        if (string != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    private String getDBMSSchedulerEditJobGeneratorOption(String string, ScheduleWhenModel.EventType eventType) {
        String string2 = NewJobModel.JOB_TYPE_PLSQL_BLOCK;
        String string3 = NewJobModel.JOB_TYPE_CHAIN;
        String string4 = NewJobModel.JOB_TYPE_STORED_PROCEDURE;
        String string5 = NewJobModel.JOB_TYPE_REMOTE_STORED_PROCEDURE;
        String string6 = NewJobModel.JOB_TYPE_NAMED_PROGRAM;
        String string7 = NewJobModel.JOB_TYPE_EXECUTABLE;
        String string8 = NewJobModel.JOB_TYPE_SCRIPT;
        if (eventType != null && string != null) {
            if (string.equals(string6)) {
                switch (eventType.getScheduleType()) {
                    case NAMED: 
                    case WINDOW: 
                    case WINDOW_GROUP: {
                        return "JOB_UPDATE_PROG_SCHED";
                    }
                    case IMMEDIATE: 
                    case ONCE: 
                    case CALENDAR: {
                        return "JOB_UPDATE_PROG_INLINE_SCHED";
                    }
                    case EVENT: {
                        return "JOB_UPDATE_PROG_EVENT";
                    }
                }
            } else if (string.equals(string3)) {
                switch (eventType.getScheduleType()) {
                    case NAMED: 
                    case WINDOW: 
                    case WINDOW_GROUP: {
                        return "JOB_UPDATE_PROG_SCHED";
                    }
                    case IMMEDIATE: 
                    case ONCE: 
                    case CALENDAR: {
                        return "JOB_UPDATE_BASIC";
                    }
                    case EVENT: {
                        return "JOB_UPDATE_INLINE_PROG_EVENT";
                    }
                }
            } else if (string.equals(string2) || string.equals(string4) || string.equals(string5)) {
                switch (eventType.getScheduleType()) {
                    case NAMED: 
                    case WINDOW: 
                    case WINDOW_GROUP: {
                        return "JOB_UPDATE_INLINE_PROG_SCHED";
                    }
                    case IMMEDIATE: 
                    case ONCE: 
                    case CALENDAR: {
                        return "JOB_UPDATE_BASIC";
                    }
                    case EVENT: {
                        return "JOB_UPDATE_INLINE_PROG_EVENT";
                    }
                }
            } else if (string.equals(string7) || string.equals(string8)) {
                switch (eventType.getScheduleType()) {
                    case NAMED: 
                    case WINDOW: 
                    case WINDOW_GROUP: {
                        return "JOB_UPDATE_INLINE_PROG_SCHED";
                    }
                    case IMMEDIATE: 
                    case ONCE: 
                    case CALENDAR: {
                        return "JOB_UPDATE_BASIC";
                    }
                    case EVENT: {
                        return "CREATE_JOB_INLINE_PROG_AND_EVENT";
                    }
                }
            }
        }
        return "JOB_UPDATE_BASIC";
    }

    private String getOnlyProgramName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        if (string.contains(".")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            int n = stringTokenizer.countTokens();
            if (n == 1) {
                string2 = stringTokenizer.nextToken().trim();
            } else if (n == 2) {
                String string3 = stringTokenizer.nextToken().trim();
                string2 = stringTokenizer.nextToken().trim();
            } else {
                string2 = string;
            }
            if (string2.startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
        }
        return string2;
    }

    private String stripQuotes(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1).trim();
        }
        return string;
    }

    private String wrapQuotes(String string) {
        return string != null ? string.replaceAll("'", "''") : string;
    }

    private String[] replaceNullWithString(String[] stringArray, String string) {
        if (stringArray == null) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null) continue;
            stringArray[i] = string;
        }
        return stringArray;
    }
}

