/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.editors.chain;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import javax.swing.JComponent;
import oracle.dbtools.raptor.oviewer.base.ViewerEditor;
import oracle.ide.Context;
import oracle.ide.print.DocumentPrintFactory;
import oracle.ide.print.PageableFactory;
import oracle.ide.print.PrintManager;

public class ChainEditorPrintFactory
extends DocumentPrintFactory
implements PageableFactory {
    public void create(Context context) {
        ViewerEditor viewerEditor = (ViewerEditor)context.getView();
        Object object = viewerEditor.getPrintable();
        PrintManager.getPrintManager().setPageable(this.create(null, object, PrintManager.getPrintManager().getPageFormat()));
    }

    public Pageable create(Object object, PageFormat pageFormat) {
        return this.create(null, object, pageFormat);
    }

    public Pageable create(Context context, Object object, PageFormat pageFormat) {
        return new ChainPageable((JComponent)object, pageFormat);
    }

    private class ChainPageable
    implements Pageable {
        PageFormat pageFormat = null;
        JComponent comp = null;
        Dimension size = null;
        int widthInPages = 0;
        int heightInPages = 0;

        public ChainPageable(JComponent jComponent, PageFormat pageFormat) {
            this.pageFormat = pageFormat;
            this.comp = jComponent;
            this.size = jComponent.getSize();
            this.widthInPages = (int)((this.size.getWidth() + pageFormat.getImageableWidth() - 1.0) / pageFormat.getImageableWidth());
            this.heightInPages = (int)((this.size.getHeight() + pageFormat.getImageableHeight() - 1.0) / pageFormat.getImageableHeight());
        }

        @Override
        public int getNumberOfPages() {
            return 1;
        }

        @Override
        public PageFormat getPageFormat(int n) {
            return this.pageFormat;
        }

        @Override
        public Printable getPrintable(int n) {
            if (n >= this.getNumberOfPages()) {
                throw new IndexOutOfBoundsException("No more pages");
            }
            return new Printable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public int print(Graphics graphics, PageFormat pageFormat, int n) {
                    double d = ChainPageable.this.pageFormat.getHeight();
                    double d2 = ChainPageable.this.pageFormat.getWidth();
                    double d3 = ChainPageable.this.pageFormat.getImageableX();
                    double d4 = ChainPageable.this.pageFormat.getImageableY();
                    double d5 = ChainPageable.this.pageFormat.getImageableHeight();
                    double d6 = ChainPageable.this.pageFormat.getImageableWidth();
                    int n2 = n / ChainPageable.this.widthInPages;
                    int n3 = n - n2 * ChainPageable.this.widthInPages;
                    double d7 = (double)n3 * d6;
                    double d8 = (double)n2 * d5;
                    System.out.println("Page=" + n + "\n" + "    imageableX=" + d3 + ", imageableY=" + d4 + "\n" + "    imageableWidth=" + d6 + ", imageableHeight=" + d5 + "\n" + "    imageX=" + d7 + ", comp.width=" + ChainPageable.this.comp.getWidth() + "\n" + "    imageY=" + d8 + ", comp.height=" + ChainPageable.this.comp.getHeight());
                    if (n >= ChainPageable.this.widthInPages * ChainPageable.this.heightInPages) {
                        return 1;
                    }
                    int n4 = 0;
                    try {
                        graphics.translate(-((int)d7), -((int)d8));
                        ChainPageable.this.comp.print(graphics);
                        n4 = 0;
                    }
                    finally {
                        graphics.translate((int)d7, (int)d8);
                    }
                    return n4;
                }
            };
        }
    }
}

